/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfret.source.GlobalSourcePath;
import org.netbeans.modules.gsfret.source.usages.ClassIndexFactory;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndex
extends Index {
    private static final Logger LOGGER = Logger.getLogger(ClassIndex.class.getName());
    private final Language language;
    private final ClassPath bootPath;
    private final ClassPath classPath;
    private final ClassPath sourcePath;
    private Set<ClassIndexImpl> sourceIndeces;
    private Set<ClassIndexImpl> depsIndeces;

    ClassIndex(Language language, ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        this.language = language;
        this.bootPath = classPath;
        this.classPath = classPath2;
        this.sourcePath = classPath3;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void search(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, Set<Index.SearchResult> set2, Set<String> set3) throws IOException {
        assert (string != null);
        assert (string2 != null);
        assert (nameKind != null);
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set);
        for (ClassIndexImpl classIndexImpl : iterable) {
            try {
                classIndexImpl.search(string, string2, nameKind, set, set2, set3);
            }
            catch (ClassIndexImpl.IndexAlreadyClosedException indexAlreadyClosedException) {
                ClassIndex.logClosedIndex(classIndexImpl);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ClassIndex.search returned %d elements\n", set2.size()));
        }
    }

    public void initForTest(Set<ClassIndexImpl> set) {
        this.sourceIndeces = set;
    }

    private static void logClosedIndex(ClassIndexImpl classIndexImpl) {
        assert (classIndexImpl != null);
        LOGGER.info("Ignoring closed index: " + classIndexImpl.toString());
    }

    private synchronized Iterable<? extends ClassIndexImpl> getQueries(Set<Index.SearchScope> set) {
        HashSet<ClassIndexImpl> hashSet;
        HashSet<ClassIndexImpl> hashSet2 = new HashSet<ClassIndexImpl>();
        if (set.contains(Index.SearchScope.SOURCE)) {
            if (this.sourceIndeces == null) {
                hashSet = new HashSet<ClassIndexImpl>();
                ClassIndex.createQueriesForRoots(this.language, this.sourcePath, true, hashSet);
                this.sourceIndeces = hashSet;
            }
            hashSet2.addAll(this.sourceIndeces);
        }
        if (set.contains(Index.SearchScope.DEPENDENCIES)) {
            if (this.depsIndeces == null) {
                hashSet = new HashSet();
                List list = this.classPath.entries();
                if (list.size() > 0) {
                    ClassIndex.createQueriesForRoots(this.language, this.bootPath, false, hashSet);
                }
                LanguageRegistry.getInstance().getLibraryUrls();
                Set<ClassIndexImpl> set2 = ClassIndexManager.get(this.language).getBootIndices();
                Indexer indexer = this.language.getIndexer();
                if (indexer != null) {
                    for (ClassIndexImpl classIndexImpl : set2) {
                        URL uRL;
                        if (classIndexImpl == null || (uRL = classIndexImpl.getRoot()) == null || !indexer.acceptQueryPath(uRL.toExternalForm())) continue;
                        hashSet.add(classIndexImpl);
                    }
                }
                ClassIndex.createQueriesForRoots(this.language, this.classPath, false, hashSet);
                this.depsIndeces = hashSet;
            }
            hashSet2.addAll(this.depsIndeces);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ClassIndex.queries[Scope=%s, sourcePath=%s, bootPath=%s, classPath=%s] => %s\n", set, this.sourcePath, this.bootPath, this.classPath, hashSet2));
        }
        return hashSet2;
    }

    public static void createQueriesForRoots(Language language, ClassPath classPath, boolean bl, Set<? super ClassIndexImpl> set) {
        GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
        List list = classPath.entries();
        Indexer indexer = language.getIndexer();
        if (indexer == null) {
            return;
        }
        for (ClassPath.Entry entry : list) {
            try {
                URL[] uRLArray;
                if (!indexer.acceptQueryPath(entry.getURL().toExternalForm())) continue;
                if (!bl) {
                    URL[] uRLArray2 = org.netbeans.modules.gsfret.source.usages.Index.getSourceRootForClassFolder(language, entry.getURL());
                    if (uRLArray2 != null) {
                        uRLArray = new URL[]{uRLArray2};
                    } else {
                        uRLArray = globalSourcePath.getSourceRootForBinaryRoot(entry.getURL(), classPath, true);
                        if (uRLArray == null) {
                            uRLArray = new URL[]{entry.getURL()};
                        }
                    }
                } else {
                    uRLArray = new URL[]{entry.getURL()};
                }
                for (URL uRL : uRLArray) {
                    ClassIndexImpl classIndexImpl = ClassIndexManager.get(language).getUsagesQuery(uRL);
                    if (classIndexImpl == null) continue;
                    set.add(classIndexImpl);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    static {
        ClassIndexImpl.FACTORY = new ClassIndexFactoryImpl();
    }

    private static class ClassIndexFactoryImpl
    implements ClassIndexFactory {
        private ClassIndexFactoryImpl() {
        }

        public ClassIndex create(Language language, ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
            return new ClassIndex(language, classPath, classPath2, classPath3);
        }
    }
}

