/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.PlatformManagedObject;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowMemoryNotifier {
    private static final float DEFAULT_HEAP_LIMIT = 0.9f;
    private static LowMemoryNotifier instance;
    private final NotificationListener notificationListener = new Listener();
    private final List<LowMemoryListener> listeners = new ArrayList<LowMemoryListener>();
    private MemoryPoolMXBean pool;
    private MemoryPoolMXBean cachedPool;
    private float heapLimit = 0.9f;

    private LowMemoryNotifier() {
    }

    float getHeapLimit() {
        return this.heapLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHeapLimit(float f) {
        this.heapLimit = f;
        LowMemoryNotifier lowMemoryNotifier = this;
        synchronized (lowMemoryNotifier) {
            if (this.pool != null) {
                MemoryUsage memoryUsage = this.pool.getUsage();
                this.pool.setUsageThreshold((long)((float)memoryUsage.getMax() * f));
            }
        }
    }

    public synchronized void addLowMemoryListener(LowMemoryListener lowMemoryListener) {
        assert (lowMemoryListener != null);
        if (this.pool == null) {
            this.pool = this.initJMX();
        }
        assert (this.pool != null);
        MemoryUsage memoryUsage = this.pool.getUsage();
        assert (memoryUsage != null) : String.format("Pool %s returned null MemoryUsage, Valid: %s\n", this.pool.getName(), this.pool.isValid() ? Boolean.TRUE : Boolean.FALSE);
        if (memoryUsage != null && memoryUsage.getUsed() >= this.pool.getUsageThreshold()) {
            lowMemoryListener.lowMemory(new LowMemoryEvent(this, this.pool));
        }
        this.listeners.add(lowMemoryListener);
    }

    public synchronized void removeLowMemoryListener(LowMemoryListener lowMemoryListener) {
        assert (lowMemoryListener != null);
        this.listeners.remove(lowMemoryListener);
        if (this.listeners.isEmpty() && this.pool != null) {
            this.finishJMX(this.pool);
            this.pool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLowMemory() {
        MemoryPoolMXBean memoryPoolMXBean;
        LowMemoryListener[] lowMemoryListenerArray;
        Object object = this;
        synchronized (object) {
            lowMemoryListenerArray = this.listeners.toArray(new LowMemoryListener[this.listeners.size()]);
            memoryPoolMXBean = this.pool;
        }
        if (lowMemoryListenerArray.length > 0) {
            assert (memoryPoolMXBean != null);
            object = new LowMemoryEvent(this, memoryPoolMXBean);
            for (LowMemoryListener lowMemoryListener : lowMemoryListenerArray) {
                lowMemoryListener.lowMemory((LowMemoryEvent)object);
            }
        }
    }

    private MemoryPoolMXBean initJMX() {
        List<MemoryPoolMXBean> list = null;
        if (this.cachedPool == null || !this.cachedPool.isValid()) {
            list = ManagementFactory.getMemoryPoolMXBeans();
            for (PlatformManagedObject platformManagedObject : list) {
                if (platformManagedObject.getType() != MemoryType.HEAP || !platformManagedObject.isUsageThresholdSupported()) continue;
                this.cachedPool = platformManagedObject;
                break;
            }
        }
        assert (this.cachedPool != null) : LowMemoryNotifier.dumpMemoryPoolMXBean(list);
        if (this.cachedPool != null) {
            PlatformManagedObject platformManagedObject;
            MemoryUsage memoryUsage = this.cachedPool.getUsage();
            this.cachedPool.setUsageThreshold((long)((float)memoryUsage.getMax() * this.heapLimit));
            platformManagedObject = ManagementFactory.getMemoryMXBean();
            ((NotificationEmitter)((Object)platformManagedObject)).addNotificationListener(this.notificationListener, null, null);
        }
        return this.cachedPool;
    }

    private void finishJMX(MemoryPoolMXBean memoryPoolMXBean) {
        assert (memoryPoolMXBean != null);
        try {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            ((NotificationEmitter)((Object)memoryMXBean)).removeNotificationListener(this.notificationListener);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)listenerNotFoundException);
        }
        memoryPoolMXBean.setUsageThreshold(0L);
    }

    private static String dumpMemoryPoolMXBean(List<MemoryPoolMXBean> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            stringBuilder.append(String.format("Pool: %s Type: %s TresholdSupported: %s\n", new Object[]{memoryPoolMXBean.getName(), memoryPoolMXBean.getType(), memoryPoolMXBean.isUsageThresholdSupported() ? Boolean.TRUE : Boolean.FALSE}));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public static synchronized LowMemoryNotifier getDefault() {
        if (instance == null) {
            instance = new LowMemoryNotifier();
        }
        return instance;
    }

    private class Listener
    implements NotificationListener {
        private Listener() {
        }

        public void handleNotification(Notification notification, Object object) {
            String string = notification.getType();
            if (string.equals("java.management.memory.threshold.exceeded")) {
                LowMemoryNotifier.this.fireLowMemory();
            }
        }
    }
}

