/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentUtil {
    private static final String ROOT_NAME = "/";
    private static final String FIELD_RESOURCE_NAME = "resName";
    private static final String FIELD_BINARY_NAME = "binaryName";
    private static final String FIELD_PACKAGE_NAME = "packageName";
    static final String FIELD_TIME_STAMP = "timeStamp";
    static final String FIELD_FILENAME = "filename";
    private static final String FIELD_REFERENCES = "references";
    private static final String FIELD_SIMPLE_NAME = "simpleName";
    private static final String FIELD_CASE_INSENSITIVE_NAME = "ciName";
    private static final char NO = '-';
    private static final char YES = '+';
    private static final char WILDCARD = '?';
    private static final char PKG_SEPARATOR = '.';
    private static final char EK_CLASS = 'C';
    private static final char EK_INTERFACE = 'I';
    private static final char EK_ENUM = 'E';
    private static final char EK_ANNOTATION = 'A';
    private static final int SIZE = ClassIndexImpl.UsageType.values().length;
    private static final char[] MASK_ANY_USAGE = new char[SIZE];

    private DocumentUtil() {
    }

    public static String getBinaryName(Document document) {
        assert (document != null);
        Field field = document.getField(FIELD_PACKAGE_NAME);
        Field field2 = document.getField(FIELD_BINARY_NAME);
        if (field2 == null) {
            return null;
        }
        String string = field2.stringValue();
        String string2 = string.substring(0, string.length() - 1);
        if (field == null) {
            return string2;
        }
        return field.stringValue() + '.' + string2;
    }

    public static String getSimpleBinaryName(Document document) {
        assert (document != null);
        Field field = document.getField(FIELD_BINARY_NAME);
        if (field == null) {
            return null;
        }
        return field.stringValue();
    }

    public static String getPackageName(Document document) {
        assert (document != null);
        Field field = document.getField(FIELD_PACKAGE_NAME);
        return field == null ? null : field.stringValue();
    }

    static String getRefereneType(Document document, String string) {
        assert (document != null);
        assert (string != null);
        Field[] fieldArray = document.getFields(FIELD_REFERENCES);
        assert (fieldArray != null);
        for (Field field : fieldArray) {
            String string2 = field.stringValue();
            int n = string2.length();
            assert (n > SIZE);
            int n2 = n - SIZE;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2);
            if (!string.equals(string3)) continue;
            return string4;
        }
        return null;
    }

    public static List<String> getReferences(Document document) {
        assert (document != null);
        Field[] fieldArray = document.getFields(FIELD_REFERENCES);
        assert (fieldArray != null);
        ArrayList<String> arrayList = new ArrayList<String>(fieldArray.length);
        for (Field field : fieldArray) {
            arrayList.add(field.stringValue());
        }
        return arrayList;
    }

    public static long getTimeStamp(Document document) throws ParseException {
        assert (document != null);
        Field field = document.getField(FIELD_TIME_STAMP);
        assert (field != null);
        String string = field.stringValue();
        assert (string != null);
        return DateTools.stringToTime((String)string);
    }

    public static Query binaryNameQuery(String string) {
        String string2;
        String string3;
        BooleanQuery booleanQuery = new BooleanQuery();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        string2 = string2 + '?';
        booleanQuery.add((Query)new TermQuery(new Term(FIELD_PACKAGE_NAME, string3)), BooleanClause.Occur.MUST);
        booleanQuery.add((Query)new WildcardQuery(new Term(FIELD_BINARY_NAME, string2)), BooleanClause.Occur.MUST);
        return booleanQuery;
    }

    public static Query binaryContentNameQuery(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        if (n < 0) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        BooleanQuery booleanQuery2 = new BooleanQuery();
        booleanQuery2.add((Query)new WildcardQuery(new Term(FIELD_BINARY_NAME, string2 + '?')), BooleanClause.Occur.SHOULD);
        booleanQuery2.add((Query)new PrefixQuery(new Term(FIELD_BINARY_NAME, string2 + '$')), BooleanClause.Occur.SHOULD);
        booleanQuery.add((Query)new TermQuery(new Term(FIELD_PACKAGE_NAME, string3)), BooleanClause.Occur.MUST);
        booleanQuery.add((Query)booleanQuery2, BooleanClause.Occur.MUST);
        return booleanQuery;
    }

    public static Term rootDocumentTerm() {
        return new Term(FIELD_RESOURCE_NAME, ROOT_NAME);
    }

    public static Document createDocument(String string, long l, List<String> list) {
        String string2;
        String string3;
        assert (string != null);
        assert (list != null);
        int n = string.lastIndexOf(46);
        if (n < 0) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
        }
        n = string3.lastIndexOf(36);
        String string4 = n < 0 ? string3.substring(0, string3.length() - 1) : string3.substring(n + 1, string3.length() - 1);
        String string5 = string4.toLowerCase();
        Document document = new Document();
        Field field = new Field(FIELD_BINARY_NAME, string3, Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)field);
        field = new Field(FIELD_PACKAGE_NAME, string2, Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        document.add((Fieldable)field);
        field = new Field(FIELD_SIMPLE_NAME, string4, Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)field);
        field = new Field(FIELD_CASE_INSENSITIVE_NAME, string5, Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)field);
        for (String string6 : list) {
            field = new Field(FIELD_REFERENCES, string6, Field.Store.YES, Field.Index.UN_TOKENIZED);
            document.add((Fieldable)field);
        }
        return document;
    }

    public static Document createRootTimeStampDocument(long l) {
        Document document = new Document();
        Field field = new Field(FIELD_RESOURCE_NAME, ROOT_NAME, Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        document.add((Fieldable)field);
        return document;
    }

    public static StringBuilder createUsage(String string) {
        Set<ClassIndexImpl.UsageType> set = Collections.emptySet();
        return DocumentUtil.encodeUsage(string, set, '-');
    }

    public static void addUsage(StringBuilder stringBuilder, ClassIndexImpl.UsageType usageType) {
        assert (stringBuilder != null);
        assert (usageType != null);
        int n = stringBuilder.length();
        int n2 = n - SIZE;
        stringBuilder.setCharAt(n2 + usageType.getOffset(), '+');
    }

    public static String encodeUsage(String string, Set<ClassIndexImpl.UsageType> set) {
        return DocumentUtil.encodeUsage(string, set, '-').toString();
    }

    private static StringBuilder encodeUsage(String string, Set<ClassIndexImpl.UsageType> set, char c) {
        assert (string != null);
        assert (set != null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        char[] cArray = new char[SIZE];
        Arrays.fill(cArray, c);
        for (ClassIndexImpl.UsageType usageType : set) {
            int n = usageType.getOffset();
            assert (n >= 0 && n < SIZE);
            cArray[n] = 43;
        }
        stringBuilder.append(cArray);
        return stringBuilder;
    }

    public static String encodeUsage(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String decodeUsage(String string, Set<ClassIndexImpl.UsageType> set) {
        assert (string != null);
        assert (set != null);
        assert (set.isEmpty());
        int n = string.length();
        assert (n > SIZE);
        int n2 = n - SIZE;
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        for (ClassIndexImpl.UsageType usageType : ClassIndexImpl.UsageType.values()) {
            if (string3.charAt(usageType.getOffset()) != '+') continue;
            set.add(usageType);
        }
        return string2;
    }

    static {
        Arrays.fill(MASK_ANY_USAGE, '?');
    }
}

