/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsSettings;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener {
    private Map<Rule.UserConfigurableRule, ModifiedPreferences> changes;
    private static Map<HintSeverity, Integer> severity2index = new HashMap<HintSeverity, Integer>();
    private static final String DESCRIPTION_HEADER = "<html><head><link rel=\"StyleSheet\" href=\"nbresloc:/org/netbeans/modules/gsfret/hints/infrastructure/ide.css\" type=\"text/css\"></head><body>";
    private static final String DESCRIPTION_FOOTER = "</body></html>";
    private JTree errorTree;
    private JComboBox severityComboBox;
    private JCheckBox tasklistCheckBox;
    private JPanel customizerPanel;
    private JEditorPane descriptionTextArea;
    private GsfHintsManager manager;

    HintsPanelLogic(GsfHintsManager gsfHintsManager) {
        this.manager = gsfHintsManager;
        this.changes = new HashMap<Rule.UserConfigurableRule, ModifiedPreferences>();
    }

    void connect(JTree jTree, JComboBox jComboBox, JCheckBox jCheckBox, JPanel jPanel, JEditorPane jEditorPane) {
        this.errorTree = jTree;
        this.severityComboBox = jComboBox;
        this.tasklistCheckBox = jCheckBox;
        this.customizerPanel = jPanel;
        this.descriptionTextArea = jEditorPane;
        this.valueChanged(null);
        jTree.addKeyListener(this);
        jTree.addMouseListener(this);
        jTree.getSelectionModel().addTreeSelectionListener(this);
        jComboBox.addActionListener(this);
        jCheckBox.addChangeListener(this);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.tasklistCheckBox.removeChangeListener(this);
        this.componentsSetEnabled(false);
    }

    synchronized void applyChanges() {
        for (Rule.UserConfigurableRule userConfigurableRule : this.changes.keySet()) {
            ModifiedPreferences modifiedPreferences = this.changes.get(userConfigurableRule);
            modifiedPreferences.store(HintsSettings.getPreferences(this.manager, userConfigurableRule, HintsSettings.getCurrentProfileId()));
        }
        this.updateHints();
    }

    private void updateHints() {
        Document document;
        Source source;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null && (source = Source.forDocument(document = jTextComponent.getDocument())) != null) {
            try {
                source.runUserActionTask(new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(Phase.RESOLVED).compareTo(Phase.RESOLVED) < 0) {
                            return;
                        }
                        GsfHintsManager.refreshHints(compilationController);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    boolean isChanged() {
        return !this.changes.isEmpty();
    }

    synchronized Preferences getCurrentPrefernces(Rule.UserConfigurableRule userConfigurableRule) {
        Preferences preferences = this.changes.get(userConfigurableRule);
        return preferences == null ? HintsSettings.getPreferences(this.manager, userConfigurableRule, HintsSettings.getCurrentProfileId()) : preferences;
    }

    synchronized Preferences getPreferences4Modification(Rule.UserConfigurableRule userConfigurableRule) {
        Preferences preferences = this.changes.get(userConfigurableRule);
        if (preferences == null) {
            preferences = new ModifiedPreferences(HintsSettings.getPreferences(this.manager, userConfigurableRule, HintsSettings.getCurrentProfileId()));
            this.changes.put(userConfigurableRule, (ModifiedPreferences)preferences);
        }
        return preferences;
    }

    static Object getUserObject(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    static Object getUserObject(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode.getUserObject();
    }

    boolean isSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            Rule.UserConfigurableRule userConfigurableRule;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof Rule.UserConfigurableRule) || !HintsSettings.isEnabled(this.manager, userConfigurableRule = (Rule.UserConfigurableRule)object, this.getCurrentPrefernces(userConfigurableRule))) continue;
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = mouseEvent.getPoint();
        TreePath treePath = this.errorTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath != null && (rectangle = this.errorTree.getPathBounds(treePath)) != null) {
            rectangle.width = rectangle.height;
            if (rectangle.contains(point)) {
                this.toggle(treePath);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        JTree jTree;
        TreePath treePath;
        if ((keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) && keyEvent.getSource() instanceof JTree && this.toggle(treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath())) {
            keyEvent.consume();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (object instanceof Rule.UserConfigurableRule) {
            Rule.UserConfigurableRule userConfigurableRule = (Rule.UserConfigurableRule)object;
            this.componentsSetEnabled(true);
            Preferences preferences = this.getCurrentPrefernces(userConfigurableRule);
            HintSeverity hintSeverity = HintsSettings.getSeverity(userConfigurableRule, preferences);
            this.severityComboBox.setSelectedIndex(severity2index.get(hintSeverity));
            boolean bl = HintsSettings.isShowInTaskList(userConfigurableRule, preferences);
            this.tasklistCheckBox.setSelected(bl);
            String string = userConfigurableRule.getDescription();
            this.descriptionTextArea.setText(string == null ? "" : this.wrapDescription(string));
            this.customizerPanel.removeAll();
            JComponent jComponent = userConfigurableRule.getCustomizer(treeSelectionEvent == null ? this.getCurrentPrefernces(userConfigurableRule) : this.getPreferences4Modification(userConfigurableRule));
            if (jComponent != null) {
                this.customizerPanel.add((Component)jComponent, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else {
            this.componentsSetEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.errorTree.getSelectionPath() == null) {
            return;
        }
        Object object = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (object instanceof Rule.UserConfigurableRule) {
            Rule.UserConfigurableRule userConfigurableRule = (Rule.UserConfigurableRule)object;
            Preferences preferences = this.getPreferences4Modification(userConfigurableRule);
            if (this.severityComboBox.equals(actionEvent.getSource())) {
                HintsSettings.setSeverity(preferences, this.index2severity(this.severityComboBox.getSelectedIndex()));
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    private String wrapDescription(String string) {
        return new StringBuffer(DESCRIPTION_HEADER).append(string).append(DESCRIPTION_FOOTER).toString();
    }

    private HintSeverity index2severity(int n) {
        for (Map.Entry<HintSeverity, Integer> entry : severity2index.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = HintsPanelLogic.getUserObject(treePath);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.errorTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (object instanceof Rule.UserConfigurableRule) {
            Rule.UserConfigurableRule userConfigurableRule = (Rule.UserConfigurableRule)object;
            boolean bl = HintsSettings.isEnabled(this.manager, userConfigurableRule, this.getCurrentPrefernces(userConfigurableRule));
            Preferences preferences = this.getPreferences4Modification(userConfigurableRule);
            HintsSettings.setEnabled(preferences, !bl);
            defaultTreeModel.nodeChanged(defaultMutableTreeNode);
            defaultTreeModel.nodeChanged(defaultMutableTreeNode.getParent());
        } else if (object instanceof FileObject || object instanceof String) {
            boolean bl = !this.isSelected(defaultMutableTreeNode);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                Rule.UserConfigurableRule userConfigurableRule;
                boolean bl2;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                Object object2 = defaultMutableTreeNode2.getUserObject();
                if (!(object2 instanceof Rule.UserConfigurableRule) || (bl2 = HintsSettings.isEnabled(this.manager, userConfigurableRule = (Rule.UserConfigurableRule)object2, this.getCurrentPrefernces(userConfigurableRule))) == bl) continue;
                Preferences preferences = this.getPreferences4Modification(userConfigurableRule);
                HintsSettings.setEnabled(preferences, bl);
                defaultTreeModel.nodeChanged(defaultMutableTreeNode2);
            }
            defaultTreeModel.nodeChanged(defaultMutableTreeNode);
        }
        return false;
    }

    private void componentsSetEnabled(boolean bl) {
        if (!bl) {
            this.customizerPanel.removeAll();
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
            this.severityComboBox.setSelectedIndex(severity2index.get(HintsSettings.SEVERITY_DEFAUT));
            this.tasklistCheckBox.setSelected(true);
            this.descriptionTextArea.setText("");
        }
        this.severityComboBox.setEnabled(bl);
        this.tasklistCheckBox.setEnabled(bl);
        this.descriptionTextArea.setEnabled(bl);
    }

    static {
        severity2index.put(HintSeverity.ERROR, 0);
        severity2index.put(HintSeverity.WARNING, 1);
        severity2index.put(HintSeverity.CURRENT_LINE_WARNING, 2);
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public ModifiedPreferences(Preferences preferences) {
            super(null, "");
            try {
                for (String string : preferences.keys()) {
                    this.put(string, preferences.get(string, null));
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }

        public void store(Preferences preferences) {
            try {
                for (String string : this.keys()) {
                    preferences.put(string, this.get(string, null));
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }

        protected void putSpi(String string, String string2) {
            this.map.put(string, string2);
        }

        protected String getSpi(String string) {
            return (String)this.map.get(string);
        }

        protected void removeSpi(String string) {
            this.map.remove(string);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] stringArray = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(stringArray);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

