/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HighlightImpl {
    private Document doc;
    private int start;
    private int end;
    private Collection<ColoringAttributes> colorings;
    Collection<ColoringAttributes> coloringsAttributesOrder = Arrays.asList(ColoringAttributes.ABSTRACT, ColoringAttributes.ANNOTATION_TYPE, ColoringAttributes.CLASS, ColoringAttributes.CONSTRUCTOR, ColoringAttributes.CUSTOM1, ColoringAttributes.CUSTOM2, ColoringAttributes.CUSTOM3, ColoringAttributes.DECLARATION, ColoringAttributes.DEPRECATED, ColoringAttributes.ENUM, ColoringAttributes.FIELD, ColoringAttributes.GLOBAL, ColoringAttributes.INTERFACE, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.MARK_OCCURRENCES, ColoringAttributes.METHOD, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PARAMETER, ColoringAttributes.PRIVATE, ColoringAttributes.PROTECTED, ColoringAttributes.PUBLIC, ColoringAttributes.REGEXP, ColoringAttributes.STATIC, ColoringAttributes.TYPE_PARAMETER_DECLARATION, ColoringAttributes.TYPE_PARAMETER_USE, ColoringAttributes.UNDEFINED, ColoringAttributes.UNUSED);

    public HighlightImpl(Document document, Token token, Collection<ColoringAttributes> collection) {
        this.doc = document;
        this.start = token.offset(null);
        this.end = token.offset(null) + token.text().length();
        this.colorings = collection;
    }

    public HighlightImpl(Document document, int n, int n2, Collection<ColoringAttributes> collection) {
        this.doc = document;
        this.start = n;
        this.end = n2;
        this.colorings = collection;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getHighlightTestData() {
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.start);
        int n2 = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.start);
        int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.end);
        int n4 = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.end);
        return this.coloringsToString() + ", " + n + ":" + n2 + "-" + n3 + ":" + n4;
    }

    private String coloringsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("[");
        for (ColoringAttributes coloringAttributes : this.coloringsAttributesOrder) {
            if (!this.colorings.contains(coloringAttributes)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(coloringAttributes.name());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static HighlightImpl parse(StyledDocument styledDocument, String string) throws ParseException, BadLocationException {
        MessageFormat messageFormat = new MessageFormat("[{0}], {1,number,integer}:{2,number,integer}-{3,number,integer}:{4,number,integer}");
        Object[] objectArray = messageFormat.parse(string);
        String string2 = (String)objectArray[0];
        int n = ((Long)objectArray[1]).intValue();
        int n2 = ((Long)objectArray[2]).intValue();
        int n3 = ((Long)objectArray[3]).intValue();
        int n4 = ((Long)objectArray[4]).intValue();
        String[] stringArray = string2.split(",");
        ArrayList<ColoringAttributes> arrayList = new ArrayList<ColoringAttributes>();
        for (String string3 : stringArray) {
            string3 = string3.trim();
            arrayList.add(ColoringAttributes.valueOf((String)string3));
        }
        if (arrayList.contains(null)) {
            throw new NullPointerException();
        }
        int n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n) + n2;
        int n6 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n3) + n4;
        return new HighlightImpl(styledDocument, n5, n6, arrayList);
    }
}

