/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.GsfIndentTaskFactory;
import org.netbeans.modules.gsf.GsfReformatTaskFactory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class MimeLookupInitializerImpl
implements MimeLookupInitializer {
    private static final int EDITOR_KIT_ID = 1;
    private static final int INDENT_ID = 2;
    private static final int FORMAT_ID = 3;
    private static final int BRACES_ID = 4;
    private String[] mimeTypes;
    private Map<String, Lookup.Result> children = new HashMap<String, Lookup.Result>();
    private Lookup lookup;

    public MimeLookupInitializerImpl() {
        this(new String[0]);
    }

    public MimeLookupInitializerImpl(String[] stringArray) {
        this.mimeTypes = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result child(String string) {
        Map<String, Lookup.Result> map = this.children;
        synchronized (map) {
            String[] stringArray = new String[this.mimeTypes.length + 1];
            System.arraycopy(this.mimeTypes, 0, stringArray, 0, this.mimeTypes.length);
            stringArray[this.mimeTypes.length] = string;
            Lookup.Result result = this.children.get(string);
            if (result == null) {
                result = Lookups.fixed((Object[])new Object[]{new MimeLookupInitializerImpl(stringArray)}).lookup(new Lookup.Template(MimeLookupInitializerImpl.class));
                this.children.put(string, result);
            }
            return result;
        }
    }

    public Lookup lookup() {
        if (this.lookup == null) {
            if (this.mimeTypes.length != 1) {
                this.lookup = Lookup.EMPTY;
                return this.lookup;
            }
            if (LanguageRegistry.getInstance().isSupported(this.mimeTypes[0])) {
                final Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.mimeTypes[0]);
                assert (language != null);
                if (language.useCustomEditorKit()) {
                    return null;
                }
                Object[] objectArray = null;
                objectArray = language.hasFormatter() ? new Integer[]{1, 2, 3} : new Integer[]{1, 2};
                this.lookup = Lookups.fixed((Object[])objectArray, (InstanceContent.Convertor)new InstanceContent.Convertor<Integer, Object>(){

                    public Object convert(Integer n) {
                        switch (n) {
                            case 1: {
                                GsfEditorKitFactory gsfEditorKitFactory = new GsfEditorKitFactory(language);
                                return gsfEditorKitFactory.kit();
                            }
                            case 3: {
                                return new GsfReformatTaskFactory();
                            }
                            case 2: {
                                return new GsfIndentTaskFactory();
                            }
                        }
                        return null;
                    }

                    public Class<? extends Object> type(Integer n) {
                        switch (n) {
                            case 1: {
                                return GsfEditorKitFactory.GsfEditorKit.class;
                            }
                            case 3: {
                                return GsfReformatTaskFactory.class;
                            }
                            case 2: {
                                return GsfIndentTaskFactory.class;
                            }
                        }
                        return null;
                    }

                    public String id(Integer n) {
                        return n.toString();
                    }

                    public String displayName(Integer n) {
                        return n.toString();
                    }
                });
            }
        }
        return this.lookup;
    }
}

