/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.ServerRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerUpdateCache {
    private List<ServerRecord> hosts = null;
    private ServerRecord defaultRecord = null;
    private Logger log = Logger.getLogger("cnd.remote.logger");

    public List<ServerRecord> getHosts() {
        List<ServerRecord> list = this.hosts;
        if (list == null) {
            throw new IllegalStateException("hosts should not be null");
        }
        return new ArrayList<ServerRecord>(this.hosts);
    }

    public synchronized void setHosts(Collection<? extends ServerRecord> collection) {
        this.hosts = new ArrayList<ServerRecord>(collection);
        if (this.defaultRecord != null && !this.hosts.contains(this.defaultRecord)) {
            this.defaultRecord = this.hosts.isEmpty() ? null : this.hosts.get(0);
        }
    }

    public ServerRecord getDefaultRecord() {
        if (this.defaultRecord == null) {
            this.log.warning("ServerUpdateCache.getDefaultRecord: Forcing negative index to 0");
        }
        return this.defaultRecord;
    }

    public void setDefaultRecord(ServerRecord serverRecord) {
        assert (this.hosts.contains(serverRecord));
        this.defaultRecord = serverRecord;
    }
}

