/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteBinaryService {
    private static final Map<RemoteBinaryID, Future<Boolean>> readiness = Collections.synchronizedMap(new HashMap());

    protected RemoteBinaryService() {
    }

    public static RemoteBinaryID getRemoteBinary(ExecutionEnvironment executionEnvironment, String string) {
        if (executionEnvironment.isLocal()) {
            return new RemoteBinaryID(string);
        }
        RemoteBinaryService remoteBinaryService = (RemoteBinaryService)Lookup.getDefault().lookup(RemoteBinaryService.class);
        if (remoteBinaryService == null) {
            return null;
        }
        RemoteBinaryResult remoteBinaryResult = remoteBinaryService.getRemoteBinaryImpl(executionEnvironment, string);
        if (remoteBinaryResult == null) {
            return null;
        }
        RemoteBinaryID remoteBinaryID = new RemoteBinaryID(remoteBinaryResult.localFName);
        Future<Boolean> future = readiness.put(remoteBinaryID, remoteBinaryResult.syncResult);
        if (future != null && future != remoteBinaryResult.syncResult) {
            future.cancel(true);
        }
        return remoteBinaryID;
    }

    public static String getFileName(RemoteBinaryID remoteBinaryID) {
        return remoteBinaryID.toIDString();
    }

    public static Future<Boolean> getResult(RemoteBinaryID remoteBinaryID) {
        return readiness.get(remoteBinaryID);
    }

    protected abstract RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment var1, String var2);

    public static class RemoteBinaryID {
        private final String id;

        private RemoteBinaryID(String string) {
            this.id = string;
        }

        public static RemoteBinaryID fromIDString(String string) {
            return new RemoteBinaryID(string);
        }

        public String toIDString() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RemoteBinaryID)) {
                return false;
            }
            RemoteBinaryID remoteBinaryID = (RemoteBinaryID)object;
            return this.id.equals(remoteBinaryID.id);
        }

        public int hashCode() {
            int n = 5;
            n = 29 * n + (this.id != null ? this.id.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RemoteBinaryResult {
        public final String localFName;
        public final Future<Boolean> syncResult;

        public RemoteBinaryResult(String string, Future<Boolean> future) {
            this.localFName = string;
            this.syncResult = future;
        }
    }
}

