/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class IntegerGreaterThanConstraint
extends ConstraintUtils
implements Constraint {
    private int value = -1;

    public IntegerGreaterThanConstraint() {
        this.value = -1;
    }

    public IntegerGreaterThanConstraint(String string) {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = BundleReader.getValue("Error_failed_to_create");
            Object[] objectArray = new Object[]{"IntegerGreaterThanConstraint"};
            System.out.println(MessageFormat.format(string2, objectArray));
        }
    }

    public Collection match(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (string != null && string.length() != 0) {
            try {
                int n = Integer.parseInt(string);
                if (n <= this.value || n > Integer.MAX_VALUE) {
                    this.addFailure(arrayList, string2, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addFailure(arrayList, string2, string);
            }
        }
        return arrayList;
    }

    public void setValue(String string) {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = BundleReader.getValue("Error_failed_to_set");
            Object[] objectArray = new Object[]{this.toString(), "Value"};
            System.out.println(MessageFormat.format(string2, objectArray));
        }
    }

    public void setValue(Integer n) {
        this.value = n;
    }

    public void print() {
        super.print();
        String string = BundleReader.getValue("Name_Value_Pair_Format");
        Object[] objectArray = new Object[]{"Value", String.valueOf(this.value)};
        System.out.println(MessageFormat.format(string, objectArray));
    }

    private void addFailure(Collection collection, String string, String string2) {
        String string3 = this.formatFailureMessage(this.toString(), string2, string);
        String string4 = BundleReader.getValue("MSG_IntegerGreaterThanConstraint_Failure");
        Object[] objectArray = new Object[]{String.valueOf(this.value)};
        String string5 = MessageFormat.format(string4, objectArray);
        collection.add(new ConstraintFailure(this.toString(), string2, string, string3, string5));
    }
}

