/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;

public class GenericTableDialogPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private List fieldEntries;
    private String[] values;
    private JTextField[] textFields;
    private int preferredWidth;

    public void init(ASDDVersion aSDDVersion, int n, List list, Object object) {
        this.fieldEntries = list;
        this.preferredWidth = n;
        this.values = new String[list.size()];
        this.textFields = new JTextField[list.size()];
        this.initUserComponents();
    }

    public void setValues(Object[] objectArray) {
        if (objectArray != null && objectArray.length == this.values.length) {
            for (int i = 0; i < this.values.length && i < objectArray.length; ++i) {
                this.values[i] = objectArray[i] != null ? objectArray[i].toString() : "";
            }
        } else {
            if (objectArray != null) assert (objectArray.length == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = "";
            }
        }
        this.setComponentValues();
    }

    public Object[] getValues() {
        return this.values;
    }

    private void setComponentValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.textFields[i].setText(this.values[i]);
        }
    }

    private void initUserComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
        this.setPreferredSize(new Dimension(this.preferredWidth, 22 * this.fieldEntries.size() + 8));
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            GenericTableModel.TableEntry tableEntry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            this.textFields[i] = new JTextField();
            if (tableEntry.isRequiredField()) {
                jLabel.setText(this.bundle.getString("LBL_RequiredMark"));
                jLabel.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_RequiredMark"));
                jLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_RequiredMark"));
            }
            jLabel.setLabelFor(this.textFields[i]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)jLabel, gridBagConstraints);
            jLabel2.setLabelFor(this.textFields[i]);
            jLabel2.setText(tableEntry.getLabelName());
            jLabel2.setDisplayedMnemonic(tableEntry.getLabelMnemonic());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)jLabel2, gridBagConstraints);
            this.textFields[i].addKeyListener(new TextFieldHandler(this.textFields[i], i));
            this.textFields[i].getAccessibleContext().setAccessibleName(tableEntry.getAccessibleName());
            this.textFields[i].getAccessibleContext().setAccessibleDescription(tableEntry.getAccessibleDescription());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            this.add((Component)this.textFields[i], gridBagConstraints);
        }
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            Object[] objectArray;
            GenericTableModel.TableEntry tableEntry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            if (tableEntry.isRequiredField() && !Utils.notEmpty(this.values[i])) {
                objectArray = new Object[]{tableEntry.getColumnName()};
                arrayList.add(MessageFormat.format(this.bundle.getString("ERR_SpecifiedFieldIsEmpty"), objectArray));
                continue;
            }
            if (!tableEntry.isNameField() || !Utils.containsWhitespace(this.values[i])) continue;
            objectArray = new Object[]{tableEntry.getColumnName()};
            arrayList.add(MessageFormat.format(this.bundle.getString("ERR_NameFieldContainsWhitespace"), objectArray));
        }
        return arrayList;
    }

    public boolean requiredFieldsFilled() {
        boolean bl = true;
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            GenericTableModel.TableEntry tableEntry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            if (!tableEntry.isRequiredField() || Utils.notEmpty(this.values[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private class TextFieldHandler
    extends KeyAdapter {
        private JTextField textField;
        private int controlIndex;

        public TextFieldHandler(JTextField jTextField, int n) {
            this.textField = jTextField;
            this.controlIndex = n;
        }

        public void keyReleased(KeyEvent keyEvent) {
            ((GenericTableDialogPanel)GenericTableDialogPanel.this).values[this.controlIndex] = this.textField.getText();
            GenericTableDialogPanel.this.firePropertyChange("UserDataChanged", null, null);
        }
    }
}

