/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public class CharsetMapping
implements Comparable {
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle");
    private Charset charset;
    private String chosenAlias;
    private boolean showAliases;
    private String displayText;
    private boolean textOutOfDate;
    private static boolean useAliases = false;
    private static SortedMap sortedCanonicalCharsetMappings = null;
    private static SortedMap sortedAliasCharsetMappings = null;
    public static final String CHARSET_DISPLAY_TYPE = "CharsetDisplayType";
    public static final Integer CHARSET_CANONICAL = new Integer(0);
    public static final Integer CHARSET_ALIAS_ASIDE = new Integer(1);
    public static final Integer CHARSET_ALIAS_SELECTION = new Integer(2);
    private static Integer displayOption = CHARSET_ALIAS_ASIDE;
    private static PropertyChangeSupport propSupport = new PropertyChangeSupport(CharsetMapping.class);

    public CharsetMapping(Charset charset) {
        this(charset, charset.displayName(), true);
    }

    public CharsetMapping(Charset charset, boolean bl) {
        this(charset, charset.displayName(), bl);
    }

    public CharsetMapping(Charset charset, String string) {
        this(charset, string, false);
    }

    private CharsetMapping(Charset charset, String string, boolean bl) {
        this.charset = charset;
        this.chosenAlias = string;
        this.showAliases = bl;
        this.displayText = this.buildDisplayText();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CharsetMapping) {
            CharsetMapping charsetMapping = (CharsetMapping)object;
            bl = this.chosenAlias.equals(charsetMapping.getAlias());
        }
        return bl;
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public String toString() {
        if (this.textOutOfDate) {
            this.displayText = this.buildDisplayText();
        }
        return this.displayText;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getAlias() {
        return this.chosenAlias;
    }

    public void updateDisplayText() {
        this.textOutOfDate = true;
    }

    private String buildDisplayText() {
        String string = this.chosenAlias;
        if (this.showAliases) {
            StringBuffer stringBuffer = new StringBuffer(200);
            Object[] objectArray = this.charset.aliases().iterator();
            while (objectArray.hasNext()) {
                stringBuffer.append(objectArray.next());
                if (!objectArray.hasNext()) continue;
                stringBuffer.append(", ");
            }
            objectArray = new Object[]{this.chosenAlias, stringBuffer.toString()};
            string = MessageFormat.format(this.bundle.getString("LBL_CharsetComboBoxDisplayText"), objectArray);
        }
        if (string == null || string.length() == 0) {
            string = this.bundle.getString("LBL_UnnamedCharset");
        }
        this.textOutOfDate = false;
        return string;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof CharsetMapping) {
            CharsetMapping charsetMapping = (CharsetMapping)object;
            n = this.chosenAlias.compareTo(charsetMapping.getAlias());
        }
        return n;
    }

    private static SortedMap getSortedCanonicalCharsetMappings() {
        if (sortedCanonicalCharsetMappings == null) {
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            sortedCanonicalCharsetMappings = new TreeMap();
            for (Map.Entry<String, Charset> entry : sortedMap.entrySet()) {
                CharsetMapping charsetMapping = new CharsetMapping(entry.getValue());
                sortedCanonicalCharsetMappings.put(charsetMapping.getAlias(), charsetMapping);
            }
        }
        return sortedCanonicalCharsetMappings;
    }

    private static SortedMap getSortedAliasCharsetMappings() {
        if (sortedAliasCharsetMappings == null) {
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            sortedAliasCharsetMappings = new TreeMap();
            for (Map.Entry<String, Charset> entry : sortedMap.entrySet()) {
                Charset charset = entry.getValue();
                CharsetMapping charsetMapping = new CharsetMapping(charset, false);
                sortedAliasCharsetMappings.put(charsetMapping.getAlias(), charsetMapping);
                for (String string : charset.aliases()) {
                    CharsetMapping charsetMapping2 = new CharsetMapping(charset, string);
                    sortedAliasCharsetMappings.put(string, charsetMapping2);
                }
            }
        }
        return sortedAliasCharsetMappings;
    }

    public static SortedMap getSortedAvailableCharsetMappings() {
        SortedMap sortedMap;
        if (useAliases) {
            if (sortedAliasCharsetMappings == null) {
                sortedAliasCharsetMappings = CharsetMapping.getSortedAliasCharsetMappings();
            }
            sortedMap = sortedAliasCharsetMappings;
        } else {
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            sortedMap = sortedCanonicalCharsetMappings;
        }
        return sortedMap;
    }

    public static CharsetMapping getCharsetMapping(Charset charset) {
        return (CharsetMapping)CharsetMapping.getSortedAvailableCharsetMappings().get(charset.name());
    }

    public static CharsetMapping getCharsetMapping(String string) {
        CharsetMapping charsetMapping = null;
        if (string != null) {
            try {
                Charset charset = Charset.forName(string);
                if (charset != null) {
                    charsetMapping = (CharsetMapping)CharsetMapping.getSortedAvailableCharsetMappings().get(charset.name());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return charsetMapping;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static void setDisplayOption(Integer n) {
        Integer n2 = CharsetMapping.getDisplayOptionEnum(n);
        if (n2 != null && n2 != displayOption) {
            Integer n3 = displayOption;
            displayOption = n2;
            CharsetMapping.updateInternalState();
            propSupport.firePropertyChange(CHARSET_DISPLAY_TYPE, n3, displayOption);
        }
    }

    private static void updateInternalState() {
        if (displayOption == CHARSET_CANONICAL) {
            useAliases = false;
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            Collection collection = sortedCanonicalCharsetMappings.values();
            for (CharsetMapping charsetMapping : collection) {
                charsetMapping.showAliases = false;
                charsetMapping.updateDisplayText();
            }
        } else if (displayOption == CHARSET_ALIAS_ASIDE) {
            useAliases = false;
            if (sortedCanonicalCharsetMappings == null) {
                sortedCanonicalCharsetMappings = CharsetMapping.getSortedCanonicalCharsetMappings();
            }
            Collection collection = sortedCanonicalCharsetMappings.values();
            for (CharsetMapping charsetMapping : collection) {
                charsetMapping.showAliases = true;
                charsetMapping.updateDisplayText();
            }
        } else if (displayOption == CHARSET_ALIAS_SELECTION) {
            useAliases = true;
        }
    }

    public static Integer getDisplayOption() {
        return displayOption;
    }

    private static Integer getDisplayOptionEnum(Integer n) {
        Integer n2 = null;
        if (n != null) {
            if (CHARSET_CANONICAL.compareTo(n) == 0) {
                n2 = CHARSET_CANONICAL;
            } else if (CHARSET_ALIAS_ASIDE.compareTo(n) == 0) {
                n2 = CHARSET_ALIAS_ASIDE;
            } else if (CHARSET_ALIAS_SELECTION.compareTo(n) == 0) {
                n2 = CHARSET_ALIAS_SELECTION;
            }
        }
        return n2;
    }
}

