/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InterfaceServiceName
extends AbstractWebServiceRule {
    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            AnnotationMirror annotationMirror = Utilities.findAnnotation(typeElement, "javax.jws.WebService");
            AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(typeElement, annotationMirror);
            if (Utilities.getAnnotationAttrValue(annotationMirror, "serviceName") != null) {
                String string = NbBundle.getMessage(InterfaceServiceName.class, (String)"MSG_IF_ServiceNameNotAllowed");
                RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), typeElement, annotationMirror, "serviceName");
                ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "serviceName");
                problemContext.setElementToAnnotate(expressionTree);
                ErrorDescription errorDescription = InterfaceServiceName.createProblem((Element)typeElement, problemContext, string, removeAnnotationArgument);
                problemContext.setElementToAnnotate(null);
                return new ErrorDescription[]{errorDescription};
            }
        }
        return null;
    }
}

