/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.util.List;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSummaryColumnImpl
implements ThreadSummaryColumn {
    private List<ThreadSummaryData.StateDuration> state;

    ThreadSummaryColumnImpl(List<ThreadSummaryData.StateDuration> list) {
        this.state = list;
    }

    @Override
    public List<ThreadSummaryData.StateDuration> getSummary() {
        return this.state;
    }

    public int getRunning() {
        int n = 0;
        int n2 = 0;
        for (ThreadSummaryData.StateDuration stateDuration : this.state) {
            n += ThreadStateColumnImpl.timeInervalToMilliSeconds(stateDuration.getDuration());
            switch (stateDuration.getState()) {
                case Running: 
                case RunningOther: 
                case RunningSystemCall: 
                case RunningUser: {
                    n2 += ThreadStateColumnImpl.timeInervalToMilliSeconds(stateDuration.getDuration());
                }
            }
        }
        if (n != 0) {
            return 100 * n2 / n;
        }
        return 0;
    }
}

