/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumn;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsDataManager;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadStateColumnImpl
implements ThreadStateColumn {
    public static final Color THREAD_STATUS_UNKNOWN_COLOR = Color.LIGHT_GRAY;
    public static final Color THREAD_STATUS_ZOMBIE_COLOR = Color.BLACK;
    private final ThreadsDataManager.MergedThreadInfo info;
    private ThreadData stackProvider;
    private final List<ThreadState> list = new ArrayList<ThreadState>();
    private final AtomicInteger comparable = new AtomicInteger();

    static Color getThreadStateColor(ThreadState.MSAState mSAState) {
        if (mSAState == ThreadState.MSAState.ThreadFinished) {
            return THREAD_STATUS_ZOMBIE_COLOR;
        }
        ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
        if (threadStateResources != null) {
            return threadStateResources.color;
        }
        return THREAD_STATUS_UNKNOWN_COLOR;
    }

    static Color getThreadStateColor(ThreadState threadState, int n) {
        return ThreadStateColumnImpl.getThreadStateColor(threadState.getMSAState(n, false));
    }

    static long timeStampToMilliSeconds(long l) {
        return l / 1000L / 1000L;
    }

    static int timeInervalToMilliSeconds(long l) {
        return (int)(l / 1000L / 1000L);
    }

    static long timeInervalToNanoSeconds(long l) {
        return l * 1000L * 1000L;
    }

    static ThreadState.MSAState point2MSA(ThreadsPanel threadsPanel, ThreadState threadState, Point point) {
        int n = 12;
        EnumMap<ThreadState.MSAState, AtomicInteger> enumMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        if (threadsPanel.isMSAMode()) {
            for (AtomicInteger atomicInteger : enumMap.values()) {
                atomicInteger.set(0);
            }
            ThreadStateColumnImpl.fillMap(threadsPanel, threadState, enumMap);
            ThreadStateColumnImpl.roundMap(enumMap);
            int n2 = 0;
            int n3 = 50;
            int n4 = 0;
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(enumMap);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                int n5 = ((AtomicInteger)object.getValue()).get();
                n4 = n3;
                n3 = (n5 * n + n4) % 100;
                int n6 = (n5 * n + n4) / 100;
                if (n6 <= 0 || 3 + n - (n2 += n6) > point.y || point.y > 3 + n - n2 + n6) continue;
                return (ThreadState.MSAState)object.getKey();
            }
        } else {
            return threadState.getMSAState(threadState.getSamplingStateIndex(threadsPanel.isFullMode()), threadsPanel.isFullMode());
        }
        return null;
    }

    static void fillMap(ThreadsPanel threadsPanel, ThreadState threadState, EnumMap<ThreadState.MSAState, AtomicInteger> enumMap) {
        int n = threadState.size();
        for (int i = 0; i < n; ++i) {
            ThreadState.MSAState mSAState = threadState.getMSAState(i, threadsPanel.isFullMode());
            if (mSAState != null) {
                AtomicInteger atomicInteger = enumMap.get(mSAState);
                if (atomicInteger == null) {
                    atomicInteger = new AtomicInteger();
                    enumMap.put(mSAState, atomicInteger);
                }
                atomicInteger.addAndGet(threadState.getState(i));
                continue;
            }
            System.err.println("Wrong MSA at index " + i + " MSA=" + threadState);
        }
    }

    static void roundMap(EnumMap<ThreadState.MSAState, AtomicInteger> enumMap) {
        int n = 0;
        int n2 = 0;
        ThreadState.MSAState mSAState = null;
        for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : enumMap.entrySet()) {
            int n3 = entry.getValue().get();
            n += n3;
            if (n2 > n3) continue;
            mSAState = entry.getKey();
            n2 = n3;
        }
        if (n < 100 && n > 0) {
            int n4 = 100 - n;
            int n5 = 0;
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : enumMap.entrySet()) {
                int n6 = entry.getValue().get();
                int n7 = (n6 * n4 + n / 2) / n;
                if (n5 + n7 > n) {
                    n7 = n - n5;
                    n5 = n;
                } else {
                    n5 += n7;
                }
                if (n7 <= 0) continue;
                entry.getValue().addAndGet(n7);
            }
            if (n5 < n4 && enumMap.get(mSAState) != null) {
                enumMap.get(mSAState).addAndGet(n4 - n5);
            }
        }
    }

    static void normilizeMap(EnumMap<ThreadState.MSAState, AtomicInteger> enumMap, int n, int n2) {
        long l = 0L;
        for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : enumMap.entrySet()) {
            l += (long)entry.getValue().get();
        }
        if (l > 0L && l != (long)n * (long)n2 * 100L) {
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : enumMap.entrySet()) {
                long l2 = entry.getValue().get();
                l2 = (int)(l2 * (long)n * (long)n2 * 100L / l);
                entry.getValue().getAndSet((int)l2);
            }
        }
        if (n > 1) {
            int n3 = n / 2;
            int n4 = 0;
            for (Map.Entry<ThreadState.MSAState, AtomicInteger> entry : enumMap.entrySet()) {
                AtomicInteger atomicInteger = entry.getValue();
                n4 = n3;
                n3 = (atomicInteger.get() + n4) % n;
                atomicInteger.set((atomicInteger.get() + n4) / n);
            }
        }
    }

    static int point2index(ThreadsDataManager threadsDataManager, ThreadsPanel threadsPanel, ThreadStateColumnImpl threadStateColumnImpl, Point point, int n) {
        int n2;
        long l = threadsDataManager.getEndTime();
        if (threadStateColumnImpl != null && (n2 = ThreadStateColumnImpl.getFirstVisibleDataUnit(threadStateColumnImpl, threadsPanel)) != -1) {
            n = Math.abs(n);
            if (threadsPanel.getViewEnd() - threadsPanel.getViewStart() > 0L) {
                float f = (float)n / (float)(threadsPanel.getViewEnd() - threadsPanel.getViewStart());
                while (n2 < threadStateColumnImpl.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColumnImpl.getThreadStateAt(n2).getTimeStamp()) <= threadsPanel.getViewEnd()) {
                    if (threadStateColumnImpl.isAlive(n2)) {
                        int n3;
                        ThreadState threadState = threadStateColumnImpl.getThreadStateAt(n2);
                        int n4 = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) - threadsPanel.getViewStart()) * f), 0);
                        if (n2 < threadStateColumnImpl.size() - 1) {
                            n3 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColumnImpl.getThreadStateAt(n2 + 1).getTimeStamp()) - threadsPanel.getViewStart()) * f), n);
                        } else {
                            int n5 = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadState.getMSASamplePeriod());
                            n3 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) + (long)n5 - threadsPanel.getViewStart()) * f), n);
                        }
                        if (n4 <= point.x && point.x < n3) {
                            return n2;
                        }
                    }
                    ++n2;
                }
            }
        }
        return -1;
    }

    static int getFirstVisibleDataUnit(ThreadStateColumnImpl threadStateColumnImpl, ThreadsPanel threadsPanel) {
        for (int i = 0; i < threadStateColumnImpl.size(); ++i) {
            long l = ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColumnImpl.getThreadStateAt(i).getTimeStamp());
            if (l <= threadsPanel.getViewEnd() && i == threadStateColumnImpl.size() - 1) {
                return i;
            }
            if (!(l <= threadsPanel.getViewStart() ? ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColumnImpl.getThreadStateAt(i + 1).getTimeStamp()) > threadsPanel.getViewStart() : l <= threadsPanel.getViewEnd())) continue;
            return i;
        }
        return -1;
    }

    ThreadStateColumnImpl(ThreadsDataManager.MergedThreadInfo mergedThreadInfo, ThreadData threadData) {
        this.info = mergedThreadInfo;
        this.stackProvider = threadData;
    }

    public void setRunning(int n) {
        this.comparable.set(n);
    }

    public int getRunning() {
        return this.comparable.get();
    }

    @Override
    public String getName() {
        return this.info.getThreadName();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isAlive(int n) {
        if (this.list.get(n) == null || this.list.get(n).getMSAState(0, false) == null) {
            return true;
        }
        return !this.list.get(n).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished);
    }

    @Override
    public ThreadState getThreadStateAt(int n) {
        return this.list.get(n);
    }

    @Override
    public boolean isAlive() {
        return !this.list.get(this.list.size() - 1).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished);
    }

    void updateName(String string) {
        this.info.setThreadName(string);
    }

    void resetName() {
        this.info.resetName();
    }

    void add(ThreadState threadState) {
        this.list.add(threadState);
    }

    void removeStopMark() {
        if (this.list.size() > 0 && this.list.get(this.list.size() - 1).getMSAState(0, false).equals((Object)ThreadState.MSAState.ThreadFinished)) {
            this.list.remove(this.list.size() - 1);
        }
    }

    void clearStates() {
        this.list.clear();
    }

    int getThreadID() {
        return this.info.getThreadId();
    }

    long getThreadStartTimeStamp() {
        return this.info.getStartTimeStamp();
    }

    void updateStackProvider(ThreadData threadData) {
        if (threadData != null) {
            this.stackProvider = threadData;
        }
    }
}

