/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.dlight.visualizers.threadmap.TableCellRendererPersistent;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;

public abstract class EnhancedTableCellRenderer
extends JPanel
implements TableCellRendererPersistent {
    protected boolean supportsFocusBorder;
    private Border originalBorder;
    private Color darkerUnselectedBackground;
    private Color unselectedBackground;
    private Color unselectedForeground;
    private Insets originalBorderInsets;
    private int horizontalAlignment;

    public EnhancedTableCellRenderer() {
        this.setOpaque(true);
        this.supportsFocusBorder = false;
        this.horizontalAlignment = 10;
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
        this.darkerUnselectedBackground = UIUtils.getDarker(this.unselectedBackground);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.originalBorder = border;
        if (this.originalBorder != null) {
            this.originalBorderInsets = this.originalBorder.getBorderInsets(this);
        }
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setSupportsFocusBorder(boolean bl) {
        this.supportsFocusBorder = bl;
        if (bl && this.originalBorder == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public boolean getSupportsFocusBorder() {
        return this.supportsFocusBorder;
    }

    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.supportsFocusBorder) {
            if (bl2 && bl && this.originalBorder != null) {
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtils.getDarkerLine(jTable.getSelectionBackground())), BorderFactory.createEmptyBorder(this.originalBorderInsets.top, this.originalBorderInsets.left - 1, this.originalBorderInsets.bottom, this.originalBorderInsets.right));
                super.setBorder(compoundBorder);
            } else {
                super.setBorder(this.originalBorder);
            }
        }
        if (bl && jTable.isEnabled()) {
            this.setRowForeground(jTable.isFocusOwner() ? jTable.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            this.setRowBackground(jTable.isFocusOwner() ? jTable.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if (!jTable.isEnabled()) {
            this.setRowForeground(UIManager.getColor("TextField.inactiveForeground"));
            this.setRowBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else if ((n & 1) == 0) {
            this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            this.setRowBackground(this.darkerUnselectedBackground != null ? this.darkerUnselectedBackground : UIUtils.getDarker(jTable.getBackground()));
        } else {
            this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            this.setRowBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setState(jTable, object, bl, bl2, n, n2);
        this.setValue(jTable, object, n, n2);
        return this;
    }

    public abstract Component getTableCellRendererComponentPersistent(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    public static Color getDarker(Color color) {
        return UIUtils.getSafeColor(color.getRed() - 30, color.getGreen() - 30, color.getBlue() - 30);
    }

    protected void setRowBackground(Color color) {
        this.setBackground(color);
    }

    protected void setRowForeground(Color color) {
        this.setForeground(color);
    }

    protected abstract void setValue(JTable var1, Object var2, int var3, int var4);

    protected void setState(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
    }
}

