/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Graphics;
import javax.swing.JViewport;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;

public class CustomTimeLineViewport
extends JViewport {
    private ThreadsPanel viewManager;
    private int paintWidth;
    private int paintX;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;

    public CustomTimeLineViewport(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
        this.syncViewVariables();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setClip(this.paintX, this.getEmptySpaceY(), this.paintWidth, this.getHeight() - this.getEmptySpaceY());
        this.paintTimeMarks(graphics);
    }

    private int getEmptySpaceY() {
        if (this.getView() == null) {
            return 0;
        }
        return this.getView().getHeight();
    }

    private void paintTimeMarks(Graphics graphics) {
        this.syncViewVariables();
        if (this.viewEnd - this.viewStart > 0L) {
            long l;
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            float f = (float)this.paintWidth / (float)(this.viewEnd - this.viewStart);
            int n3 = TimeLineUtils.getOptimalUnits(f);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f2 = i - n;
                int n5 = (int)(f2 * f);
                this.paintTimeTicks(graphics, (int)(f2 * f), (int)((f2 + (float)n3) * f), TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(this.paintX + n5, this.getEmptySpaceY(), this.paintX + n5, this.getHeight() - 1);
            }
            if (this.timeLine != null && this.viewStart < (l = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && l < this.viewEnd) {
                int n6 = (int)((long)this.paintWidth * (l - this.viewStart) / (this.viewEnd - this.viewStart));
                graphics.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
                if (this.getHeight() - 1 - this.getEmptySpaceY() < 5) {
                    graphics.drawLine(this.paintX + n6, this.getEmptySpaceY(), this.paintX + n6, this.getHeight() - 1);
                } else {
                    graphics.drawLine(this.paintX + n6, this.getEmptySpaceY(), this.paintX + n6, this.getHeight() - 1 - 5);
                    graphics.drawLine(this.paintX + n6 - 3, this.getHeight() - 1, this.paintX + n6 - 3, this.getHeight() - 1 - 2);
                    graphics.drawLine(this.paintX + n6 - 3, this.getHeight() - 1 - 2, this.paintX + n6, this.getHeight() - 1 - 5);
                    graphics.drawLine(this.paintX + n6, this.getHeight() - 1 - 5, this.paintX + n6 + 3, this.getHeight() - 1 - 2);
                    graphics.drawLine(this.paintX + n6 + 3, this.getHeight() - 1 - 2, this.paintX + n6 + 3, this.getHeight() - 1);
                    graphics.drawLine(this.paintX + n6 + 3, this.getHeight() - 1, this.paintX + n6 - 3, this.getHeight() - 1);
                }
            }
        }
    }

    private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
        float f = (float)(n2 - n) / (float)n3;
        graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < n3; ++i) {
            int n4 = n + (int)((float)i * f);
            graphics.drawLine(this.paintX + n4, this.getEmptySpaceY(), this.paintX + n4, this.getHeight() - 1);
        }
    }

    private void syncViewVariables() {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.timeLine = this.viewManager.getTimeLine();
        this.paintWidth = this.viewManager.getDisplayColumnWidth();
        int n = this.viewManager.getDisplayColumnRest();
        this.paintX = this.getWidth() - this.paintWidth - n;
    }
}

