/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.support.SpinnerTimeEditor;
import org.netbeans.modules.dlight.visualizers.support.SpinnerTimeModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeIntervalPanel
extends JPanel
implements DataFilterListener {
    private DataFilterManager manager;
    private final ChangeListener startTimeChangeListener = new StartTimeSpinnerListener();
    private final ChangeListener endTimeChangeListener = new EndTimeSpinnerListener();
    private final UILock uiLock = new UILock();
    private JSpinner endTimeSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner startTimeSpinner;

    public TimeIntervalPanel(DataFilterManager dataFilterManager) {
        this.initComponents();
        this.manager = dataFilterManager;
        if (dataFilterManager != null) {
            this.manager.addDataFilterListener((DataFilterListener)this);
            this.update(dataFilterManager.getDataFilter(TimeIntervalDataFilter.class));
        }
        this.startTimeSpinner.addChangeListener(this.startTimeChangeListener);
        this.endTimeSpinner.addChangeListener(this.endTimeChangeListener);
    }

    public void update(DataFilterManager dataFilterManager) {
        if (this.manager != null) {
            this.manager.removeDataFilterListener((DataFilterListener)this);
        }
        this.manager = dataFilterManager;
        if (this.manager != null) {
            this.manager.addDataFilterListener((DataFilterListener)this);
        }
        this.update(dataFilterManager == null ? null : dataFilterManager.getDataFilter(TimeIntervalDataFilter.class));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.startTimeSpinner = new JSpinner();
        this.endTimeSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel1.text"));
        this.startTimeSpinner.setModel(new SpinnerTimeModel());
        this.startTimeSpinner.setEditor(new SpinnerTimeEditor(this.startTimeSpinner));
        this.endTimeSpinner.setModel(new SpinnerTimeModel());
        this.endTimeSpinner.setEditor(new SpinnerTimeEditor(this.endTimeSpinner));
        this.endTimeSpinner.setValue(Long.MAX_VALUE);
        this.jLabel2.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(TimeIntervalPanel.class, (String)"TimeIntervalPanel.jLabel3.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(18, 18, 18).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.startTimeSpinner, -2, 80, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.endTimeSpinner, -2, 80, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.endTimeSpinner, -2, -1, -2).add((Component)this.startTimeSpinner, -2, -1, -2)).addContainerGap()));
    }

    public Range<Long> getSelectedInterval() {
        return new Range((Number)((Long)this.startTimeSpinner.getValue()), (Number)((Long)this.endTimeSpinner.getValue()));
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                TimeIntervalPanel.this.update(TimeIntervalPanel.this.manager.getDataFilter(TimeIntervalDataFilter.class));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(Collection<TimeIntervalDataFilter> collection) {
        TimeIntervalDataFilter timeIntervalDataFilter = null;
        if (collection != null && !collection.isEmpty()) {
            timeIntervalDataFilter = collection.iterator().next();
        }
        UILock uILock = this.uiLock;
        synchronized (uILock) {
            this.startTimeSpinner.removeChangeListener(this.startTimeChangeListener);
            this.endTimeSpinner.removeChangeListener(this.endTimeChangeListener);
            this.startTimeSpinner.setValue(timeIntervalDataFilter == null ? 0L : (Long)timeIntervalDataFilter.getInterval().getStart());
            this.endTimeSpinner.setValue(timeIntervalDataFilter == null ? Long.MAX_VALUE : (Long)timeIntervalDataFilter.getInterval().getEnd());
            this.startTimeSpinner.addChangeListener(this.startTimeChangeListener);
            this.endTimeSpinner.addChangeListener(this.endTimeChangeListener);
        }
    }

    private void applyFilter() {
        if (this.manager != null) {
            this.manager.addDataFilter((DataFilter)TimeIntervalDataFilterFactory.create((Range)new Range((Number)((Long)this.startTimeSpinner.getValue()), (Number)((Long)this.endTimeSpinner.getValue()))), false);
        }
    }

    private static final class UILock {
        private UILock() {
        }
    }

    private final class EndTimeSpinnerListener
    implements ChangeListener {
        private EndTimeSpinnerListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if ((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() >= (Long)TimeIntervalPanel.this.endTimeSpinner.getValue()) {
                TimeIntervalPanel.this.startTimeSpinner.setValue((Long)TimeIntervalPanel.this.endTimeSpinner.getValue() - 1L);
            }
            TimeIntervalPanel.this.applyFilter();
        }
    }

    private final class StartTimeSpinnerListener
    implements ChangeListener {
        private StartTimeSpinnerListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if ((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() >= (Long)TimeIntervalPanel.this.endTimeSpinner.getValue()) {
                TimeIntervalPanel.this.endTimeSpinner.setValue((Long)TimeIntervalPanel.this.startTimeSpinner.getValue() + 1L);
            }
            TimeIntervalPanel.this.applyFilter();
        }
    }
}

