/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadMapVisualizer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadMapTopComponent
extends TopComponent
implements VisualizerContainer {
    private static ThreadMapTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/dlight/visualizers/resources/threadsWindow.png";
    private static final String PREFERRED_ID = "ThreadMapTopComponent";
    private String currentToolName;
    private JComponent viewComponent;

    public ThreadMapTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"CTL_ThreadMapTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"HINT_ThreadMapTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ThreadMapTopComponent getDefault() {
        if (instance == null) {
            instance = new ThreadMapTopComponent();
        }
        return instance;
    }

    public static synchronized ThreadMapTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(ThreadMapTopComponent.class.getName()).warning("Cannot find ThreadMapTopComponent component. It will not be located properly in the window system.");
            return ThreadMapTopComponent.getDefault();
        }
        if (topComponent instanceof ThreadMapTopComponent) {
            return (ThreadMapTopComponent)topComponent;
        }
        Logger.getLogger(ThreadMapTopComponent.class.getName()).warning("There seem to be multiple components with the 'ThreadMapTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ThreadMapTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)this.viewComponent).shutdown();
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            this.viewComponent.requestFocus();
        }
    }

    void writeProperties(Properties properties) {
        properties.setProperty("version", "1.0");
    }

    Object readProperties(Properties properties) {
        ThreadMapTopComponent threadMapTopComponent = ThreadMapTopComponent.getDefault();
        threadMapTopComponent.readPropertiesImpl(properties);
        return threadMapTopComponent;
    }

    private void readPropertiesImpl(Properties properties) {
        String string = properties.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void addVisualizer(String string, String string2, Visualizer<?> visualizer) {
        if (visualizer instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)visualizer).setToolID(string);
        }
        this.setContent(string2, visualizer.getComponent());
        visualizer.refresh();
    }

    public void setContent(String string, JComponent jComponent) {
        if (this.currentToolName != null && this.currentToolName.equals(string) && this.viewComponent == jComponent) {
            return;
        }
        this.currentToolName = string;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.viewComponent = jComponent;
        this.add(this.viewComponent, "Center");
        this.setName(string);
        this.setToolTipText(string);
        this.validate();
        this.repaint();
    }

    public void addContent(String string, JComponent jComponent) {
        if (this.currentToolName == null || !this.currentToolName.equals(string) || this.viewComponent != jComponent) {
            this.currentToolName = string;
            this.removeAll();
            this.setLayout(new BorderLayout());
        }
        this.viewComponent = jComponent;
        this.add(this.viewComponent);
        this.setName(string);
        this.setToolTipText(string);
        this.validate();
        this.repaint();
    }

    public void removeVisualizer(final Visualizer<?> visualizer) {
        if (EventQueue.isDispatchThread()) {
            this.closePerformanceMonitor(visualizer);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ThreadMapTopComponent.this.closePerformanceMonitor(visualizer);
                }
            });
        }
    }

    public void showup() {
        this.open();
        this.requestActive();
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ThreadMapVisualizer threadMapVisualizer = (ThreadMapVisualizer)this.viewComponent;
            threadMapVisualizer.startup();
        }
    }

    private void closePerformanceMonitor(Visualizer<?> visualizer) {
        if (this.viewComponent != visualizer.getComponent()) {
            return;
        }
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)visualizer).shutdown();
        }
        this.remove(visualizer.getComponent());
        this.setName(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"ThreadMapDetailes"));
        this.repaint();
    }
}

