/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.bridge.AppServerBridge;
import org.netbeans.modules.j2ee.sun.bridge.DirectoryDeploymentFacility;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DirectoryDeployment
extends IncrementalDeployment {
    private SunDeploymentManagerInterface dm;

    public DirectoryDeployment() {
    }

    public DirectoryDeployment(DeploymentManager manager) {
        this.setDeploymentManager(manager);
    }

    public String[] getDeploymentPlanFileNames(ModuleType type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid null argumment");
        }
        String[] s = type.equals(ModuleType.WAR) ? new String[]{"WEB-INF/sun-web.xml"} : (type.equals(ModuleType.EJB) ? new String[]{"META-INF/sun-ejb-jar.xml", "META-INF/sun-cmp-mappings.xml"} : (type.equals(ModuleType.EAR) ? new String[]{"META-INF/sun-application.xml"} : (type.equals(ModuleType.RAR) ? new String[]{"META-INF/sun-connector.xml"} : (type.equals(ModuleType.CAR) ? new String[]{"META-INF/sun-application-client.xml"} : new String[]{".timestamp"}))));
        return s;
    }

    public File getDirectoryForModule(TargetModuleID module) {
        String TCONST;
        if (null == this.dm) {
            throw new IllegalStateException("invalid dm value");
        }
        File appDir = AppServerBridge.getDirLocation(module);
        String path = appDir.getPath();
        if (path.contains(TCONST = "${com.sun.aas.installRoot}")) {
            int dex = path.indexOf(TCONST);
            if (dex > 0) {
                path = path.substring(dex);
            }
            path = path.replace(TCONST, this.dm.getPlatformRoot().getAbsolutePath());
            appDir = new File(path);
        }
        if (null != appDir && appDir.getPath().contains("${")) {
            throw new IllegalStateException(NbBundle.getMessage(DirectoryDeployment.class, (String)"ERR_UndeployAndRedeploy"));
        }
        return appDir;
    }

    public void setDeploymentManager(DeploymentManager manager) {
        if (null == manager) {
            throw new IllegalArgumentException("invalid null argumment");
        }
        if (!(manager instanceof SunDeploymentManagerInterface)) {
            throw new IllegalArgumentException("setDeploymentManager: Invalid manager type, expecting SunDeploymentManager and got " + manager.getClass().getName());
        }
        this.dm = (SunDeploymentManagerInterface)manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProgressObject incrementalDeploy(TargetModuleID tmid, AppChangeDescriptor aCD) {
        ProgressObject retVal = null;
        Thread holder = Thread.currentThread();
        try {
            this.dm.grabInnerDM(holder, false);
            DirectoryDeploymentFacility ddf = new DirectoryDeploymentFacility(this.dm.getHost(), this.dm.getPort(), this.dm.getUserName(), this.dm.getPassword(), this.dm.isSecure());
            retVal = ddf.incrementalDeploy(tmid);
            if (null != retVal) {
                retVal.addProgressListener((ProgressListener)new Releaser(this.dm, holder));
            }
        }
        finally {
            if (null == retVal) {
                this.dm.releaseInnerDM(holder);
            }
        }
        return retVal;
    }

    public String getModuleUrl(TargetModuleID module) {
        String retVal = AppServerBridge.getModuleUrl(module);
        if (!retVal.startsWith("/")) {
            retVal = "/" + retVal;
        }
        return retVal;
    }

    private String computeModuleID(J2eeModule app, File dir) {
        FileObject fo;
        String moduleID = null;
        File foo = app.getDeploymentConfigurationFile("application.xml");
        if (foo.exists()) {
            fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)foo));
            try {
                if (null != fo) {
                    Application appdd = org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(fo);
                    moduleID = appdd.getDisplayName(null);
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, ioe);
            }
            catch (VersionNotSupportedException vnse) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, vnse);
            }
        }
        if (null == moduleID && (foo = app.getDeploymentConfigurationFile("web.xml")).exists()) {
            fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)foo));
            try {
                if (null != fo) {
                    WebApp webdd = org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(fo);
                    moduleID = webdd.getDisplayName(null);
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, ioe);
            }
            catch (VersionNotSupportedException vnse) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, vnse);
            }
        }
        if (null == moduleID && (foo = app.getDeploymentConfigurationFile("ejb-jar.xml")).exists()) {
            fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)foo));
            try {
                if (null != fo) {
                    EjbJar ejbdd = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getDDRoot(fo);
                    moduleID = ejbdd.getDisplayName(null);
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, ioe);
            }
            catch (VersionNotSupportedException vnse) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, vnse);
            }
        }
        if (null == moduleID && (foo = app.getDeploymentConfigurationFile("application-client.xml")).exists()) {
            fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)foo));
            try {
                if (null != fo) {
                    AppClient acdd = DDProvider.getDefault().getDDRoot(fo);
                    moduleID = acdd.getDisplayName(null);
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, ioe);
            }
            catch (VersionNotSupportedException vnse) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, vnse);
            }
        }
        if (null == moduleID || moduleID.trim().length() < 1) {
            fo = null;
            try {
                fo = app.getContentDirectory();
                moduleID = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)fo)).getName();
            }
            catch (IOException ioe) {
                Logger.getLogger(DirectoryDeployment.class.getName()).log(Level.FINER, null, ioe);
            }
        }
        moduleID = null == moduleID || moduleID.trim().length() < 1 ? this.simplifyModuleID(dir.getParentFile().getParentFile().getName()) : this.simplifyModuleID(moduleID);
        return moduleID;
    }

    private String simplifyModuleID(String candidateID) {
        String moduleID = null;
        if (candidateID == null) {
            moduleID = "_default_" + ((Object)((Object)this)).hashCode();
        } else if (candidateID.equals("")) {
            moduleID = "_default_" + ((Object)((Object)this)).hashCode();
        }
        if (null == moduleID) {
            moduleID = candidateID.replace(' ', '_');
            if (moduleID.startsWith("/")) {
                moduleID = moduleID.substring(1);
            }
            moduleID = moduleID.replace('\\', '_').replace('/', '_');
            moduleID = moduleID.replace(':', '_').replace('*', '_');
            moduleID = moduleID.replace('?', '_').replace('\"', '_');
            moduleID = moduleID.replace('<', '_').replace('>', '_');
            moduleID = moduleID.replace('|', '_');
            moduleID = moduleID.replace(',', '_').replace('=', '_');
            moduleID = moduleID.replace('(', '_').replace(')', '_');
        }
        return moduleID;
    }

    public File getDirectoryForNewApplication(Target target, DeployableObject deployableObject, DeploymentConfiguration deploymentConfiguration) {
        return null;
    }

    public File getDirectoryForNewApplication(String deploymentName, Target target, DeploymentConfiguration configuration) {
        return null;
    }

    public File getDirectoryForNewModule(File file, String str, DeployableObject deployableObject, DeploymentConfiguration deploymentConfiguration) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject initialDeploy(Target target, J2eeModule app, ModuleConfiguration configuration, File dir) {
        ContextRootConfiguration crp = (ContextRootConfiguration)configuration.getLookup().lookup(ContextRootConfiguration.class);
        String moduleID = this.computeModuleID(app, dir);
        ProgressObject retVal = null;
        Thread holder = Thread.currentThread();
        try {
            this.dm.grabInnerDM(holder, false);
            DirectoryDeploymentFacility ddf = new DirectoryDeploymentFacility(this.dm.getHost(), this.dm.getPort(), this.dm.getUserName(), this.dm.getPassword(), this.dm.isSecure());
            retVal = ddf.initialDeploy(target, dir, moduleID);
            retVal.addProgressListener((ProgressListener)new Releaser(this.dm, holder));
        }
        finally {
            if (null == retVal) {
                this.dm.releaseInnerDM(holder);
            }
        }
        return retVal;
    }

    public boolean canFileDeploy(Target target, J2eeModule deployable) {
        throw new UnsupportedOperationException();
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule app, ModuleConfiguration configuration) {
        File dest = null;
        if (app.getModuleType() == J2eeModule.EAR) {
            File tmp = this.getProjectDir(app);
            if (null == tmp) {
                return dest;
            }
            dest = new File(tmp, "target");
            if (!dest.exists()) {
                dest = new File(tmp, "dist");
            }
            if (dest.isFile() || dest.isDirectory() && !dest.canWrite()) {
                throw new IllegalStateException();
            }
            if (!(dest = new File(dest, "gfdeploy")).exists()) {
                dest.mkdirs();
            }
            if (!dest.isDirectory()) {
                dest = null;
            }
        }
        return dest;
    }

    private File getProjectDir(J2eeModule app) {
        try {
            FileObject fo = app.getContentDirectory();
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (null != p) {
                fo = p.getProjectDirectory();
                return FileUtil.toFile((FileObject)fo);
            }
        }
        catch (IOException ex) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINER, null, ex);
        }
        File tmp = app.getResourceDirectory();
        if (tmp != null) {
            return tmp.getParentFile();
        }
        return null;
    }

    public File getDirectoryForNewApplication(String deploymentName, Target target, ModuleConfiguration configuration) {
        File retValue = super.getDirectoryForNewApplication(deploymentName, target, configuration);
        return retValue;
    }

    public File getDirectoryForNewModule(File appDir, String uri, J2eeModule module, ModuleConfiguration configuration) {
        return new File(appDir, DirectoryDeployment.transform(this.removeLeadSlash(uri)));
    }

    private String removeLeadSlash(String s) {
        if (null == s) {
            return s;
        }
        if (s.length() < 1) {
            return s;
        }
        if (!s.startsWith("/")) {
            return s;
        }
        return s.substring(1);
    }

    public static String transform(String s) {
        StringBuffer sb;
        char tmp;
        int len = s.length();
        if (len > 4 && (tmp = (sb = new StringBuffer(s)).charAt(len - 4)) == '.') {
            sb.setCharAt(len - 4, '_');
            return sb.toString();
        }
        return s;
    }

    public void notifyDeployment(TargetModuleID module) {
        super.notifyDeployment(module);
    }

    private static class Releaser
    implements ProgressListener {
        SunDeploymentManagerInterface dm;
        Thread holder;

        Releaser(SunDeploymentManagerInterface dm, Thread holder) {
            this.dm = dm;
            this.holder = holder;
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            DeploymentStatus dms = progressEvent.getDeploymentStatus();
            if (!dms.isRunning()) {
                this.dm.releaseInnerDM(this.holder);
            }
        }
    }
}

