/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.j2ee.sun.persistence.mapping.core;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.AbstractState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.ClassState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.FieldState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.RelationshipState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.TableState;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class FieldHolderState
extends AbstractState
implements Cloneable {
    private static final int NATURAL = 0;
    private static final int REMOVE_DELIM = 1;
    private static final int NATURAL_COMPOUND = 2;
    private static final int REMOVE_DELIM_COMPOUND = 3;
    private ClassState _classState;
    private Map _fieldStates;
    private Map _fetchGroups;
    private Map _extraClassStates;

    public FieldHolderState(ClassState declaringClass) {
        super(declaringClass.getModel(), declaringClass.getMappingClassElement());
        declaringClass.setFieldHolderState(this);
        this._fieldStates = new HashMap();
        this._fetchGroups = new HashMap();
        this._extraClassStates = new HashMap();
        this.updateFieldStates(declaringClass.getTableState());
    }

    public FieldHolderState(ClassState declaringClass, PersistenceFieldElement field) {
        this(declaringClass);
        this.addFieldMapping(field);
    }

    public Object clone() {
        FieldHolderState clonedState = (FieldHolderState)super.clone();
        clonedState._fieldStates = this.getClonedMap(this._fieldStates);
        clonedState._fetchGroups = new HashMap(this._fetchGroups);
        clonedState._extraClassStates = this.getClonedMap(this._extraClassStates);
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        Iterator<Object> iterator = this.getFieldStates().iterator();
        lDump.append("Modified Fields are \n");
        while (iterator.hasNext()) {
            lDump.append(((FieldState)iterator.next()).getDebugInfo());
        }
        lDump.append("Modified Fetch groups are \n");
        for (PersistenceFieldElement field : this._fetchGroups.keySet()) {
            lDump.append("\tFetch group for " + field + " is " + this._fetchGroups.get(field) + "\n");
        }
        return lDump.toString();
    }

    public ClassState getClassState() {
        return this._classState;
    }

    protected void setClassState(ClassState state) {
        this._classState = state;
    }

    protected Map getExtraClassStates() {
        return Collections.unmodifiableMap(this._extraClassStates);
    }

    public TableState getTableState() {
        return this.getClassState().getTableState();
    }

    public TableState getTableState(String relatedClass) {
        TableState relatedState = null;
        if (relatedClass != null) {
            ClassState relatedClassState = null;
            if (relatedClass.equals(this.getMappingClassElement().getName())) {
                relatedClassState = this.getClassState();
            } else {
                relatedClassState = (ClassState)this._extraClassStates.get(relatedClass);
                if (relatedClassState == null) {
                    Model model = this.getModel();
                    relatedClassState = new ClassState(model, model.getMappingClass(relatedClass));
                    this._extraClassStates.put(relatedClass, relatedClassState);
                }
            }
            relatedState = relatedClassState.getTableState();
        }
        return relatedState;
    }

    public void setTableState(String relatedClass, TableElement primaryTable) {
        if (relatedClass != null) {
            ClassState relatedClassState = (ClassState)this._extraClassStates.get(relatedClass);
            if (relatedClassState == null) {
                Model model = this.getModel();
                relatedClassState = new ClassState(model, model.getMappingClass(relatedClass));
                this._extraClassStates.put(relatedClass, relatedClassState);
            }
            relatedClassState.getTableState().setCurrentPrimaryTable(primaryTable);
        }
    }

    protected Collection getFieldStates() {
        return Collections.unmodifiableCollection(this._fieldStates.values());
    }

    public FieldState getFieldState(PersistenceFieldElement field) {
        return (FieldState)this._fieldStates.get(field);
    }

    public RelationshipState getFieldState(RelationshipElement field) {
        return (RelationshipState)this.getFieldState((PersistenceFieldElement)field);
    }

    public FieldState getCurrentStateForField(PersistenceFieldElement field) {
        FieldState lState = this.getFieldState(field);
        if (lState == null) {
            lState = this.getMappedStateForField(field);
        }
        return lState;
    }

    public RelationshipState getCurrentStateForField(RelationshipElement field) {
        return (RelationshipState)this.getCurrentStateForField((PersistenceFieldElement)field);
    }

    public FieldState getMappedStateForField(PersistenceFieldElement field) {
        if (field != null) {
            if (field instanceof RelationshipElement) {
                return this.getMappedStateForField((RelationshipElement)field);
            }
            return new FieldState(this, field, this.getMappedMapping(field));
        }
        return null;
    }

    public RelationshipState getMappedStateForField(RelationshipElement field) {
        return RelationshipState.getMappedStateForField(this, field);
    }

    public List getCurrentMapping(PersistenceFieldElement field) {
        FieldState state = this.getCurrentStateForField(field);
        if (state != null) {
            return Collections.unmodifiableList(state instanceof RelationshipState ? ((RelationshipState)state).getColumnPairState().getCompletePairs() : state.getLocalColumns());
        }
        return this.getMappedMapping(field);
    }

    public void setCurrentMapping(PersistenceFieldElement field, ColumnElement column) {
        this.setCurrentMapping(field, column != null ? Collections.singletonList(column) : null);
    }

    public void setCurrentMapping(PersistenceFieldElement field, List members) {
        FieldState state = this.getFieldState(field);
        if (state == null) {
            state = this.addFieldMapping(field);
        }
        state.setMapping(members);
    }

    public boolean setCurrentMapping(RelationshipElement field, RelationshipState state) {
        boolean stateHasData = false;
        if (state != null && state.getColumnPairState().hasCompleteRows()) {
            this.replaceFieldState((PersistenceFieldElement)field, state);
            this.initializeInverseMapping(field);
            stateHasData = true;
        }
        return stateHasData;
    }

    protected List getMappedMapping(PersistenceFieldElement field) {
        MappingFieldElement mappingField;
        MappingClassElement mappingClass = this.getMappingClassElement();
        ArrayList members = new ArrayList();
        if (mappingClass != null && (mappingField = mappingClass.getField(field.getName())) != null) {
            members.addAll(mappingField.getColumns());
            if (mappingField instanceof MappingRelationshipElement) {
                members.addAll(((MappingRelationshipElement)mappingField).getAssociatedColumns());
            }
        }
        return members;
    }

    public ColumnElement getDefaultMapping(PersistenceFieldElement field) {
        List candidateColumns = this.getTableState().getSortedAllColumns();
        if (candidateColumns != null && field != null) {
            Iterator iterator = candidateColumns.iterator();
            String fieldName = field.getName();
            Object[] matches = new Object[]{null, null, null, null};
            int count = matches.length;
            while (iterator.hasNext()) {
                ColumnElement next = (ColumnElement)iterator.next();
                String colName = next.getName().getName();
                String strippedColName = null;
                String tableName = null;
                String strippedTableName = null;
                if (fieldName.equalsIgnoreCase(colName)) {
                    this.insertElement(matches, 0, next);
                    break;
                }
                strippedColName = this.getStrippedName(colName);
                if (fieldName.equalsIgnoreCase(strippedColName)) {
                    this.insertElement(matches, 1, next);
                }
                if (fieldName.equalsIgnoreCase((tableName = next.getDeclaringTable().getName().getName()) + colName)) {
                    this.insertElement(matches, 2, next);
                }
                if (!fieldName.equalsIgnoreCase((strippedTableName = this.getStrippedName(tableName)) + strippedColName) && !fieldName.equalsIgnoreCase(strippedTableName + colName) && !fieldName.equalsIgnoreCase(tableName + strippedColName)) continue;
                this.insertElement(matches, 3, next);
            }
            for (int i = 0; i < count; ++i) {
                if (matches[i] == null) continue;
                return (ColumnElement)matches[i];
            }
        }
        return null;
    }

    public void addDefaultMapping() {
        this.addDefaultMapping(true);
    }

    public void addDefaultMapping(boolean overwrite) {
        PersistenceFieldElement[] fields = this.getPersistenceClassElement().getFields();
        int count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            List columns;
            PersistenceFieldElement field = fields[i];
            boolean okToMap = overwrite;
            if (!(okToMap || (columns = this.getCurrentMapping(field)) != null && columns.size() != 0)) {
                okToMap = true;
            }
            if (!okToMap) continue;
            if (field instanceof RelationshipElement) {
                RelationshipElement rel = (RelationshipElement)field;
                this.setCurrentMapping(rel, RelationshipState.getDefaultStateForField(this, rel));
                continue;
            }
            ColumnElement candidate = this.getDefaultMapping(field);
            if (candidate == null) continue;
            this.setCurrentMapping(field, candidate);
        }
    }

    private void insertElement(Object[] array, int index, Object element) {
        if (array[index] == null) {
            array[index] = element;
        }
    }

    private String getStrippedName(String originalName) {
        String delimiter = "_";
        if (originalName.indexOf(delimiter) != -1) {
            StringTokenizer st = new StringTokenizer(originalName, delimiter);
            String strippedName = "";
            while (st.hasMoreTokens()) {
                strippedName = strippedName + st.nextToken();
            }
            return strippedName;
        }
        return originalName;
    }

    protected FieldState addFieldMapping(PersistenceFieldElement field) {
        FieldState state = this.getFieldState(field);
        if (state == null) {
            state = field instanceof RelationshipElement ? new RelationshipState(this, (RelationshipElement)field) : new FieldState(this, field);
            this._fieldStates.put(field, state);
        }
        return state;
    }

    public void addFieldMapping(RelationshipElement field, String relatedClass) {
        if (field != null) {
            RelationshipElement relatedField = this.getCurrentRelatedField(field);
            RelationshipState newState = new RelationshipState(this, field);
            this.replaceFieldState((PersistenceFieldElement)field, newState);
            this.setCurrentRelatedClass(field, relatedClass);
            newState.setRelatedField(relatedField);
        }
    }

    public FieldState editFieldMapping(PersistenceFieldElement field, FieldState defaultState) {
        FieldState state = null;
        if (field != null && (state = this.getFieldState(field)) == null && (state = defaultState != null ? defaultState : this.getMappedStateForField(field)) != null) {
            this._fieldStates.put(field, state);
        }
        return state;
    }

    public void replaceFieldState(PersistenceFieldElement field, FieldState state) {
        if (state != null) {
            this._fieldStates.put(field, state);
        } else {
            this._fieldStates.remove(field);
        }
    }

    protected void updateFieldStates(TableState newState) {
        Iterator iterator = this.getFieldsToUnmap(newState).iterator();
        while (iterator.hasNext()) {
            this.clearFieldMapping((PersistenceFieldElement)iterator.next());
        }
    }

    public void clearFieldMapping(PersistenceFieldElement field) {
        if (field instanceof RelationshipElement) {
            RelationshipElement relationship = (RelationshipElement)field;
            RelationshipElement relatedField = field != null ? this.getCurrentRelatedField(relationship) : null;
            this.unmapField(relationship);
            if (relatedField != null) {
                this.getRelatedState(relationship).unmapField(relatedField);
            }
        } else {
            FieldState state = this.getFieldState(field);
            if (state == null) {
                this.addFieldMapping(field);
            } else {
                state.setMapping(null);
            }
        }
    }

    private void unmapField(RelationshipElement field) {
        RelationshipState state = this.getFieldState(field);
        if (state != null) {
            state.setMapping(null);
        } else {
            state = (RelationshipState)this.addFieldMapping((PersistenceFieldElement)field);
            state.setRelatedClass(this.getMappedRelatedClass(field));
            state.setRelatedField(this.getMappedRelatedField(field));
        }
    }

    public void removeFieldMapping(RelationshipElement field) {
        RelationshipState state;
        if (field != null && (state = this.getFieldState(field)) != null) {
            this._fieldStates.remove(state);
        }
    }

    protected Map getFetchGroups() {
        return Collections.unmodifiableMap(this._fetchGroups);
    }

    public Integer getFetchGroup(PersistenceFieldElement fieldElement) {
        Integer _fetchGroup = (Integer)this._fetchGroups.get(fieldElement);
        if (_fetchGroup == null) {
            boolean isMapped;
            boolean isKey = fieldElement.isKey();
            MappingFieldElement mappingField = this.getMappingClassElement().getField(fieldElement.getName());
            boolean bl = isMapped = mappingField != null;
            if (isMapped && !isKey) {
                _fetchGroup = new Integer(mappingField.getFetchGroup());
            }
        }
        return _fetchGroup;
    }

    public void setFetchGroup(PersistenceFieldElement fieldElement, int fetchGroup) {
        this._fetchGroups.put(fieldElement, new Integer(fetchGroup));
    }

    public FieldHolderState getRelatedState(RelationshipElement field) {
        return this.getRelatedState(this.getCurrentRelatedClass(field), true);
    }

    public FieldHolderState getRelatedState(RelationshipElement field, boolean create) {
        return this.getRelatedState(this.getCurrentRelatedClass(field), create);
    }

    protected FieldHolderState getRelatedState(String relatedClass, boolean create) {
        FieldHolderState relatedState = null;
        if (relatedClass != null) {
            ClassState relatedClassState = null;
            if (relatedClass.equals(this.getMappingClassElement().getName())) {
                relatedState = this;
            } else {
                relatedClassState = (ClassState)this._extraClassStates.get(relatedClass);
                if (relatedClassState == null) {
                    Model model = this.getModel();
                    relatedClassState = new ClassState(model, model.getMappingClass(relatedClass));
                    this._extraClassStates.put(relatedClass, relatedClassState);
                }
            }
            if (relatedState == null && (create || relatedClassState.hasFieldHolderState())) {
                relatedState = relatedClassState.getFieldHolderState();
            }
        }
        return relatedState;
    }

    public void addColumnPair(ColumnElement localColumn, ColumnElement foreignColumn, RelationshipElement field, int type) {
        RelationshipState state = this.getFieldState(field);
        if (state != null) {
            state.addColumnPair(localColumn, foreignColumn, type);
        }
    }

    public void editColumnPair(int index, ColumnElement localColumn, ColumnElement foreignColumn, RelationshipElement field, int type, RelationshipState defaultState) {
        RelationshipState state;
        if (field != null && (state = (RelationshipState)this.editFieldMapping((PersistenceFieldElement)field, defaultState)) != null) {
            state.editColumnPair(index, localColumn, foreignColumn, type);
        }
    }

    public void removeColumnPair(int index, RelationshipElement field, int type) {
        RelationshipState state = this.getFieldState(field);
        if (state != null) {
            state.removeColumnPair(index, type);
        }
    }

    public boolean hasPairAt(int index, RelationshipElement field, int type) {
        RelationshipState state = this.getFieldState(field);
        if (state != null) {
            return state.hasPairAt(type, index);
        }
        return false;
    }

    public String getCurrentRelatedClass(RelationshipElement field) {
        RelationshipState state = this.getFieldState(field);
        return state != null ? state.getRelatedClass() : this.getMappedRelatedClass(field);
    }

    public void setCurrentRelatedClass(RelationshipElement field, String relatedClass) {
        RelationshipState state = (RelationshipState)this.addFieldMapping((PersistenceFieldElement)field);
        state.setRelatedClass(relatedClass);
    }

    public String getMappedRelatedClass(RelationshipElement field) {
        return this.getModel().getRelatedClass(field);
    }

    public boolean isLegalMappingForRelatedClass(RelationshipElement field, String newRelatedClass) {
        TableState relState = this.getTableState(newRelatedClass);
        if (relState != null) {
            RelationshipState state = this.getCurrentStateForField(field);
            List pairs = state.isJoinRelationship() ? state.getAssociatedColumnPairState().getCompletePairs() : state.getColumnPairState().getCompletePairs();
            List currentTables = relState.getAllTables();
            for (String[] pair : pairs) {
                if (currentTables.contains(NameUtil.getTableName((String)pair[1]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public RelationshipElement getCurrentRelatedField(RelationshipElement field) {
        RelationshipState state = this.getFieldState(field);
        return state != null ? state.getRelatedField() : this.getMappedRelatedField(field);
    }

    public String getCurrentRelatedFieldName(RelationshipElement field) {
        RelationshipState state = this.getFieldState(field);
        if (state != null) {
            RelationshipElement relatedField = state.getRelatedField();
            return relatedField != null ? relatedField.getName() : null;
        }
        return this.getMappedRelatedFieldName(field);
    }

    public void setCurrentRelatedField(RelationshipElement field, RelationshipElement relatedField) {
        RelationshipElement oldRelatedField = this.getCurrentRelatedField(field);
        if (oldRelatedField != relatedField) {
            if (oldRelatedField != null) {
                this.getRelatedState(field).changeRelatedField(oldRelatedField, null);
            }
            this.changeRelatedField(field, relatedField);
        }
    }

    private void changeRelatedField(RelationshipElement field, RelationshipElement relatedField) {
        RelationshipState state = this.getFieldState(field);
        if (state == null) {
            state = this.getMappedStateForField(field);
            if (state == null) {
                state = new RelationshipState(this, field);
                state.setRelatedClass(this.getMappedRelatedClass(field));
            }
            this._fieldStates.put(field, state);
        }
        state.setRelatedField(relatedField);
        if (relatedField != null) {
            state.setRelatedClass(relatedField.getDeclaringClass().getName());
        }
    }

    public RelationshipElement getMappedRelatedField(RelationshipElement field) {
        return field != null ? field.getInverseRelationship(this.getModel()) : null;
    }

    public String getMappedRelatedFieldName(RelationshipElement field) {
        return field != null ? field.getInverseRelationshipName() : null;
    }

    public List getSortedRelatedFieldCandidates(RelationshipElement field) {
        return RelationshipState.getSortedRelatedFieldCandidates(this, field);
    }

    public RelationshipState addDefaultStateForField(RelationshipElement field, TableElement joinTable, boolean useJoin, boolean mustMatchFlag) {
        RelationshipState state = RelationshipState.getDefaultStateForField(this, field, joinTable, useJoin, mustMatchFlag);
        this.setCurrentMapping(field, state);
        return state;
    }

    public RelationshipState addInverseStateForField(RelationshipElement field) {
        RelationshipState state = RelationshipState.getInverseStateForField(this, field);
        if (state != null) {
            this.replaceFieldState((PersistenceFieldElement)field, state);
        }
        return state;
    }

    private void initializeInverseMapping(RelationshipElement field) {
        RelationshipElement relatedField = this.getCurrentRelatedField(field);
        if (relatedField != null) {
            boolean hasRows;
            RelationshipState current = this.getCurrentStateForField(field);
            boolean bl = hasRows = current != null && current.getColumnPairState().hasCompleteRows();
            if (!hasRows) {
                this.addInverseStateForField(field);
            } else {
                FieldHolderState relatedFieldState = this.getRelatedState(field);
                RelationshipState relatedState = relatedFieldState.getCurrentStateForField(relatedField);
                if (relatedState != null) {
                    relatedState.setRelatedField(field);
                }
            }
        }
    }

    public void setupInverseMapping(RelationshipElement field) {
        RelationshipElement relatedField = this.getCurrentRelatedField(field);
        if (relatedField != null) {
            RelationshipState inverse;
            this.initializeInverseMapping(field);
            if (this == this.getRelatedState(field) && (inverse = RelationshipState.getInverseStateForState(this, this.getCurrentStateForField(field))) != null) {
                this.replaceFieldState((PersistenceFieldElement)relatedField, inverse);
            }
        }
    }

    public boolean hasInvalidSchema(RelationshipElement field) {
        String relatedSchema;
        String thisClass = field.getDeclaringClass().getName();
        String relatedClass = this.getCurrentRelatedClass(field);
        return relatedClass != null && !thisClass.equals(relatedClass) && (relatedSchema = this.getTableState(relatedClass).getCurrentSchemaName()).length() > 0 && !relatedSchema.equals(this.getTableState().getCurrentSchemaName());
    }

    public TableElement getPrimaryTable(String relatedClass) {
        TableState relatedState = this.getTableState(relatedClass);
        return relatedState != null ? relatedState.getCurrentPrimaryTable() : null;
    }

    public List getSortedAllColumns() {
        TableState tableState = this.getTableState();
        return tableState != null ? tableState.getSortedAllColumns() : TableState.getSortedAllColumns(this.getMappingClassElement().getTables());
    }

    public static List getSortedAllColumns(TableElement table) {
        ArrayList<TableElement> list = new ArrayList<TableElement>();
        if (table != null) {
            list.add(table);
        }
        return TableState.getSortedAllColumns(list);
    }

    protected Collection getFieldsToUnmap(TableState newState) {
        TableState myState = this.getTableState();
        Collection list = new ArrayList();
        if (myState != null) {
            Iterator iterator = myState.getRemovedTables(newState).iterator();
            while (iterator.hasNext()) {
                list = this.getFieldsToUnmap((String)iterator.next(), list);
            }
        }
        return list;
    }

    private Collection getFieldsToUnmap(String table, Collection list) {
        PersistenceFieldElement[] fields = this.getPersistenceClassElement().getFields();
        int count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            PersistenceFieldElement nextField = fields[i];
            FieldState fieldState = this.getCurrentStateForField(nextField);
            if (fieldState == null || !fieldState.isMappedToTable(table) || list.contains(nextField)) continue;
            list.add(nextField);
        }
        return list;
    }
}

