/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.collab.chat.ContactListCellRenderer;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.collab.chat.FakeRoster;
import org.netbeans.modules.kenai.collab.chat.FakeRosterEntry;
import org.netbeans.modules.kenai.collab.chat.FakeRosterGroup;
import org.netbeans.modules.kenai.collab.chat.FilterItem;
import org.netbeans.modules.kenai.collab.chat.FilterRenderer;
import org.netbeans.modules.kenai.collab.chat.GroupListItem;
import org.netbeans.modules.kenai.collab.chat.UserListItem;
import org.openide.util.NbBundle;

public class ContactList
extends JPanel {
    private DefaultComboBoxModel filterModel = new DefaultComboBoxModel();
    private DefaultListModel listModel = new DefaultListModel();
    private FakeRoster roster = null;
    private FilterItem oldFilter = new FilterItem();
    private JList contactJList;
    private JScrollPane contactListScrollPane;
    private JComboBox filterCombo;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;

    public ContactList() {
        this.initComponents();
        this.filterCombo.setModel(this.filterModel);
        this.filterCombo.setRenderer(new FilterRenderer());
        this.contactJList.setModel(this.listModel);
        this.contactJList.setCellRenderer(new ContactListCellRenderer());
        this.searchPanel.setVisible(false);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ContactList.this.updateContacts();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ContactList.this.updateContacts();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ContactList.this.updateContacts();
            }
        });
    }

    public void updateFilter() {
        this.roster = new FakeRoster(Kenai.getDefault().getXMPPConnection());
        this.filterModel.removeAllElements();
        this.filterModel.addElement(new FilterItem());
        for (FakeRosterGroup fakeRosterGroup : this.roster.getGroups()) {
            this.filterModel.addElement(new FilterItem(fakeRosterGroup.getName()));
        }
        this.filterCombo.setSelectedIndex(0);
    }

    public void updateContacts() {
        if (this.roster == null) {
            return;
        }
        if (this.filterCombo.getSelectedIndex() != 0) {
            this.oldFilter = (FilterItem)this.filterCombo.getSelectedItem();
            if (this.filterModel.getSize() > 0) {
                this.filterCombo.setSelectedIndex(0);
            }
        }
        Object e = this.contactJList.getSelectedValue();
        this.listModel.clear();
        for (FakeRosterGroup comparable : this.roster.getGroups()) {
            if (!comparable.getName().toLowerCase().contains(this.searchField.getText().toLowerCase())) continue;
            this.listModel.addElement(new GroupListItem(comparable));
        }
        for (FakeRosterEntry fakeRosterEntry : this.roster.getEntries()) {
            UserListItem userListItem = new UserListItem(fakeRosterEntry);
            if (this.listModel.contains(userListItem) || !fakeRosterEntry.getUser().toLowerCase().contains(this.searchField.getText().toLowerCase())) continue;
            this.listModel.addElement(userListItem);
        }
        if (e != null) {
            this.contactJList.setSelectedValue(e, true);
        }
        if (this.contactJList.getSelectedIndex() < 0 && this.listModel.size() > 0) {
            this.contactJList.setSelectedIndex(0);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.contactJList.requestFocus();
    }

    private void initComponents() {
        this.filterCombo = new JComboBox();
        this.contactListScrollPane = new JScrollPane();
        this.contactJList = new JList();
        this.searchPanel = new JPanel();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.setBackground(SystemColor.control);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.setFocusCycleRoot(true);
        this.filterCombo.setNextFocusableComponent(this.contactJList);
        this.filterCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ContactList.this.filterComboItemStateChanged(itemEvent);
            }
        });
        this.filterCombo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ContactList.this.filterComboKeyPressed(keyEvent);
            }
        });
        this.contactJList.setNextFocusableComponent(this.searchField);
        this.contactJList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ContactList.this.contactJListMouseClicked(mouseEvent);
            }
        });
        this.contactJList.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ContactList.this.contactJListFocusLost(focusEvent);
            }
        });
        this.contactJList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ContactList.this.contactJListKeyPressed(keyEvent);
            }
        });
        this.contactListScrollPane.setViewportView(this.contactJList);
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 5, 3));
        this.searchPanel.setOpaque(false);
        this.searchField.setNextFocusableComponent(this.filterCombo);
        this.searchField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ContactList.this.searchFieldFocusLost(focusEvent);
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ContactList.this.searchFieldKeyPressed(keyEvent);
            }
        });
        this.searchLabel.setText(NbBundle.getMessage(ContactList.class, (String)"ContactList.searchLabel.text", (Object[])new Object[0]));
        GroupLayout groupLayout = new GroupLayout((Container)this.searchPanel);
        this.searchPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.searchLabel).addPreferredGap(0).add((Component)this.searchField, -1, 186, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.searchLabel).add((Component)this.searchField, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.filterCombo, 0, 247, Short.MAX_VALUE).add((Component)this.searchPanel, -1, -1, Short.MAX_VALUE).add((Component)this.contactListScrollPane, -1, 247, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.filterCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.contactListScrollPane, -1, 235, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.searchPanel, -2, -1, -2)));
    }

    private void filterComboItemStateChanged(ItemEvent itemEvent) {
        this.listModel.clear();
        if (this.filterCombo.getSelectedIndex() <= 0) {
            for (FakeRosterGroup comparable : this.roster.getGroups()) {
                this.listModel.addElement(new GroupListItem(comparable));
            }
            for (FakeRosterEntry fakeRosterEntry : this.roster.getEntries()) {
                UserListItem userListItem = new UserListItem(fakeRosterEntry);
                if (this.listModel.contains(userListItem)) continue;
                this.listModel.addElement(userListItem);
            }
        } else {
            String string = ((FilterItem)this.filterCombo.getSelectedItem()).getName();
            FakeRosterGroup fakeRosterGroup = this.roster.getGroup(string);
            this.listModel.addElement(new GroupListItem(fakeRosterGroup));
            for (FakeRosterEntry fakeRosterEntry : fakeRosterGroup.getEntries()) {
                this.listModel.addElement(new UserListItem(fakeRosterEntry));
            }
        }
        this.contactJList.setSelectedIndex(0);
    }

    private void contactJListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            ((ContactListItem)this.contactJList.getSelectedValue()).openChat();
        } else if (keyEvent.getKeyCode() == 27) {
            this.contactJList.requestFocus();
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        } else if (!keyEvent.isActionKey() && ("" + keyEvent.getKeyChar()).trim().length() != 0 && keyEvent.getKeyChar() != '\uffff') {
            this.searchPanel.setVisible(true);
            this.searchField.requestFocus();
            this.searchField.setText("" + keyEvent.getKeyChar());
        }
    }

    private void contactJListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isPopupTrigger()) {
            ((ContactListItem)this.contactJList.getSelectedValue()).openChat();
        }
    }

    private void searchFieldKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.contactJList.requestFocus();
            ((ContactListItem)this.contactJList.getSelectedValue()).openChat();
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        } else if (keyEvent.getKeyCode() == 40) {
            int n = this.contactJList.getSelectedIndex();
            if (n + 1 != this.contactJList.getModel().getSize()) {
                ++n;
            }
            this.contactJList.setSelectedIndex(n);
        } else if (keyEvent.getKeyCode() == 38) {
            int n = this.contactJList.getSelectedIndex();
            if (n != 0) {
                --n;
            }
            this.contactJList.setSelectedIndex(n);
        } else if (keyEvent.getKeyCode() == 27) {
            this.contactJList.requestFocus();
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void searchFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent.getOppositeComponent() != this.contactJList) {
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void contactJListFocusLost(FocusEvent focusEvent) {
        if (focusEvent.getOppositeComponent() != this.searchField) {
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void filterComboKeyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isActionKey() && ("" + keyEvent.getKeyChar()).trim().length() != 0 && keyEvent.getKeyChar() != '\uffff') {
            this.searchPanel.setVisible(true);
            this.searchField.requestFocus();
            this.searchField.setText("" + keyEvent.getKeyChar());
        }
    }
}

