/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private final File zipFile;
    private ZipOutputStream zipOutputStream;
    private int count;

    public Zipper(File file) throws FileNotFoundException {
        this.zipFile = file;
        this.count = 0;
        this.zipOutputStream = null;
    }

    private ZipOutputStream getZipOutputStream() throws FileNotFoundException {
        if (this.zipOutputStream == null) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFile));
        }
        return this.zipOutputStream;
    }

    public void add(File file, FileFilter fileFilter) throws IOException {
        this.add(file, fileFilter, null);
    }

    public void add(File file, FileFilter fileFilter, String string) throws IOException {
        byte[] byArray = new byte[32768];
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(fileFilter)) {
                this.addImpl(file2, byArray, string, fileFilter);
            }
        } else {
            this.addImpl(file, byArray, string, fileFilter);
        }
    }

    public void close() throws IOException {
        if (this.zipOutputStream != null) {
            this.zipOutputStream.close();
        }
    }

    public int getFileCount() {
        return this.count;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void addImpl(File file, byte[] byArray, String string, FileFilter fileFilter) throws IOException, FileNotFoundException {
        int n;
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(fileFilter)) {
                String string2 = Zipper.isEmpty(string) ? file.getName() : string + "/" + file.getName();
                this.addImpl(file2, byArray, string2, fileFilter);
            }
            return;
        }
        ++this.count;
        InputStream inputStream = this.getFileInputStream(file);
        String string3 = Zipper.isEmpty(string) ? file.getName() : string + '/' + file.getName();
        this.getZipOutputStream().putNextEntry(new ZipEntry(string3));
        while ((n = inputStream.read(byArray)) > 0) {
            this.getZipOutputStream().write(byArray, 0, n);
        }
        this.getZipOutputStream().closeEntry();
        inputStream.close();
    }

    protected InputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

