/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.remote.fs.ui.RemoteFileSystemNotifier;
import org.netbeans.modules.cnd.remote.server.RemoteServerListUI;
import org.netbeans.modules.cnd.remote.support.RemoteCodeModelUtils;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileSupport
implements RemoteFileSystemNotifier.Callback {
    private final PendingFilesQueue pendingFilesQueue = new PendingFilesQueue();
    private RemoteFileSystemNotifier notifier;
    private final ExecutionEnvironment execEnv;
    private int fileCopyCount;
    private int dirSyncCount;
    private final Object mainLock = new Object();
    private Map<File, Object> locks = new HashMap<File, Object>();
    private final Map<ExecutionEnvironment, Boolean> cancels = new HashMap<ExecutionEnvironment, Boolean>();
    public static final String FLAG_FILE_NAME = ".rfs";
    private static final String CC_STR = "cc";
    static final String POSTFIX = ".cnd.rfs.small";

    public RemoteFileSupport(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.resetStatistic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock(File file) {
        Object object = this.mainLock;
        synchronized (object) {
            Object object2 = this.locks.get(file);
            if (object2 == null) {
                object2 = new Object();
                this.locks.put(file, object2);
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLock(File file) {
        Object object = this.mainLock;
        synchronized (object) {
            this.locks.remove(file);
        }
    }

    static String fixCaseSensitivePathIfNeeded(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf(CC_STR);
        if (n >= 0 && stringBuilder.length() >= CC_STR.length()) {
            if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
                return stringBuilder.toString();
            }
            int n2 = n + CC_STR.length();
            if (stringBuilder.length() > n2 && stringBuilder.charAt(n2) != '/') {
                return stringBuilder.toString();
            }
            if (n2 == stringBuilder.length()) {
                stringBuilder.append(POSTFIX);
            } else {
                stringBuilder.insert(n2, POSTFIX);
            }
        }
        return stringBuilder.toString();
    }

    static String fromFixedCaseSensitivePathIfNeeded(String string) {
        return string.replaceAll(POSTFIX, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFileSync(File file, String string) throws IOException, InterruptedException, ExecutionException {
        if (!file.exists() || file.length() == 0L) {
            Object object = this.getLock(file);
            synchronized (object) {
                if (!file.exists() || file.length() == 0L) {
                    this.syncFile(file, RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(string));
                    this.removeLock(file);
                }
            }
        }
    }

    private void syncFile(File file, String string) throws IOException, InterruptedException, ExecutionException, CancellationException {
        block4: {
            CndUtils.assertTrue((!file.exists() || file.isFile() ? 1 : 0) != 0, (String)("not a file " + file.getAbsolutePath()));
            this.checkConnection(file, string, false);
            Future future = CommonTasksSupport.downloadFile((String)string, (ExecutionEnvironment)this.execEnv, (String)file.getAbsolutePath(), null);
            try {
                int n = (Integer)future.get();
                if (n == 0) {
                    ++this.fileCopyCount;
                    break block4;
                }
                throw new IOException("Can't copy file " + file.getAbsolutePath() + " from " + this.execEnv + ':' + string + ": rc=" + n);
            }
            catch (InterruptedException interruptedException) {
                this.truncate(file);
                throw interruptedException;
            }
            catch (ExecutionException executionException) {
                this.truncate(file);
                throw executionException;
            }
        }
    }

    private void truncate(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureDirSync(File file, String string) throws IOException, CancellationException {
        if (!file.exists() || !new File(file, FLAG_FILE_NAME).exists()) {
            Object object = this.getLock(file);
            synchronized (object) {
                if (!file.exists() || !new File(file, FLAG_FILE_NAME).exists()) {
                    this.syncDirStruct(file, RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(string));
                    this.removeLock(file);
                }
            }
        }
    }

    private void syncDirStruct(File file, String string) throws IOException, CancellationException {
        String string2;
        if (file.exists()) {
            CndUtils.assertTrue((boolean)file.isDirectory(), (String)(file.getAbsolutePath() + " is not a directory"));
        }
        this.checkConnection(file, string, true);
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
        nativeProcessBuilder.setCommandLine("sh -c 'test -d " + string + " && cd " + string + " && for D in `ls`; do if [ -d $D ]; then echo D $D; else echo F $D; fi; done'");
        NativeProcess nativeProcess = nativeProcessBuilder.call();
        InputStream inputStream = nativeProcess.getInputStream();
        InputStream inputStream2 = nativeProcess.getErrorStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
        RemoteUtil.LOGGER.finest("Synchronizing dir " + file.getAbsolutePath() + " with " + this.execEnv + ':' + string);
        while ((string2 = bufferedReader2.readLine()) != null) {
            RemoteUtil.LOGGER.finest("Error [" + string2 + "]\n\ton Synchronizing dir " + file.getAbsolutePath() + " with " + this.execEnv + ':' + string);
        }
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!bl) {
                bl = true;
                if (!file.mkdirs() && !file.exists()) {
                    throw new IOException("Can not create directory " + file.getAbsolutePath());
                }
            }
            CndUtils.assertTrueInConsole((string2.length() > 2 ? 1 : 0) != 0, (String)("unexpected file information " + string2));
            boolean bl2 = string2.charAt(0) == 'D';
            String string3 = string2.substring(2);
            if (bl2) {
                string3 = RemoteFileSupport.fixCaseSensitivePathIfNeeded(string3);
            }
            File file2 = new File(file, string3);
            try {
                RemoteUtil.LOGGER.finest("\tcreating " + string3);
                if (bl2) {
                    if (file2.mkdirs() || file2.exists()) continue;
                    throw new IOException("can't create directory " + file2.getAbsolutePath());
                }
                file2.createNewFile();
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.warning("Error creating " + (bl2 ? "directory" : "file") + ' ' + file2.getAbsolutePath() + ": " + iOException.getMessage());
                throw iOException;
            }
        }
        bufferedReader.close();
        bufferedReader2.close();
        inputStream.close();
        inputStream2.close();
        if (bl) {
            File file3 = new File(file, FLAG_FILE_NAME);
            RemoteUtil.LOGGER.finest("Creating Flag file " + file3.getAbsolutePath());
            try {
                file3.createNewFile();
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.finest("FAILED creating Flag file " + file3.getAbsolutePath());
                throw iOException;
            }
            ++this.dirSyncCount;
        }
    }

    void resetStatistic() {
        this.dirSyncCount = 0;
        this.fileCopyCount = 0;
    }

    int getDirSyncCount() {
        return this.dirSyncCount;
    }

    int getFileCopyCount() {
        return this.fileCopyCount;
    }

    private void checkConnection(File file, String string, boolean bl) throws IOException, CancellationException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            RemoteUtil.LOGGER.finest("Adding notification for " + this.execEnv + ":" + string);
            this.pendingFilesQueue.add(file, string, bl);
            this.getNotifier().showIfNeed();
            throw new CancellationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileSystemNotifier getNotifier() {
        RemoteFileSupport remoteFileSupport = this;
        synchronized (remoteFileSupport) {
            if (this.notifier == null) {
                this.notifier = new RemoteFileSystemNotifier(this.execEnv, this);
            }
            return this.notifier;
        }
    }

    @Override
    public List<String> getPendingFiles() {
        return this.pendingFilesQueue.getPendingFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"Progress_Title", (Object)RemoteFileSystemNotifier.getDisplayName(this.execEnv)));
        progressHandle.start();
        RemoteServerListUI.revalidate(this.execEnv);
        progressHandle.switchToDeterminate(this.pendingFilesQueue.size());
        int n = 0;
        try {
            PendingFile pendingFile;
            while ((pendingFile = this.pendingFilesQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                try {
                    if (pendingFile.isDirectory) {
                        this.ensureDirSync(pendingFile.localFile, pendingFile.remotePath);
                    } else {
                        this.ensureFileSync(pendingFile.localFile, pendingFile.remotePath);
                    }
                    progressHandle.progress(NbBundle.getMessage(this.getClass(), (String)"Progress_Message", (Object)pendingFile.remotePath), n++);
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            progressHandle.finish();
            RemoteCodeModelUtils.scheduleReparse(this.execEnv);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingFilesQueue {
        private final BlockingQueue<PendingFile> queue = new LinkedBlockingQueue<PendingFile>();
        private final Set<String> remoteAbsPaths = new TreeSet<String>();

        private PendingFilesQueue() {
        }

        public synchronized void add(File file, String string, boolean bl) {
            if (this.remoteAbsPaths.add(string)) {
                this.queue.add(new PendingFile(file, string, bl));
            }
        }

        public synchronized PendingFile take() throws InterruptedException {
            PendingFile pendingFile = this.queue.take();
            this.remoteAbsPaths.remove(pendingFile.remotePath);
            return pendingFile;
        }

        public synchronized PendingFile poll(long l, TimeUnit timeUnit) throws InterruptedException {
            PendingFile pendingFile = this.queue.poll(l, timeUnit);
            if (pendingFile != null) {
                this.remoteAbsPaths.remove(pendingFile.remotePath);
            }
            return pendingFile;
        }

        public synchronized List<String> getPendingFiles() {
            return Collections.unmodifiableList(new ArrayList<String>(this.remoteAbsPaths));
        }

        public int size() {
            return this.remoteAbsPaths.size();
        }
    }

    private static class PendingFile {
        public final File localFile;
        public final String remotePath;
        private final boolean isDirectory;

        public PendingFile(File file, String string, boolean bl) {
            this.localFile = file;
            this.remotePath = string;
            this.isDirectory = bl;
        }
    }
}

