/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystem;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileObjectBase
extends FileObject {
    protected final RemoteFileSystem fileSystem;
    protected final ExecutionEnvironment execEnv;
    protected final String remotePath;
    protected final File cache;
    private volatile EventListenerList eventSupport;
    protected final String nameExt;

    public RemoteFileObjectBase(RemoteFileSystem remoteFileSystem, ExecutionEnvironment executionEnvironment, String string, File file) {
        CndUtils.assertTrue((boolean)executionEnvironment.isRemote());
        CndUtils.assertTrue((boolean)file.exists());
        this.fileSystem = remoteFileSystem;
        this.execEnv = executionEnvironment;
        this.remotePath = RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(string);
        this.cache = file;
        int n = this.remotePath.lastIndexOf(47);
        this.nameExt = n < 0 ? "" : this.remotePath.substring(n + 1);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    private synchronized EventListenerList getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new EventListenerList();
        }
        return this.eventSupport;
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().add(FileChangeListener.class, fileChangeListener);
    }

    public FileObject createData(String string, String string2) throws IOException {
        throw new ReadOnlyException();
    }

    public FileObject createFolder(String string) throws IOException {
        throw new ReadOnlyException();
    }

    public void delete(FileLock fileLock) throws IOException {
        throw new ReadOnlyException();
    }

    public Object getAttribute(String string) {
        if (string.equals("java.io.File")) {
            return this.cache;
        }
        return null;
    }

    public Enumeration<String> getAttributes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getExt() {
        int n = this.nameExt.lastIndexOf(46);
        return n < 0 ? "" : this.nameExt.substring(n + 1);
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        return this.fileSystem;
    }

    protected RemoteFileSupport getRemoteFileSupport() {
        return this.fileSystem.getRemoteFileSupport();
    }

    public String getName() {
        int n = this.nameExt.lastIndexOf(46);
        return n < 0 ? this.nameExt : this.nameExt.substring(0, n);
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new ReadOnlyException();
    }

    public abstract FileObject getFileObject(String var1);

    public FileObject getParent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isVirtual() {
        return !this.cache.exists();
    }

    public Date lastModified() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FileLock lock() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().remove(FileChangeListener.class, fileChangeListener);
    }

    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        throw new ReadOnlyException();
    }

    public void setAttribute(String string, Object object) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setImportant(boolean bl) {
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

