/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.catalog.Catalog;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogModel;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogModelFactory;
import org.netbeans.modules.websvc.jaxws.catalog.System;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class CatalogUtils {
    public static void copyCatalogEntriesForAllClients(FileObject fileObject, FileObject fileObject2, JaxWsModel jaxWsModel) throws IOException {
        CatalogModel catalogModel = CatalogUtils.getCatalogModel(fileObject);
        CatalogModel catalogModel2 = CatalogUtils.getCatalogModel(fileObject2);
        Catalog catalog = catalogModel.getRootComponent();
        Catalog catalog2 = catalogModel2.getRootComponent();
        List<System> list = catalog.getSystems();
        catalogModel2.startTransaction();
        for (Client client : jaxWsModel.getClients()) {
            String string = client.getName();
            for (System system : list) {
                int n;
                String string2 = system.getURIAttr();
                String string3 = "xml-resources/web-service-references/" + string + "/wsdl/";
                if (string2 == null || (n = string2.indexOf(string3)) < 0) continue;
                System system2 = catalogModel2.getFactory().createSystem();
                try {
                    system2.setSystemIDAttr(new URI(system.getSystemIDAttr()));
                    system2.setURIAttr(new URI(string2.substring(n + string3.length() - 5)));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                catalog2.addSystem(system2);
            }
        }
        catalogModel2.endTransaction();
    }

    public static void copyCatalogEntriesForClient(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        CatalogModel catalogModel = CatalogUtils.getCatalogModel(fileObject);
        CatalogModel catalogModel2 = CatalogUtils.getCatalogModel(fileObject2);
        Catalog catalog = catalogModel.getRootComponent();
        List<System> list = catalog.getSystems();
        if (list.size() > 0) {
            Catalog catalog2 = catalogModel2.getRootComponent();
            catalogModel2.startTransaction();
            for (System system : list) {
                int n;
                String string2 = system.getURIAttr();
                String string3 = "xml-resources/web-service-references/" + string + "/wsdl/";
                if (string2 == null || (n = string2.indexOf(string3)) < 0) continue;
                System system2 = null;
                String string4 = system.getSystemIDAttr();
                if (string4 != null) {
                    for (System system3 : catalog2.getSystems()) {
                        if (!string4.equals(system3.getSystemIDAttr())) continue;
                        system2 = system3;
                        break;
                    }
                }
                if (system2 == null) {
                    system2 = catalogModel2.getFactory().createSystem();
                    catalog2.addSystem(system2);
                }
                try {
                    system2.setSystemIDAttr(new URI(system.getSystemIDAttr()));
                    system2.setURIAttr(new URI(string2.substring(n + string3.length() - 5)));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            }
            catalogModel2.endTransaction();
        }
    }

    public static void updateCatalogEntriesForClient(FileObject fileObject, String string) throws IOException {
        CatalogModel catalogModel = CatalogUtils.getCatalogModel(fileObject);
        Catalog catalog = catalogModel.getRootComponent();
        String string2 = "xml-resources/web-service-references/" + string + "/wsdl/";
        catalogModel.startTransaction();
        for (System system : catalog.getSystems()) {
            String string3 = system.getURIAttr();
            int n = string3.indexOf(string2);
            if (n < 0) continue;
            try {
                system.setURIAttr(new URI(string3.substring(n + string2.length() - 5)));
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        catalogModel.endTransaction();
    }

    public static CatalogModel getCatalogModel(FileObject fileObject) throws IOException {
        ModelSource modelSource = CatalogUtils.createModelSource(fileObject, true);
        return CatalogModelFactory.getInstance().getModel(modelSource);
    }

    private static ModelSource createModelSource(final FileObject fileObject, boolean bl) throws IOException {
        assert (fileObject != null) : "Null file object.";
        try {
            final DataObject dataObject = DataObject.find((FileObject)fileObject);
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                Lookup lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

                    public Lookup getLookup() {
                        try {
                            return Lookups.fixed((Object[])new Object[]{editorCookie.openDocument(), dataObject, fileObject});
                        }
                        catch (IOException iOException) {
                            return Lookups.fixed((Object[])new Object[]{dataObject, fileObject});
                        }
                    }
                });
                return new ModelSource(lookup, bl);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
        }
        return null;
    }
}

