/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.WebServicePersistenceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModelEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceListModelListener;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceListModel {
    public static final String DEFAULT_GROUP = "default";
    private static Random serviceRandom = new Random(System.currentTimeMillis());
    private static Random serviceGroupRandom = new Random(System.currentTimeMillis());
    public boolean isDirty = false;
    Set<WebServiceListModelListener> listeners = new HashSet<WebServiceListModelListener>();
    private List<WebServiceData> webServices = Collections.synchronizedList(new ArrayList());
    private List<WebServiceGroup> webServiceGroups = Collections.synchronizedList(new ArrayList());
    private Set uniqueDisplayNames = Collections.synchronizedSet(new HashSet());
    private List<String> partnerServices = new ArrayList<String>();
    private static WebServiceListModel websvcNodeModel = new WebServiceListModel();
    private boolean initialized = false;
    private RestFolderListener partnerServiceListener;
    private List<WebServiceGroupListener> defaultGroupListeners = new ArrayList<WebServiceGroupListener>();

    private WebServiceListModel() {
    }

    public static WebServiceListModel getInstance() {
        return websvcNodeModel;
    }

    public static void resetInstance() {
        websvcNodeModel = new WebServiceListModel();
    }

    public void addWebServiceListModelListener(WebServiceListModelListener webServiceListModelListener) {
        this.listeners.add(webServiceListModelListener);
    }

    public void removeWebServiceListModelListener(WebServiceListModelListener webServiceListModelListener) {
        this.listeners.remove(webServiceListModelListener);
    }

    public List<String> getPartnerServices() {
        return this.partnerServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsKey(List list, String string) {
        List list2 = list;
        synchronized (list2) {
            for (Object e : list) {
                Object object;
                if (e instanceof WebServiceData) {
                    object = (WebServiceData)e;
                    if (!((WebServiceData)object).getId().equals(string)) continue;
                    return true;
                }
                if (!(e instanceof WebServiceGroup) || !((WebServiceGroup)(object = (WebServiceGroup)e)).getId().equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    public String getUniqueWebServiceId() {
        this.initialize();
        String string = "webservice" + serviceRandom.nextLong();
        while (WebServiceListModel.containsKey(this.webServices, string)) {
            string = "webservice" + serviceRandom.nextLong();
        }
        return string;
    }

    public String getUniqueWebServiceGroupId() {
        this.initialize();
        String string = "webserviceGroup" + serviceGroupRandom.nextLong();
        while (WebServiceListModel.containsKey(this.webServiceGroups, string)) {
            string = "webserviceGroup" + serviceGroupRandom.nextLong();
        }
        return string;
    }

    public void addWebService(WebServiceData webServiceData) {
        this.initialize();
        if (!this.webServices.contains(webServiceData)) {
            WebServiceListModel.getInstance().setDirty(true);
            this.webServices.add(webServiceData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceData getWebService(String string) {
        List<WebServiceData> list = this.webServices;
        synchronized (list) {
            this.initialize();
            for (WebServiceData webServiceData : this.webServices) {
                if (!webServiceData.getId().equals(string)) continue;
                return webServiceData;
            }
        }
        return null;
    }

    public void removeWebService(String string) {
        this.initialize();
        WebServiceData webServiceData = this.getWebService(string);
        if (webServiceData == null) {
            return;
        }
        WebServiceGroup webServiceGroup = this.getWebServiceGroup(webServiceData.getGroupId());
        WebServiceListModel.getInstance().setDirty(true);
        if (webServiceGroup != null) {
            webServiceGroup.remove(string);
        }
        this.webServices.remove(webServiceData);
    }

    public boolean webServiceExists(WebServiceData webServiceData) {
        this.initialize();
        return WebServiceListModel.containsKey(this.webServices, webServiceData.getId());
    }

    public String getUniqueDisplayName(String string) {
        this.initialize();
        String string2 = string;
        int n = 1;
        while (this.uniqueDisplayNames.contains(string2)) {
            string2 = string + Integer.toString(n);
            ++n;
        }
        return string2;
    }

    public boolean isDisplayNameUnique(String string) {
        return !this.uniqueDisplayNames.contains(string);
    }

    public List<WebServiceData> getWebServiceSet() {
        this.initialize();
        return this.webServices;
    }

    public void addWebServiceGroup(WebServiceGroup webServiceGroup) {
        this.initialize();
        if (!this.webServiceGroups.contains(webServiceGroup)) {
            WebServiceListModel.getInstance().setDirty(true);
            this.webServiceGroups.add(webServiceGroup);
            for (WebServiceListModelListener webServiceListModelListener : this.listeners) {
                WebServiceListModelEvent webServiceListModelEvent = new WebServiceListModelEvent(webServiceGroup.getId());
                webServiceListModelListener.webServiceGroupAdded(webServiceListModelEvent);
            }
        }
    }

    public void removeWebServiceGroup(String string) {
        this.initialize();
        WebServiceGroup webServiceGroup = this.getWebServiceGroup(string);
        if (webServiceGroup != null) {
            WebServiceListModel.getInstance().setDirty(true);
            String[] stringArray = this.getWebServiceGroup(string).getWebServiceIds().toArray(new String[0]);
            for (int i = 0; null != stringArray && i < stringArray.length; ++i) {
                WebServiceManager.getInstance().removeWebService(this.getWebService(stringArray[i]));
            }
            this.webServiceGroups.remove(webServiceGroup);
            Iterator<WebServiceListModelListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WebServiceListModelEvent webServiceListModelEvent = new WebServiceListModelEvent(string);
                iterator.next().webServiceGroupRemoved(webServiceListModelEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceGroup getWebServiceGroup(String string) {
        List<WebServiceGroup> list = this.webServiceGroups;
        synchronized (list) {
            this.initialize();
            for (WebServiceGroup webServiceGroup : this.webServiceGroups) {
                if (!webServiceGroup.getId().equals(string)) continue;
                return webServiceGroup;
            }
        }
        return null;
    }

    public WebServiceData findWebServiceData(String string, String string2) {
        return this.findWebServiceData(string, string2, true);
    }

    public WebServiceData findWebServiceData(String string, String string2, boolean bl) {
        for (WebServiceData webServiceData : this.getWebServiceSet()) {
            if (!string.equals(webServiceData.getOriginalWsdl())) continue;
            return webServiceData;
        }
        return null;
    }

    public WebServiceData getWebServiceData(String string, String string2) {
        return this.getWebServiceData(string, string2, true);
    }

    public WebServiceData getWebServiceData(String string, String string2, boolean bl) {
        final WebServiceData webServiceData = this.findWebServiceData(string, string2, false);
        if (webServiceData != null && !webServiceData.isReady()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        WebServiceManager.getInstance().addWebService(webServiceData, true);
                    }
                    catch (IOException iOException) {
                        Logger.global.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            };
            RequestProcessor.Task task = RequestProcessor.getDefault().post(runnable);
            if (bl) {
                task.waitFinished();
            }
        }
        return webServiceData;
    }

    public List<WebServiceGroup> getWebServiceGroupSet() {
        this.initialize();
        return this.webServiceGroups;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            WebServicePersistenceManager webServicePersistenceManager = new WebServicePersistenceManager();
            if (!WsdlUtil.hasProcessedImport()) {
                webServicePersistenceManager.setImported(false);
                webServicePersistenceManager.load();
                WsdlUtil.markImportProcessed();
            } else {
                webServicePersistenceManager.load();
            }
            this.partnerServiceListener = new RestFolderListener();
            FileObject fileObject = FileUtil.getConfigFile((String)"RestComponents");
            if (fileObject != null) {
                fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.partnerServiceListener), (Object)fileObject));
            }
            for (WebServiceGroup object : this.webServiceGroups) {
                if (!object.getId().equals(DEFAULT_GROUP)) continue;
                for (WebServiceGroupListener webServiceGroupListener : this.defaultGroupListeners) {
                    object.addWebServiceGroupListener(webServiceGroupListener);
                }
                this.defaultGroupListeners = null;
                return;
            }
            WebServiceGroup webServiceGroup = new WebServiceGroup(DEFAULT_GROUP);
            this.webServiceGroups.add(webServiceGroup);
            for (WebServiceGroupListener webServiceGroupListener : this.defaultGroupListeners) {
                webServiceGroup.addWebServiceGroupListener(webServiceGroupListener);
            }
            this.defaultGroupListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultGroupListener(WebServiceGroupListener webServiceGroupListener) {
        List<WebServiceGroup> list = this.webServiceGroups;
        synchronized (list) {
            for (WebServiceGroup webServiceGroup : this.webServiceGroups) {
                if (!webServiceGroup.getId().equals(DEFAULT_GROUP)) continue;
                webServiceGroup.addWebServiceGroupListener(webServiceGroupListener);
                return;
            }
            if (!this.defaultGroupListeners.contains(webServiceGroupListener)) {
                this.defaultGroupListeners.add(webServiceGroupListener);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static final class RestFolderListener
    implements FileChangeListener {
        private RestFolderListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

