/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class SourceUtils {
    private SourceUtils() {
    }

    public static TypeElement getPublicTopLevelElement(CompilationController compilationController) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        FileObject fileObject = compilationController.getFileObject();
        if (fileObject == null) {
            throw new IllegalStateException();
        }
        String string = fileObject.getName();
        List list = compilationController.getTopLevelElements();
        if (list != null) {
            for (TypeElement typeElement : list) {
                if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC) || !typeElement.getSimpleName().contentEquals(string)) continue;
                return typeElement;
            }
        }
        return null;
    }

    public static ClassTree getPublicTopLevelTree(CompilationController compilationController) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement(compilationController);
        if (typeElement != null) {
            return compilationController.getTrees().getTree(typeElement);
        }
        return null;
    }

    public static boolean isSubtype(CompilationController compilationController, TypeElement typeElement, String string) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        Parameters.notNull((CharSequence)"subtype", (Object)typeElement);
        Parameters.notNull((CharSequence)"supertype", (Object)string);
        TypeMirror typeMirror = compilationController.getTreeUtilities().parseType(string, typeElement);
        if (typeMirror != null) {
            return compilationController.getTypes().isSubtype(typeElement.asType(), typeMirror);
        }
        return false;
    }

    static TypeElement classTree2TypeElement(CompilationController compilationController, ClassTree classTree) {
        assert (compilationController != null);
        assert (classTree != null);
        TreePath treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), classTree);
        return (TypeElement)compilationController.getTrees().getElement(treePath);
    }

    static ExecutableElement getNoArgConstructor(CompilationController compilationController, TypeElement typeElement) {
        assert (compilationController != null);
        assert (typeElement != null);
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (executableElement = (ExecutableElement)element).getParameters().size() != 0 || compilationController.getElementUtilities().isSynthetic((Element)executableElement)) continue;
            return executableElement;
        }
        return null;
    }
}

