/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.RestServiceNode;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RestServicesChildren
extends Children.Keys {
    private Project project;
    private RestServicesListener listener;
    private RequestProcessor.Task updateNodeTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            RestServicesChildren.this.updateKeys();
        }
    });

    public RestServicesChildren(Project project) {
        this.project = project;
    }

    private RestServicesModel getModel() {
        RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            return restSupport.getRestServicesModel();
        }
        return null;
    }

    protected void addNotify() {
        super.addNotify();
        this.listener = new RestServicesListener();
        try {
            RestServicesModel restServicesModel = this.getModel();
            assert (restServicesModel != null) : "null model";
            if (restServicesModel != null) {
                restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                        restServicesMetadata.getRoot().addPropertyChangeListener((PropertyChangeListener)RestServicesChildren.this.listener);
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.updateKeys();
    }

    protected void removeNotify() {
        try {
            RestServicesModel restServicesModel = this.getModel();
            assert (restServicesModel != null) : "null model";
            if (restServicesModel != null) {
                restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                        restServicesMetadata.getRoot().removePropertyChangeListener((PropertyChangeListener)RestServicesChildren.this.listener);
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.setKeys(Collections.EMPTY_SET);
    }

    private void updateKeys() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            RestServicesModel restServicesModel = this.getModel();
            assert (restServicesModel != null) : "null model";
            if (restServicesModel != null) {
                restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                        RestServices restServices = restServicesMetadata.getRoot();
                        for (RestServiceDescription restServiceDescription : restServices.getRestServiceDescription()) {
                            arrayList.add(RestServiceNode.getKey(restServiceDescription));
                        }
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.setKeys(Utils.sortKeys(arrayList));
    }

    protected Node[] createNodes(final Object object) {
        try {
            final RestServicesModel restServicesModel = this.getModel();
            assert (restServicesModel != null) : "null model";
            if (restServicesModel != null) {
                Node[] nodeArray = (Node[])restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Node[]>(){

                    public Node[] run(RestServicesMetadata restServicesMetadata) throws IOException {
                        RestServices restServices = restServicesMetadata.getRoot();
                        for (RestServiceDescription restServiceDescription : restServices.getRestServiceDescription()) {
                            if (!RestServiceNode.getKey(restServiceDescription).equals(object)) continue;
                            return new Node[]{new RestServiceNode(RestServicesChildren.this.project, restServicesModel, restServiceDescription)};
                        }
                        return new Node[0];
                    }
                });
                return nodeArray;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new Node[0];
    }

    class RestServicesListener
    implements PropertyChangeListener {
        RestServicesListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RestServicesChildren.this.updateNodeTask.schedule(0);
        }
    }
}

