/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStubsGenerator
extends AbstractGenerator {
    public static final String REST = "rest";
    public static final String RJS = "rjs";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String TXT = "txt";
    public static final String JSON = "json";
    public static final String GIF = "gif";
    public static final String IMAGES = "images";
    public static final String BUNDLE = "Bundle";
    public static final String PROPERTIES = "properties";
    public static final String JS_SUPPORT = "Support";
    public static final String JS_TESTSTUBS = "TestStubs";
    public static final String JS_README = "Readme";
    public static final String JS_TESTSTUBS_TEMPLATE = "Templates/WebServices/JsTestStubs.html";
    public static final String JS_STUBSUPPORT_TEMPLATE = "Templates/WebServices/JsStubSupport.js";
    public static final String JS_PROJECTSTUB_TEMPLATE = "Templates/WebServices/JsProjectStub.js";
    public static final String JS_CONTAINERSTUB_TEMPLATE = "Templates/WebServices/JsContainerStub.js";
    public static final String JS_CONTAINERITEMSTUB_TEMPLATE = "Templates/WebServices/JsContainerItemStub.js";
    public static final String JS_GENERICSTUB_TEMPLATE = "Templates/WebServices/JsGenericStub.js";
    public static final String JS_README_TEMPLATE = "Templates/WebServices/JsReadme.html";
    public static final String PROXY = "RestProxyServlet";
    public static final String PROXY_URL = "/restproxy";
    public static final String PROXY_TEMPLATE = "Templates/WebServices/RestProxyServlet.txt";
    public static final String TTL_DojoResources_Stubs = "TTL_DojoResources_Stubs";
    public static final String MSG_Readme = "MSG_Readme";
    public static final String MSG_TestPage = "MSG_TestPage";
    public static final String TTL_RestClient_Stubs = "TTL_RestClient_Stubs";
    public static final String TTL_JMakiWidget_Stubs = "TTL_JMakiWidget_Stubs";
    public static final String MSG_SelectResource = "MSG_SelectResource";
    public static final String MSG_JS_Readme_Content = "MSG_JS_Readme_Content";
    public static final String MSG_JMaki_Readme_Content = "MSG_JMaki_Readme_Content";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    public static final String DEFAULT_BASE_URL = "http://localhost:8080";
    public static final String BASE_URL_TOKEN = "__BASE_URL__";
    public static final String FILE_ENCODING_TOKEN = "__FILE_ENCODING__";
    private FileObject stubFolder;
    private Project p;
    private boolean overwrite;
    private String projectName;
    private ClientStubModel.ResourceModel model;
    private FileObject rjsDir;
    private FileObject wadl;
    private String folderName;
    private String baseUrl;
    private String proxyUrl;
    private Charset baseEncoding;
    private FileObject rootFolder;

    public ClientStubsGenerator(FileObject fileObject, String string, Project project, boolean bl) throws IOException {
        assert (project != null);
        this.rootFolder = fileObject;
        this.folderName = string;
        this.p = project;
        this.overwrite = bl;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
    }

    public ClientStubsGenerator(FileObject fileObject, String string, FileObject fileObject2, boolean bl) throws IOException {
        this.rootFolder = fileObject;
        this.folderName = string;
        this.wadl = fileObject2;
        this.overwrite = bl;
        this.projectName = "NewProject";
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public FileObject getStubFolder() {
        if (this.stubFolder == null) {
            try {
                this.stubFolder = this.createFolder(this.getRootFolder(), this.getFolderName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.stubFolder;
    }

    public void setStubFolder(FileObject fileObject) {
        this.stubFolder = fileObject;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ClientStubModel.ResourceModel getModel() {
        return this.model;
    }

    public String getDefaultBaseUrl() {
        return "http://localhost:8080/";
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String string) {
        this.proxyUrl = string;
    }

    public Charset getBaseEncoding() {
        return this.baseEncoding;
    }

    private String getApplicationNameFromUrl(String string) {
        String[] stringArray;
        String string2 = string.replaceAll("http://", "");
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((stringArray = string2.split("/")) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || !string3.startsWith(DEFAULT_HOST) || i + 1 >= stringArray.length || stringArray[i + 1] == null || stringArray[i + 1].trim().length() <= 0) continue;
                return ClientStubModel.normalizeName(stringArray[i + 1]);
            }
        }
        return ClientStubModel.normalizeName(string2);
    }

    private String findBaseUrl(Project project) {
        String string = null;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            String string2 = j2eeModuleProvider.getServerInstanceID();
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string2);
            if (serverInstance != null) {
                try {
                    ServerInstance.Descriptor descriptor = serverInstance.getDescriptor();
                    string = descriptor.getHttpPort() == 80 ? descriptor.getHostname() : descriptor.getHostname() + ":" + descriptor.getHttpPort();
                    string = "http://" + string;
                }
                catch (InstanceRemovedException instanceRemovedException) {
                    string = null;
                }
            }
        }
        return string;
    }

    private String findAppContext(Project project) {
        String string = WebModule.getWebModule((FileObject)project.getProjectDirectory()).getContextPath();
        string = string != null ? string.substring(1) : ProjectUtils.getInformation((Project)project).getName();
        return string;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        ResourceJavaScript resourceJavaScript;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle, false);
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.getRootFolder());
        if (this.p != null) {
            this.model = new ClientStubModel().createModel(this.p);
            this.model.build();
            object4 = this.findBaseUrl(this.p);
            if (object4 == null) {
                object4 = this.getDefaultBaseUrl();
            }
            if ((object3 = this.findBaseUrl(project)) == null) {
                object3 = object4;
            }
            object2 = (RestSupport)this.p.getLookup().lookup(RestSupport.class);
            object = object2.getApplicationPath();
            this.setBaseUrl((String)(((String)object4).endsWith("/") ? object4 : (String)object4 + "/") + this.findAppContext(this.getProject()) + (String)(((String)object).startsWith("/") ? object : "/" + (String)object));
            this.setProxyUrl((String)(((String)object3).endsWith("/") ? object3 : (String)object3 + "/") + this.findAppContext(project) + PROXY_URL);
        } else if (this.wadl != null) {
            this.model = new ClientStubModel().createModel(this.wadl);
            this.model.build();
            object4 = ((ClientStubModel.WadlModeler)this.model).getBaseUrl();
            if (object4 == null) {
                object4 = this.getDefaultBaseUrl();
            }
            this.setBaseUrl((String)object4);
            this.setProxyUrl((String)object4 + ".." + PROXY_URL);
            this.projectName = this.getApplicationNameFromUrl((String)object4);
        }
        object4 = this.getModel().getResources();
        this.rjsDir = this.getStubFolder();
        this.initJs(this.p);
        object3 = this.createFolder(this.rjsDir, this.getProjectName().toLowerCase());
        this.createDataObjectFromTemplate(JS_PROJECTSTUB_TEMPLATE, (FileObject)object3, this.getProjectName(), JS, this.canOverwrite());
        this.updateProjectStub(object3.getFileObject(this.getProjectName(), JS), this.getProjectName(), "");
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (ClientStubModel.Resource)object2.next();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingClass", (Object)((ClientStubModel.Resource)object).getName(), (Object)JS));
            }
            resourceJavaScript = null;
            ClientStubModel.RepresentationNode representationNode = ((ClientStubModel.Resource)object).getRepresentation().getRoot();
            resourceJavaScript = ((ClientStubModel.Resource)object).isContainer() && representationNode != null && representationNode.getChildren().size() > 0 ? new ContainerJavaScript((ClientStubModel.Resource)object, (FileObject)object3) : (representationNode != null ? new ContainerItemJavaScript((ClientStubModel.Resource)object, (FileObject)object3) : new GenericResourceJavaScript((ClientStubModel.Resource)object, (FileObject)object3));
            resourceJavaScript.generate();
        }
        this.updateRestStub(this.rjsDir.getFileObject(JS_TESTSTUBS, HTML), (List<ClientStubModel.Resource>)object4, "");
        object2 = new HashSet();
        object = this.rjsDir.getFileObject(JS_TESTSTUBS, HTML);
        if (object != null) {
            object2.add(object);
        }
        if ((resourceJavaScript = this.rjsDir.getFileObject(JS_README, TXT)) != null) {
            object2.add(resourceJavaScript);
        }
        return object2;
    }

    protected FileObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, String string3, boolean bl) throws IOException {
        DataObject dataObject;
        FileObject fileObject2 = fileObject.getFileObject(string2, string3);
        if (fileObject2 != null) {
            if (bl) {
                dataObject = DataObject.find((FileObject)fileObject2);
                if (dataObject != null) {
                    dataObject.delete();
                }
            } else {
                return fileObject2;
            }
        }
        dataObject = RestUtils.createDataObjectFromTemplate(string, fileObject, string2);
        return dataObject.getPrimaryFile();
    }

    protected void copyDirectory(FileSystem fileSystem, final File file, final File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(fileSystem, new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            if (!file.exists()) {
                throw new IOException("File or directory does not exist.");
            }
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            });
        }
    }

    private void initJs(Project project) throws IOException {
        TokenReplacer tokenReplacer = new TokenReplacer();
        tokenReplacer.addToken(TTL_RestClient_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_RestClient_Stubs));
        tokenReplacer.addToken(MSG_Readme, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        tokenReplacer.addToken(MSG_TestPage, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        tokenReplacer.addToken(MSG_JS_Readme_Content, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_JS_Readme_Content));
        tokenReplacer.addToken(FILE_ENCODING_TOKEN, this.getBaseEncoding().name());
        FileObject fileObject = this.createDataObjectFromTemplate(JS_TESTSTUBS_TEMPLATE, this.rjsDir, JS_TESTSTUBS, HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        this.createDataObjectFromTemplate(JS_STUBSUPPORT_TEMPLATE, this.rjsDir, JS_SUPPORT, JS, false);
        fileObject = this.createDataObjectFromTemplate(JS_README_TEMPLATE, this.rjsDir, JS_README, HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        fileObject = this.createDataObjectFromTemplate(PROXY_TEMPLATE, this.rjsDir, PROXY, TXT, false);
        File file = new File(FileUtil.toFile((FileObject)this.rjsDir), CSS);
        file.mkdirs();
        this.copySupportFiles(file);
    }

    private void copySupportFiles(File file) throws IOException {
        String[] stringArray = new String[]{"clientstubs.css", "css_master-all.css", "images/background_border_bottom.gif", "images/pbsel.png", "images/bg_gradient.gif", "images/pname-clientstubs.png", "images/level1_selected-1lvl.jpg", "images/primary-enabled.gif", "images/masthead.png", "images/primary-roll.gif", "images/pbdis.png", "images/secondary-enabled.gif", "images/pbena.png", "images/tbsel.png", "images/pbmou.png", "images/tbuns.png"};
        File file2 = new File(file, IMAGES);
        file2.mkdirs();
        for (String string : stringArray) {
            RestSupport.copyFile((File)file, (String)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String string, File file) throws IOException {
        String string2 = "resources/" + string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = ClientStubsGenerator.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected FileObject createFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectStub(FileObject fileObject, String string, String string2) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            Object object;
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contains(BASE_URL_TOKEN)) {
                    stringBuffer.append(string3.replaceAll(BASE_URL_TOKEN, this.getBaseUrl()));
                } else if (string3.contains("__PROJECT_NAME__")) {
                    stringBuffer.append(string3.replaceAll("__PROJECT_NAME__", string));
                } else if (string3.contains("__PROJECT_INIT_BODY__")) {
                    object = "";
                    int n = 0;
                    List<ClientStubModel.Resource> list = this.getModel().getResources();
                    for (ClientStubModel.Resource resource : list) {
                        if (!resource.isContainer()) continue;
                        object = (String)object + "      this.resources[" + n++ + "] = new " + string2 + resource.getName() + "(this.uri+'" + resource.getPath() + "');\n";
                    }
                    stringBuffer.append((String)object);
                } else {
                    stringBuffer.append(string3);
                }
                stringBuffer.append("\n");
            }
            object = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.getBaseEncoding());
            try {
                ((Writer)object).write(stringBuffer.toString());
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRestStub(FileObject fileObject, List<ClientStubModel.Resource> list, String string) throws IOException {
        ClientStubModel.Resource resource2;
        String string2 = this.getProjectName();
        String string3 = string2.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + string2 + "." + JS + "'></script>\n");
        for (ClientStubModel.Resource resource2 : list) {
            stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + resource2.getName() + "." + JS + "'></script>\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n\t<!-- Using JavaScript files for project " + string2 + "-->\n");
        stringBuffer2.append("\t<script language='Javascript'>\n");
        stringBuffer2.append("\t\tvar str = '';\n");
        stringBuffer2.append("\t\t//Example test code for " + string2 + "\n");
        stringBuffer2.append("\t\tstr = '<h2>Resources for " + string2 + ":</h2><br><table border=\"1\">';\n");
        stringBuffer2.append("\t\tvar app = new " + string + string2 + "('" + this.getBaseUrl() + "');\n");
        stringBuffer2.append("\t\t//Uncomment below if using proxy for javascript cross-domain.\n");
        stringBuffer2.append("\t\t//app.setProxy(\"" + this.getProxyUrl() + "\");\n");
        stringBuffer2.append("\t\tvar resources = app.getResources();\n");
        stringBuffer2.append("\t\tfor(i=0;i<resources.length;i++) {\n");
        stringBuffer2.append("\t\t  var resource = resources[i];\n");
        stringBuffer2.append("\t\t  var uri = resource.getUri();\n");
        stringBuffer2.append("\t\t  str += '<tr><td valign=\"top\"><a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a></td><td>';\n");
        stringBuffer2.append("\t\t  var items  = resource.getItems();\n");
        stringBuffer2.append("\t\t  if(items != undefined && items.length > 0) {\n");
        stringBuffer2.append("\t\t    for(j=0;j<items.length;j++) {\n");
        stringBuffer2.append("\t\t        var item = items[j];\n");
        stringBuffer2.append("\t\t        var uri2 = item.getUri();\n");
        stringBuffer2.append("\t\t        str += '<a href=\"'+uri2+'\" target=\"_blank\">'+uri2+'</a><br/>';\n");
        stringBuffer2.append("\t\t        str += '&nbsp;&nbsp;<font size=\"-3\">'+item.toString()+'</font><br/>';\n");
        stringBuffer2.append("\t\t    }\n");
        stringBuffer2.append("\t\t  } else {\n");
        stringBuffer2.append("\t\t    str += 'No items, please check the url: <a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.';\n");
        stringBuffer2.append("\t\t  }\n");
        stringBuffer2.append("\t\t  str += '</td></tr>';\n");
        stringBuffer2.append("\t\t}\n");
        stringBuffer2.append("\t\tstr += '</table><br>';\n");
        stringBuffer2.append("\t\tvar n = document.getElementById('containerContent');\n");
        stringBuffer2.append("\t\tn.innerHTML = n.innerHTML + str;\n\n");
        stringBuffer2.append("\t</script>\n");
        resource2 = fileObject.lock();
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.contains("JS_DECLARE_END")) {
                    stringBuffer3.append(stringBuffer.toString());
                } else if (string4.contains("JS_USAGE_END")) {
                    stringBuffer3.append(stringBuffer2.toString());
                }
                stringBuffer3.append(string4);
                stringBuffer3.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream((FileLock)resource2), this.getBaseEncoding());
            try {
                outputStreamWriter.write(stringBuffer3.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            resource2.releaseLock();
        }
    }

    public class GenericResourceJavaScript
    extends ResourceJavaScript {
        public GenericResourceJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("__RESOURCE_NAME__", resource.getName());
            hashMap.put("__STUB_METHODS__", this.stubJSToken);
            this.setTokens(hashMap);
        }

        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_GENERICSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContainerItemJavaScript
    extends ResourceJavaScript {
        public ContainerItemJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (this.root != null) {
                String string = resource.getName();
                String string2 = this.root.getName();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("__GENERIC_NAME__", string);
                hashMap.put("__GENERIC_PATH_NAME__", string2);
                hashMap.put("__FIELDS_DEFINITION__", this.createFieldsDefinition(this.root, true));
                hashMap.put("__GETTER_SETTER_METHODS__", this.createGetterSetterMethods(this.root, true));
                hashMap.put("__FIELDS_INIT__", this.createFieldsInitBody(this.root, true, this.pkg));
                hashMap.put("__SUB_RESOURCE_NAME__", "");
                hashMap.put("__SUB_RESOURCE_PATH_NAME__", "");
                hashMap.put("__FIELDS_TOSTRING__", this.createFieldsToStringBody(this.root, true));
                hashMap.put("__FIELD_NAMES_TOSTRING__", this.createFieldNamesBody(this.root, true));
                hashMap.put("__STUB_METHODS__", this.stubJSToken.equals("") ? this.stubJSToken : "   ,\n" + this.stubJSToken);
                this.setTokens(hashMap);
            }
        }

        @Override
        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERITEMSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }

        private String createGetterSetterMethods(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getAttributes(), bl));
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getChildren(), bl));
            return stringBuffer.toString();
        }

        private String createGetterSetterMethods(List<ClientStubModel.RepresentationNode> list, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode : list) {
                String string = representationNode.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append(this.createGetterMethod(representationNode) + ",\n\n");
                stringBuffer.append(this.createSetterMethod(representationNode) + ",\n\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsDefinition(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("    this." + string + " = '';\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isContainer()) {
                    stringBuffer.append("    this." + string + " = new Array();\n");
                    continue;
                }
                stringBuffer.append("    this." + string + " = '';\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsInitBody(ClientStubModel.RepresentationNode representationNode, boolean bl, String string) {
            String string2;
            String string3 = representationNode.getName();
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string2 = representationNode2.getName();
                if (bl && string2.equals("uri")) continue;
                stringBuffer.append("         this." + string2 + " = " + string3 + "['@" + string2 + "'];\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string2 = representationNode2.getName();
                if (representationNode2.isRoot() || representationNode2.isReference()) {
                    String string4 = representationNode2.getId();
                    stringBuffer.append("         this." + string2 + " = new " + string + this.findResourceName(string2) + "(" + string3 + "['" + string4 + "']['@uri']);\n");
                    continue;
                }
                stringBuffer.append("         this." + string2 + " = this.findValue(this." + string2 + ", " + string3 + "['" + string2 + "']);\n");
            }
            return stringBuffer.toString();
        }

        private String pluralize(String string) {
            String string2 = Util.pluralize(string);
            if (string2.endsWith("ss")) {
                string2 = string2.substring(0, string2.length() - 2) + "Collection";
            }
            return string2;
        }

        private String createFieldsToStringBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         ', \"@" + string + "\":\"'+this." + string + "+'\"'+\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isRoot() || representationNode2.isReference()) {
                    stringBuffer.append("         ', \"" + string + "\":{\"@uri\":\"'+this." + string + ".getUri()+'\"}'+\n");
                    continue;
                }
                stringBuffer.append("         ', \"" + string + "\":\"'+this." + string + "+'\"'+\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldNamesBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isReference() || representationNode2.isRoot()) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            return stringBuffer.toString();
        }

        private String findResourceName(String string) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        private String createGetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = RestUtils.createGetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function() {\n" + "      if(!this.initialized)\n" + "         this.init();\n" + "      return this." + string2 + ";\n" + "   }";
        }

        private String createSetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = this.createSetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function(" + string2 + "_) {\n" + "      this." + string2 + " = " + string2 + "_;\n" + "   }";
        }

        private String createSetterMethodName(ClientStubModel.RepresentationNode representationNode) {
            String string = "set";
            if (representationNode.getLink() != null) {
                string = RestUtils.escapeJSReserved(representationNode.getLink().getName().toString());
                string = "set" + string.substring(3);
            } else {
                string = representationNode.getName();
                string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
            }
            return string;
        }
    }

    public class ContainerJavaScript
    extends ResourceJavaScript {
        public ContainerJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (this.root != null && this.root.getChildren().size() > 0) {
                String string = resource.getName();
                String string2 = this.root.getName();
                String string3 = this.root.getChildren().get(0).getName();
                String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("__CONTAINER_NAME__", string);
                hashMap.put("__CONTAINER_PATH_NAME__", string2);
                hashMap.put("__CONTAINER_ITEM_NAME__", string4);
                hashMap.put("__CONTAINER_ITEM_PATH_NAME__", string3);
                hashMap.put("__STUB_METHODS__", this.stubJSToken.equals("") ? this.stubJSToken : "   ,\n" + this.stubJSToken);
                hashMap.put("__PROJECT_NAME__", ClientStubsGenerator.this.getProjectName());
                this.setTokens(hashMap);
            }
        }

        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }
    }

    public abstract class ResourceJavaScript
    extends TokenReplacer {
        final String RJSSUPPORT = "rjsSupport";
        protected ClientStubModel.Resource r;
        protected FileObject jsFolder;
        protected ClientStubModel.RepresentationNode root;
        protected String pkg;
        protected String object;
        protected String stubJSToken;
        private Map<String, String> tokens;

        public ResourceJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            this.RJSSUPPORT = "rjsSupport";
            this.r = resource;
            this.jsFolder = fileObject;
            this.pkg = "";
            this.object = "";
            this.root = resource.getRepresentation().getRoot();
            this.stubJSToken = this.createStubJSMethods(resource, this.object, this.pkg);
        }

        public FileObject getFolder() {
            return this.jsFolder;
        }

        public abstract FileObject generate() throws IOException;

        protected String createStubJSMethods(ClientStubModel.Resource resource, String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.Method method : resource.getMethods()) {
                stringBuffer.append(this.createMethod(method, "rjsSupport.", string2) + ",\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createMethod(ClientStubModel.Method method, String string, String string2) {
            if (method.getType() == ClientStubModel.MethodType.GET) {
                return this.createGetMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.POST) {
                return this.createPostMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.PUT) {
                return this.createPutMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.DELETE) {
                return this.createDeleteMethod(method, string);
            }
            if (method instanceof ClientStubModel.NavigationMethod) {
                return this.createNavigationMethod((ClientStubModel.NavigationMethod)method, string2);
            }
            return "";
        }

        private String createMethodName(ClientStubModel.Method method, String string, int n) {
            if (n > 1) {
                for (Constants.MimeType mimeType : Constants.MimeType.values()) {
                    if (!mimeType.value().equals(string)) continue;
                    return method.getName() + mimeType.suffix();
                }
            }
            return method.getName();
        }

        private String createGetMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getResponse().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getResponse().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function() {\n" + "      return " + string + "get(this.uri, '" + string2 + "');\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPostMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "post(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPutMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "put(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createDeleteMethod(ClientStubModel.Method method, String string) {
            return "   " + RestUtils.escapeJSReserved(method.getName()) + " : function() {\n" + "      return " + string + "delete_(this.uri);\n" + "   }";
        }

        private String createNavigationMethod(ClientStubModel.NavigationMethod navigationMethod, String string) {
            String string2 = "";
            String string3 = "";
            if (navigationMethod.getNavigationUri().contains(",")) {
                String[] stringArray;
                for (String string4 : stringArray = navigationMethod.getNavigationUri().split(",")) {
                    if (string4.startsWith("{")) {
                        string4 = string4.substring(1);
                    } else if (string4.endsWith("}")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    string2 = string2 + string4 + "+','+";
                    string3 = string3 + string4 + ",";
                }
                string2 = string2.substring(0, string2.length() - 5);
                string3 = string3.substring(0, string3.length() - 1);
            } else {
                string3 = string2 = navigationMethod.getNavigationUri();
            }
            return "   " + navigationMethod.getName() + " : function(" + string3 + ") {\n" + "      var link = new " + string + navigationMethod.getLinkName() + "(this.uri+'/'+" + string2 + ");\n" + "      return link;\n" + "   }";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenReplacer {
        private Map<String, String> tokens = new HashMap<String, String>();

        public Map<String, String> getTokens() {
            return Collections.unmodifiableMap(this.tokens);
        }

        public void addToken(String string, String string2) {
            this.tokens.put(string, string2);
        }

        public void setTokens(Map<String, String> map) {
            this.tokens = map;
        }

        public void replaceTokens(FileObject fileObject) throws IOException {
            this.replaceTokens(fileObject, this.getTokens());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceTokens(FileObject fileObject, Map<String, String> map) throws IOException {
            FileLock fileLock = fileObject.lock();
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    string = this.replaceTokens(string, "", "", map);
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), ClientStubsGenerator.this.getBaseEncoding());
                try {
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }

        private String replaceTokens(String string, String string2, String string3, Map<String, String> map) {
            String string4 = string;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string5 = entry.getKey();
                String string6 = entry.getValue();
                if (string5 == null || string6 == null) continue;
                string4 = string4.replaceAll(string5, string6);
            }
            return string4;
        }
    }
}

