/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingContainer<T extends TokenId>
implements TokenOrEmbedding<T> {
    private static final Logger LOG = Logger.getLogger(EmbeddingContainer.class.getName());
    private AbstractToken<T> branchToken;
    private final TokenList<?> rootTokenList;
    private int cachedModCount;
    private int branchTokenStartOffset;
    private EmbeddedTokenList<?> firstEmbeddedTokenList;
    private EmbeddedTokenList<?> defaultEmbeddedTokenList;
    private static boolean checkStatusUpdatedThrowingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> embeddedTokenList(TokenList<T> tokenList, int n, Set<Language<?>> set, boolean bl) {
        TokenList<?> tokenList2;
        TokenList<?> tokenList3 = tokenList2 = tokenList.rootTokenList();
        synchronized (tokenList3) {
            EmbeddedTokenList<?> embeddedTokenList;
            EmbeddedTokenList<?> embeddedTokenList2;
            EmbeddingPresence embeddingPresence;
            TokenOrEmbedding<T> tokenOrEmbedding = tokenList.tokenOrEmbedding(n);
            EmbeddingContainer<T> embeddingContainer = tokenOrEmbedding.embedding();
            AbstractToken<T> abstractToken = tokenOrEmbedding.token();
            if (abstractToken.getClass() == JoinToken.class) {
                return null;
            }
            if (embeddingContainer != null) {
                embeddingPresence = null;
            } else {
                embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
                if (embeddingPresence == EmbeddingPresence.NONE) {
                    return null;
                }
            }
            if (embeddingContainer != null) {
                embeddingContainer.updateStatusUnsync();
                embeddedTokenList2 = null;
                for (embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    if (set == null || set.contains(embeddedTokenList.languagePath().innerLanguage())) {
                        EmbeddedTokenList<?> embeddedTokenList3 = embeddedTokenList;
                        return embeddedTokenList3;
                    }
                    embeddedTokenList2 = embeddedTokenList;
                }
                if (embeddingContainer.defaultEmbeddedTokenList() != null) {
                    return null;
                }
            } else {
                embeddedTokenList2 = null;
            }
            if (tokenList.isRemoved()) {
                return null;
            }
            embeddedTokenList = tokenList.languagePath();
            LanguageHierarchy languageHierarchy = LexerUtilsConstants.innerLanguageHierarchy((LanguagePath)((Object)embeddedTokenList));
            LanguageEmbedding<?> languageEmbedding = LexerUtilsConstants.findEmbedding(languageHierarchy, abstractToken, (LanguagePath)((Object)embeddedTokenList), tokenList.inputAttributes());
            if (embeddingPresence == null) {
                embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
            }
            if (languageEmbedding != null) {
                if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                    LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.ALWAYS_QUERY);
                }
                if (set != null && !set.contains(languageEmbedding.language()) || abstractToken.isRemoved() || languageEmbedding.startSkipLength() + languageEmbedding.endSkipLength() > abstractToken.length()) {
                    return null;
                }
                if (embeddingContainer == null) {
                    embeddingContainer = new EmbeddingContainer<T>(abstractToken, tokenList2);
                    tokenList.wrapToken(n, embeddingContainer);
                }
                LanguagePath languagePath = LanguagePath.get(embeddedTokenList, languageEmbedding.language());
                EmbeddedTokenList embeddedTokenList4 = new EmbeddedTokenList(embeddingContainer, languagePath, languageEmbedding);
                embeddingContainer.addEmbeddedTokenList(embeddedTokenList2, embeddedTokenList4, true);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("@@@@@@@@@@ NATURAL-EMBEDDING-CREATED for " + languagePath.mimePath() + ", " + languageEmbedding + ": " + embeddedTokenList4.dumpInfo(null) + ", initTokensInNew=" + bl + '\n');
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.INFO, "Natural embedding created by:", new Exception());
                    }
                }
                if (bl) {
                    TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList2.tokenHierarchyOperation();
                    if (languageEmbedding.joinSections()) {
                        tokenHierarchyOperation.tokenListList(languagePath);
                    } else {
                        assert (tokenHierarchyOperation.existingTokenListList(languagePath) == null);
                        embeddedTokenList4.initAllTokens();
                    }
                }
                return embeddedTokenList4;
            }
            if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.NONE);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int n, Language<ET> language, int n2, int n3, boolean bl) {
        TokenHierarchyEventInfo tokenHierarchyEventInfo;
        int n4;
        EmbeddedTokenList<ET> embeddedTokenList;
        LanguageEmbedding<ET> languageEmbedding;
        Object object;
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
        TokenList<?> tokenList2 = tokenList.rootTokenList();
        Object object2 = tokenList2;
        synchronized (object2) {
            Object object3;
            if (tokenList.isRemoved()) {
                return false;
            }
            tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            object = tokenList.tokenOrEmbedding(n);
            EmbeddingContainer<T> embeddingContainer = object.embedding();
            AbstractToken<T> abstractToken = object.token();
            if (embeddingContainer != null) {
                for (object3 = embeddingContainer.firstEmbeddedTokenList(); object3 != null; object3 = ((EmbeddedTokenList)object3).nextEmbeddedTokenList()) {
                    if (language != ((EmbeddedTokenList)object3).languagePath().innerLanguage()) continue;
                    return false;
                }
            } else {
                if (abstractToken.isFlyweight()) {
                    return false;
                }
                embeddingContainer = new EmbeddingContainer<T>(abstractToken, tokenList2);
                tokenList.wrapToken(n, embeddingContainer);
            }
            if (n2 + n3 > abstractToken.length()) {
                return false;
            }
            object3 = tokenList.languagePath();
            LanguagePath languagePath = LanguagePath.get((LanguagePath)object3, language);
            TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(languagePath);
            if (tokenListList != null && tokenListList.joinSections()) {
                bl = true;
            }
            languageEmbedding = LanguageEmbedding.create(language, n2, n3, bl);
            tokenHierarchyOperation.addLanguagePath(languagePath);
            embeddedTokenList = new EmbeddedTokenList<ET>(embeddingContainer, languagePath, languageEmbedding);
            embeddingContainer.addEmbeddedTokenList(null, embeddedTokenList, false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("@@@@@@@@@@ EXPLICIT-EMBEDDING-CREATED for " + languagePath.mimePath() + ", " + languageEmbedding + ": " + embeddedTokenList.dumpInfo(null) + '\n');
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.INFO, "Explicit embedding created by:", new Exception());
                }
            }
            n4 = embeddingContainer.branchTokenStartOffset();
            tokenHierarchyEventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_CREATED, n4, 0, "", 0);
            tokenHierarchyEventInfo.setMaxAffectedEndOffset(n4 + abstractToken.length());
            if (!languageEmbedding.joinSections()) {
                embeddedTokenList.initAllTokens();
            }
            if (tokenListList != null) {
                new TokenHierarchyUpdate(tokenHierarchyEventInfo).updateCreateOrRemoveEmbedding(embeddedTokenList, true);
            } else if (languageEmbedding.joinSections()) {
                tokenListList = tokenHierarchyOperation.tokenListList(embeddedTokenList.languagePath());
            }
        }
        object2 = new TokenChangeInfo<T>(tokenList);
        ((TokenChangeInfo)object2).setIndex(n);
        ((TokenChangeInfo)object2).setOffset(n4);
        tokenHierarchyEventInfo.setTokenChangeInfo((TokenChangeInfo<?>)object2);
        object = new TokenChangeInfo<ET>(embeddedTokenList);
        ((TokenChangeInfo)object).setIndex(0);
        ((TokenChangeInfo)object).setOffset(n4 + languageEmbedding.startSkipLength());
        ((TokenChangeInfo)object2).addEmbeddedChange((TokenChangeInfo<?>)object);
        tokenHierarchyOperation.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean removeEmbedding(TokenList<T> tokenList, int n, Language<ET> language) {
        TokenList<?> tokenList2;
        TokenList<?> tokenList3 = tokenList2 = tokenList.rootTokenList();
        synchronized (tokenList3) {
            if (tokenList.isRemoved()) {
                return false;
            }
            TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            TokenOrEmbedding<T> tokenOrEmbedding = tokenList.tokenOrEmbedding(n);
            EmbeddingContainer<T> embeddingContainer = tokenOrEmbedding.embedding();
            if (embeddingContainer != null) {
                embeddingContainer.updateStatusUnsync();
                EmbeddedTokenList<?> embeddedTokenList = null;
                for (EmbeddedTokenList<T> embeddedTokenList2 = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList2 != null; embeddedTokenList2 = embeddedTokenList2.nextEmbeddedTokenList()) {
                    if (language != embeddedTokenList2.languagePath().innerLanguage()) continue;
                    embeddingContainer.removeEmbeddedTokenList(embeddedTokenList, embeddedTokenList2);
                    embeddingContainer = new EmbeddingContainer<T>(embeddingContainer);
                    embeddingContainer.addEmbeddedTokenList(null, embeddedTokenList2, false);
                    embeddedTokenList2.setEmbeddingContainer(embeddingContainer);
                    embeddingContainer.markChildrenRemovedDeep();
                    int n2 = embeddingContainer.branchTokenStartOffset();
                    TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_REMOVED, n2, 0, "", 0);
                    tokenHierarchyEventInfo.setMaxAffectedEndOffset(n2 + embeddingContainer.token().length());
                    TokenChangeInfo<T> tokenChangeInfo = new TokenChangeInfo<T>(tokenList);
                    tokenChangeInfo.setIndex(n);
                    tokenChangeInfo.setOffset(n2);
                    tokenHierarchyEventInfo.setTokenChangeInfo(tokenChangeInfo);
                    EmbeddedTokenList<T> embeddedTokenList3 = embeddedTokenList2;
                    TokenChangeInfo tokenChangeInfo2 = new TokenChangeInfo(embeddedTokenList3);
                    tokenChangeInfo2.setIndex(0);
                    tokenChangeInfo2.setOffset(n2 + embeddedTokenList2.embedding().startSkipLength());
                    tokenChangeInfo.addEmbeddedChange(tokenChangeInfo2);
                    TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(embeddedTokenList2.languagePath());
                    if (tokenListList != null) {
                        new TokenHierarchyUpdate(tokenHierarchyEventInfo).updateCreateOrRemoveEmbedding(embeddedTokenList2, false);
                    }
                    tokenHierarchyOperation.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
                    return true;
                }
            }
        }
        return false;
    }

    EmbeddingContainer(AbstractToken<T> abstractToken, TokenList<?> tokenList) {
        if (abstractToken == null) {
            throw new IllegalArgumentException("branchToken cannot be null");
        }
        if (tokenList == null) {
            throw new IllegalArgumentException("rootTokenList cannot be null");
        }
        this.branchToken = abstractToken;
        this.rootTokenList = tokenList;
        this.cachedModCount = -3;
        this.updateStatusUnsync();
    }

    EmbeddingContainer(EmbeddingContainer<T> embeddingContainer) {
        this(embeddingContainer.token(), embeddingContainer.rootTokenList());
    }

    private void markRemoved() {
        this.cachedModCount = -2;
        for (EmbeddedTokenList<?> embeddedTokenList = this.firstEmbeddedTokenList; embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
            embeddedTokenList.resetExtraModCount();
        }
    }

    public void markRemoved(int n) {
        this.branchTokenStartOffset = n;
        this.markRemoved();
    }

    void markChildrenRemovedDeep() {
        for (EmbeddedTokenList<?> embeddedTokenList = this.firstEmbeddedTokenList; embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
            for (int i = embeddedTokenList.tokenCountCurrent() - 1; i >= 0; --i) {
                EmbeddingContainer<?> embeddingContainer = embeddedTokenList.tokenOrEmbeddingUnsync(i).embedding();
                if (embeddingContainer == null) continue;
                embeddingContainer.updateStatusUnsync();
                embeddingContainer.markChildrenRemovedDeep();
                super.markRemoved();
            }
        }
    }

    public int cachedModCount() {
        return this.cachedModCount;
    }

    @Override
    public final AbstractToken<T> token() {
        return this.branchToken;
    }

    @Override
    public final EmbeddingContainer<T> embedding() {
        return this;
    }

    public void reinit(AbstractToken<T> abstractToken) {
        this.branchToken = abstractToken;
        this.cachedModCount = -3;
        this.updateStatusUnsync();
    }

    public TokenList<?> rootTokenList() {
        return this.rootTokenList;
    }

    public int branchTokenStartOffset() {
        return this.branchTokenStartOffset;
    }

    public EmbeddedTokenList<?> firstEmbeddedTokenList() {
        return this.firstEmbeddedTokenList;
    }

    public void addEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2, boolean bl) {
        if (embeddedTokenList != null) {
            embeddedTokenList2.setNextEmbeddedTokenList(embeddedTokenList.nextEmbeddedTokenList());
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList2);
        } else {
            embeddedTokenList2.setNextEmbeddedTokenList(this.firstEmbeddedTokenList);
            this.firstEmbeddedTokenList = embeddedTokenList2;
        }
        if (bl) {
            this.defaultEmbeddedTokenList = embeddedTokenList2;
        }
    }

    public EmbeddedTokenList<?> removeEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2) {
        EmbeddedTokenList<?> embeddedTokenList3 = embeddedTokenList2.nextEmbeddedTokenList();
        if (embeddedTokenList != null) {
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList3);
        } else {
            this.firstEmbeddedTokenList = embeddedTokenList3;
        }
        embeddedTokenList2.setNextEmbeddedTokenList(null);
        if (this.defaultEmbeddedTokenList == embeddedTokenList2) {
            this.defaultEmbeddedTokenList = null;
        }
        return embeddedTokenList3;
    }

    public EmbeddedTokenList<?> defaultEmbeddedTokenList() {
        return this.defaultEmbeddedTokenList;
    }

    public boolean isRemoved() {
        return this.cachedModCount == -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        TokenList<?> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            this.updateStatusUnsync();
        }
    }

    public void updateStatusUnsync() {
        this.updateStatusImpl(this.rootTokenList.modCount());
    }

    protected int updateStatusImpl(int n) {
        if (this.cachedModCount != -2 && this.cachedModCount != n) {
            TokenList<T> tokenList = this.branchToken.tokenList();
            if (tokenList == null) {
                this.markRemoved();
            } else if (tokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)tokenList;
                this.cachedModCount = embeddedTokenList.embeddingContainer().updateStatusImpl(n);
                this.branchTokenStartOffset = embeddedTokenList.tokenOffset(this.branchToken);
            } else {
                this.cachedModCount = n;
                this.branchTokenStartOffset = tokenList.tokenOffset(this.branchToken);
            }
        }
        return this.cachedModCount;
    }

    public boolean checkStatusUpdated() {
        if (this.cachedModCount != -2 && this.cachedModCount != this.rootTokenList.modCount() && !checkStatusUpdatedThrowingException) {
            checkStatusUpdatedThrowingException = true;
            String string = "!!!INTERNAL ERROR!!! Status not updated on " + this + "\nin token hierarchy\n" + this.rootTokenList.tokenHierarchyOperation();
            checkStatusUpdatedThrowingException = false;
            throw new IllegalStateException(string);
        }
        return true;
    }
}

