/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CndLexerUtilities {
    public static final String LEXER_FILTER = "lexer-filter";
    public static final String FORTRAN_FREE_FORMAT = "fortran-free-format";
    public static final String FORTRAN_MAXIMUM_TEXT_WIDTH = "fortran-maximum-text-width";
    private static Filter<CppTokenId> FILTER_STD_C;
    private static Filter<CppTokenId> FILTER_GCC_C;
    private static Filter<CppTokenId> FILTER_STD_CPP;
    private static Filter<CppTokenId> FILTER_GCC_CPP;
    private static Filter<CppTokenId> FILTER_PREPRPOCESSOR;
    private static Filter<CppTokenId> FILTER_OMP;
    private static Filter<FortranTokenId> FILTER_FORTRAN;

    private CndLexerUtilities() {
    }

    public static TokenSequence<CppTokenId> getCppTokenSequence(JTextComponent jTextComponent, int n, boolean bl, boolean bl2) {
        Document document = jTextComponent.getDocument();
        return CndLexerUtilities.getCppTokenSequence(document, n, bl, bl2);
    }

    public static Language<CppTokenId> getLanguage(String string) {
        if ("text/x-c".equals(string)) {
            return CppTokenId.languageC();
        }
        if ("text/x-c++".equals(string)) {
            return CppTokenId.languageCpp();
        }
        if ("text/x-h".equals(string)) {
            return CppTokenId.languageHeader();
        }
        return null;
    }

    public static Language<CppTokenId> getLanguage(Document document) {
        Language<CppTokenId> language = (Language<CppTokenId>)document.getProperty(Language.class);
        if (!CndLexerUtilities.isCppLanguage(language, true)) {
            language = CndLexerUtilities.getLanguage((String)document.getProperty("mimeType"));
        }
        Language<CppTokenId> language2 = language;
        return language2;
    }

    public static TokenSequence<CppTokenId> getCppTokenSequence(Document document, int n, boolean bl, boolean bl2) {
        if (document == null) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, bl2);
        for (int i = list.size() - 1; i >= 0; --i) {
            TokenSequence tokenSequence = (TokenSequence)list.get(i);
            Language language = tokenSequence.languagePath().innerLanguage();
            if (!CndLexerUtilities.isCppLanguage(language, bl)) continue;
            TokenSequence tokenSequence2 = tokenSequence;
            return tokenSequence2;
        }
        return null;
    }

    public static boolean isCppLanguage(Language<?> language, boolean bl) {
        return language == CppTokenId.languageC() || language == CppTokenId.languageCpp() || language == CppTokenId.languageHeader() || bl && language == CppTokenId.languagePreproc();
    }

    public static TokenSequence<FortranTokenId> getFortranTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = document != null ? TokenHierarchy.get((Document)document) : null;
        TokenSequence<FortranTokenId> tokenSequence = tokenHierarchy != null ? CndLexerUtilities.getFortranTokenSequence(tokenHierarchy, n) : null;
        return tokenSequence;
    }

    public static TokenSequence<FortranTokenId> getFortranTokenSequence(TokenHierarchy tokenHierarchy, int n) {
        if (tokenHierarchy != null) {
            for (TokenSequence tokenSequence = tokenHierarchy.tokenSequence(); tokenSequence != null && (n == 0 || tokenSequence.moveNext()); tokenSequence = tokenSequence.embedded()) {
                tokenSequence.move(n);
                if (tokenSequence.language() == FortranTokenId.languageFortran()) {
                    TokenSequence tokenSequence2 = tokenSequence;
                    return tokenSequence2;
                }
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static boolean isCppIdentifier(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) {
            return false;
        }
        if (!CndLexerUtilities.isCppIdentifierStart(charSequence.charAt(0))) {
            return false;
        }
        for (int i = 1; i < charSequence.length(); ++i) {
            if (CndLexerUtilities.isCppIdentifierPart(charSequence.charAt(i))) continue;
            return false;
        }
        return CndLexerUtilities.getDefatultFilter(true).check(charSequence) == null && CndLexerUtilities.getDefatultFilter(false).check(charSequence) == null;
    }

    public static boolean isCppIdentifierStart(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_' || c == '$';
    }

    public static boolean isCppIdentifierPart(char c) {
        return '0' <= c && c <= '9' || CndLexerUtilities.isCppIdentifierStart(c);
    }

    public static boolean isCppIdentifierStart(int n) {
        return Character.isJavaIdentifierStart(n);
    }

    public static boolean isCppIdentifierPart(int n) {
        return Character.isJavaIdentifierPart(n);
    }

    public static boolean isFortranIdentifierPart(int n) {
        return Character.isJavaIdentifierPart(n);
    }

    public static CharSequence removeEscapedLF(CharSequence charSequence, boolean bl) {
        if (!bl) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length() - 1;
        for (int i = 0; i <= n; ++i) {
            char c = charSequence.charAt(i);
            boolean bl2 = true;
            if (c == '\\') {
                if (i < n && charSequence.charAt(i + 1) == '\r') {
                    ++i;
                    bl2 = false;
                }
                if (i < n && charSequence.charAt(i + 1) == '\n') {
                    ++i;
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isKeyword(String string) {
        try {
            CppTokenId cppTokenId = CppTokenId.valueOf(string.toUpperCase());
            return cppTokenId != null && ("keyword".equals(cppTokenId.primaryCategory()) || "keyword-directive".equals(cppTokenId.primaryCategory()) || "preprocessor-keyword".equals(cppTokenId.primaryCategory())) || "preprocessor-keyword-directive".equals(cppTokenId.primaryCategory());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isType(String string) {
        block4: {
            try {
                if (string.contains(" ")) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(" ")) {
                        if (!CndLexerUtilities.isType(string2)) continue;
                        return true;
                    }
                    break block4;
                }
                CppTokenId cppTokenId = CppTokenId.valueOf(string.toUpperCase());
                return CndLexerUtilities.isType(cppTokenId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isType(CppTokenId cppTokenId) {
        switch (cppTokenId) {
            case AUTO: 
            case BOOL: 
            case CHAR: 
            case CONST: 
            case DOUBLE: 
            case ENUM: 
            case EXPORT: 
            case FLOAT: 
            case INLINE: 
            case _INLINE: 
            case __INLINE: 
            case __INLINE__: 
            case INT: 
            case LONG: 
            case MUTABLE: 
            case REGISTER: 
            case SHORT: 
            case SIGNED: 
            case __SIGNED: 
            case __SIGNED__: 
            case SIZEOF: 
            case TYPEDEF: 
            case TYPEID: 
            case TYPEOF: 
            case __TYPEOF: 
            case __TYPEOF__: 
            case UNSIGNED: 
            case __UNSIGNED__: 
            case VOID: 
            case VOLATILE: 
            case WCHAR_T: 
            case _BOOL: 
            case _COMPLEX: 
            case __COMPLEX__: 
            case _IMAGINARY: 
            case __IMAG__: 
            case _INT64: 
            case __INT64: 
            case __REAL__: 
            case __W64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSeparatorOrOperator(CppTokenId cppTokenId) {
        String string = cppTokenId.primaryCategory();
        return "operator".equals(string) || "separator".equals(string);
    }

    public static Filter<CppTokenId> getDefatultFilter(boolean bl) {
        return bl ? CndLexerUtilities.getStdCppFilter() : CndLexerUtilities.getStdCFilter();
    }

    public static synchronized Filter<CppTokenId> getPreprocFilter() {
        if (FILTER_PREPRPOCESSOR == null) {
            FILTER_PREPRPOCESSOR = new Filter();
            CndLexerUtilities.addPreprocKeywords(FILTER_PREPRPOCESSOR);
        }
        return FILTER_PREPRPOCESSOR;
    }

    public static synchronized Filter<CppTokenId> getOmpFilter() {
        if (FILTER_OMP == null) {
            FILTER_OMP = new Filter();
            CndLexerUtilities.addOmpKeywords(FILTER_OMP);
        }
        return FILTER_OMP;
    }

    public static synchronized Filter<CppTokenId> getStdCFilter() {
        if (FILTER_STD_C == null) {
            FILTER_STD_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_STD_C);
        }
        return FILTER_STD_C;
    }

    public static synchronized Filter<CppTokenId> getGccCFilter() {
        if (FILTER_GCC_C == null) {
            FILTER_GCC_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_GCC_C);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_C);
        }
        return FILTER_GCC_C;
    }

    public static synchronized Filter<CppTokenId> getStdCppFilter() {
        if (FILTER_STD_CPP == null) {
            FILTER_STD_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_STD_CPP);
        }
        return FILTER_STD_CPP;
    }

    public static synchronized Filter<CppTokenId> getGccCppFilter() {
        if (FILTER_GCC_CPP == null) {
            FILTER_GCC_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_GCC_CPP);
        }
        return FILTER_GCC_CPP;
    }

    public static synchronized Filter<FortranTokenId> getFortranFilter() {
        if (FILTER_FORTRAN == null) {
            FILTER_FORTRAN = new Filter();
            CndLexerUtilities.addFortranKeywords(FILTER_FORTRAN);
        }
        return FILTER_FORTRAN;
    }

    private static void addPreprocKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.PREPROCESSOR_IF, CppTokenId.PREPROCESSOR_IFDEF, CppTokenId.PREPROCESSOR_IFNDEF, CppTokenId.PREPROCESSOR_ELSE, CppTokenId.PREPROCESSOR_ELIF, CppTokenId.PREPROCESSOR_ENDIF, CppTokenId.PREPROCESSOR_DEFINE, CppTokenId.PREPROCESSOR_UNDEF, CppTokenId.PREPROCESSOR_INCLUDE, CppTokenId.PREPROCESSOR_INCLUDE_NEXT, CppTokenId.PREPROCESSOR_LINE, CppTokenId.PREPROCESSOR_IDENT, CppTokenId.PREPROCESSOR_PRAGMA, CppTokenId.PREPROCESSOR_WARNING, CppTokenId.PREPROCESSOR_ERROR};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addOmpKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.PRAGMA_OMP_START, CppTokenId.PRAGMA_OMP_PARALLEL, CppTokenId.PRAGMA_OMP_SECTIONS, CppTokenId.PRAGMA_OMP_NOWAIT, CppTokenId.PRAGMA_OMP_ORDERED, CppTokenId.PRAGMA_OMP_SCHEDULE, CppTokenId.PRAGMA_OMP_DYNAMIC, CppTokenId.PRAGMA_OMP_GUIDED, CppTokenId.PRAGMA_OMP_RUNTIME, CppTokenId.PRAGMA_OMP_SECTION, CppTokenId.PRAGMA_OMP_SINGLE, CppTokenId.PRAGMA_OMP_MASTER, CppTokenId.PRAGMA_OMP_CRITICAL, CppTokenId.PRAGMA_OMP_BARRIER, CppTokenId.PRAGMA_OMP_ATOMIC, CppTokenId.PRAGMA_OMP_FLUSH, CppTokenId.PRAGMA_OMP_THREADPRIVATE, CppTokenId.PRAGMA_OMP_PRIVATE, CppTokenId.PRAGMA_OMP_FIRSTPRIVATE, CppTokenId.PRAGMA_OMP_LASTPRIVATE, CppTokenId.PRAGMA_OMP_SHARED, CppTokenId.PRAGMA_OMP_NONE, CppTokenId.PRAGMA_OMP_REDUCTION, CppTokenId.PRAGMA_OMP_COPYIN, CppTokenId.PRAGMA_OMP_TASK, CppTokenId.PRAGMA_OMP_TASKWAIT, CppTokenId.PRAGMA_OMP_COLLAPSE, CppTokenId.PRAGMA_OMP_COPYPRIVATE, CppTokenId.PRAGMA_OMP_DEFAULT, CppTokenId.PRAGMA_OMP_STATIC, CppTokenId.PRAGMA_OMP_IF, CppTokenId.PRAGMA_OMP_FOR, CppTokenId.PRAGMA_OMP_AUTO, CppTokenId.PRAGMA_OMP_NUM_THREADS};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCommonCCKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.AUTO, CppTokenId.BREAK, CppTokenId.CASE, CppTokenId.CHAR, CppTokenId.CONST, CppTokenId.CONTINUE, CppTokenId.DEFAULT, CppTokenId.DO, CppTokenId.DOUBLE, CppTokenId.ELSE, CppTokenId.ENUM, CppTokenId.EXTERN, CppTokenId.FLOAT, CppTokenId.FOR, CppTokenId.__FUNC__, CppTokenId.GOTO, CppTokenId.IF, CppTokenId.INT, CppTokenId.LONG, CppTokenId.REGISTER, CppTokenId.RETURN, CppTokenId.SHORT, CppTokenId.SIGNED, CppTokenId.SIZEOF, CppTokenId.STATIC, CppTokenId.STRUCT, CppTokenId.SWITCH, CppTokenId.TYPEDEF, CppTokenId.UNION, CppTokenId.UNSIGNED, CppTokenId.VOID, CppTokenId.VOLATILE, CppTokenId.WHILE};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCppOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ASM, CppTokenId.BOOL, CppTokenId.CATCH, CppTokenId.CLASS, CppTokenId.CONST_CAST, CppTokenId.DELETE, CppTokenId.DYNAMIC_CAST, CppTokenId.EXPLICIT, CppTokenId.EXPORT, CppTokenId.FINALLY, CppTokenId.FRIEND, CppTokenId.INLINE, CppTokenId.MUTABLE, CppTokenId.NAMESPACE, CppTokenId.NEW, CppTokenId.OPERATOR, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC, CppTokenId.REINTERPRET_CAST, CppTokenId.STATIC_CAST, CppTokenId.TEMPLATE, CppTokenId.THIS, CppTokenId.THROW, CppTokenId.TRY, CppTokenId.TYPEID, CppTokenId.TYPENAME, CppTokenId.TYPEOF, CppTokenId.USING, CppTokenId.VIRTUAL, CppTokenId.WCHAR_T, CppTokenId.TRUE, CppTokenId.FALSE};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addCOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.INLINE, CppTokenId.RESTRICT, CppTokenId._BOOL, CppTokenId._COMPLEX, CppTokenId._IMAGINARY};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addGccOnlyCommonCCKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ASM, CppTokenId.__ALIGNOF__, CppTokenId.__ASM, CppTokenId.__ASM__, CppTokenId.__ATTRIBUTE__, CppTokenId.__ATTRIBUTE, CppTokenId.__COMPLEX__, CppTokenId.__CONST, CppTokenId.__CONST__, CppTokenId.__IMAG__, CppTokenId.INLINE, CppTokenId.__INLINE, CppTokenId.__REAL__, CppTokenId.__RESTRICT, CppTokenId.__SIGNED, CppTokenId.__SIGNED__, CppTokenId.TYPEOF, CppTokenId.__TYPEOF, CppTokenId.__TYPEOF__, CppTokenId.__VOLATILE, CppTokenId.__VOLATILE__, CppTokenId.__THREAD, CppTokenId.__UNUSED__};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addGccOnlyCppOnlyKeywords(Filter<CppTokenId> filter) {
        CppTokenId[] cppTokenIdArray = new CppTokenId[]{CppTokenId.ALIGNOF, CppTokenId._ASM, CppTokenId._INLINE, CppTokenId.PASCAL, CppTokenId._PASCAL, CppTokenId.__PASCAL, CppTokenId.__UNSIGNED__, CppTokenId._CDECL, CppTokenId.__CDECL, CppTokenId._DECLSPEC, CppTokenId.__DECLSPEC, CppTokenId.__EXTENSION__, CppTokenId._FAR, CppTokenId.__FAR, CppTokenId._INT64, CppTokenId.__INT64, CppTokenId.__INTERRUPT, CppTokenId._NEAR, CppTokenId.__NEAR, CppTokenId._STDCALL, CppTokenId.__STDCALL, CppTokenId.__W64};
        CndLexerUtilities.addToFilter(cppTokenIdArray, filter);
    }

    private static void addFortranKeywords(Filter<FortranTokenId> filter) {
        FortranTokenId[] fortranTokenIdArray = new FortranTokenId[]{FortranTokenId.KW_ALLOCATABLE, FortranTokenId.KW_ALLOCATE, FortranTokenId.KW_APOSTROPHE, FortranTokenId.KW_ASSIGNMENT, FortranTokenId.KW_ASSOCIATE, FortranTokenId.KW_ASYNCHRONOUS, FortranTokenId.KW_BACKSPACE, FortranTokenId.KW_BIND, FortranTokenId.KW_BLOCK, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_CALL, FortranTokenId.KW_CASE, FortranTokenId.KW_CHARACTER, FortranTokenId.KW_CLASS, FortranTokenId.KW_CLOSE, FortranTokenId.KW_COMMON, FortranTokenId.KW_COMPLEX, FortranTokenId.KW_CONTAINS, FortranTokenId.KW_CONTINUE, FortranTokenId.KW_CYCLE, FortranTokenId.KW_DATA, FortranTokenId.KW_DEALLOCATE, FortranTokenId.KW_DEFAULT, FortranTokenId.KW_DIMENSION, FortranTokenId.KW_DO, FortranTokenId.KW_DOUBLE, FortranTokenId.KW_DOUBLEPRECISION, FortranTokenId.KW_ELEMENTAL, FortranTokenId.KW_ELSE, FortranTokenId.KW_ELSEIF, FortranTokenId.KW_ELSEWHERE, FortranTokenId.KW_END, FortranTokenId.KW_ENDASSOCIATE, FortranTokenId.KW_ENDBLOCK, FortranTokenId.KW_ENDBLOCKDATA, FortranTokenId.KW_ENDDO, FortranTokenId.KW_ENDENUM, FortranTokenId.KW_ENDFILE, FortranTokenId.KW_ENDFORALL, FortranTokenId.KW_ENDFUNCTION, FortranTokenId.KW_ENDIF, FortranTokenId.KW_ENDINTERFACE, FortranTokenId.KW_ENDMAP, FortranTokenId.KW_ENDMODULE, FortranTokenId.KW_ENDPROGRAM, FortranTokenId.KW_ENDSELECT, FortranTokenId.KW_ENDSTRUCTURE, FortranTokenId.KW_ENDSUBROUTINE, FortranTokenId.KW_ENDTYPE, FortranTokenId.KW_ENDUNION, FortranTokenId.KW_ENDWHERE, FortranTokenId.KW_ENDWHILE, FortranTokenId.KW_ENTRY, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENUMERATOR, FortranTokenId.KW_EQUIVALENCE, FortranTokenId.KW_EXIT, FortranTokenId.KW_EXTERNAL, FortranTokenId.KW_FLUSH, FortranTokenId.KW_FORALL, FortranTokenId.KW_FORMAT, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_GO, FortranTokenId.KW_GOTO, FortranTokenId.KW_IF, FortranTokenId.KW_IMPLICIT, FortranTokenId.KW_IN, FortranTokenId.KW_INCLUDE, FortranTokenId.KW_INOUT, FortranTokenId.KW_INQUIRE, FortranTokenId.KW_INTEGER, FortranTokenId.KW_INTENT, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_INTRINSIC, FortranTokenId.KW_KIND, FortranTokenId.KW_LEN, FortranTokenId.KW_LOGICAL, FortranTokenId.KW_MAP, FortranTokenId.KW_MODULE, FortranTokenId.KW_NAMELIST, FortranTokenId.KW_NONE, FortranTokenId.KW_NULLIFY, FortranTokenId.KW_ONLY, FortranTokenId.KW_OPEN, FortranTokenId.KW_OPERATOR, FortranTokenId.KW_OPTIONAL, FortranTokenId.KW_OUT, FortranTokenId.KW_PARAMETER, FortranTokenId.KW_POINTER, FortranTokenId.KW_PRECISION, FortranTokenId.KW_PRINT, FortranTokenId.KW_PRIVATE, FortranTokenId.KW_PROCEDURE, FortranTokenId.KW_PROGRAM, FortranTokenId.KW_PROTECTED, FortranTokenId.KW_PUBLIC, FortranTokenId.KW_PURE, FortranTokenId.KW_QUOTE, FortranTokenId.KW_READ, FortranTokenId.KW_REAL, FortranTokenId.KW_RECURSIVE, FortranTokenId.KW_RESULT, FortranTokenId.KW_RETURN, FortranTokenId.KW_REWIND, FortranTokenId.KW_SAVE, FortranTokenId.KW_SELECT, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_SELECTTYPE, FortranTokenId.KW_SEQUENCE, FortranTokenId.KW_STAT, FortranTokenId.KW_STOP, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_TARGET, FortranTokenId.KW_THEN, FortranTokenId.KW_TO, FortranTokenId.KW_TYPE, FortranTokenId.KW_UNION, FortranTokenId.KW_USE, FortranTokenId.KW_VALUE, FortranTokenId.KW_VOLATILE, FortranTokenId.KW_WAIT, FortranTokenId.KW_WHERE, FortranTokenId.KW_WHILE, FortranTokenId.KW_WRITE, FortranTokenId.KW_INT, FortranTokenId.KW_SHORT, FortranTokenId.KW_LONG, FortranTokenId.KW_SIGNED, FortranTokenId.KW_UNSIGNED, FortranTokenId.KW_SIZE_T, FortranTokenId.KW_INT8_T, FortranTokenId.KW_INT16_T, FortranTokenId.KW_INT32_T, FortranTokenId.KW_INT64_T, FortranTokenId.KW_INT_LEAST8_T, FortranTokenId.KW_INT_LEAST16_T, FortranTokenId.KW_INT_LEAST32_T, FortranTokenId.KW_INT_LEAST64_T, FortranTokenId.KW_INT_FAST8_T, FortranTokenId.KW_INT_FAST16_T, FortranTokenId.KW_INT_FAST32_T, FortranTokenId.KW_INT_FAST64_T, FortranTokenId.KW_INTMAX_T, FortranTokenId.KW_INTPTR_T, FortranTokenId.KW_FLOAT, FortranTokenId.KW__COMPLEX, FortranTokenId.KW__BOOL, FortranTokenId.KW_CHAR, FortranTokenId.KW_BOOL, FortranTokenId.KWOP_EQ, FortranTokenId.KWOP_NE, FortranTokenId.KWOP_LT, FortranTokenId.KWOP_LE, FortranTokenId.KWOP_GT, FortranTokenId.KWOP_GE, FortranTokenId.KWOP_AND, FortranTokenId.KWOP_OR, FortranTokenId.KWOP_NOT, FortranTokenId.KWOP_EQV, FortranTokenId.KWOP_NEQV, FortranTokenId.KWOP_TRUE, FortranTokenId.KWOP_FALSE};
        CndLexerUtilities.addToFilter(fortranTokenIdArray, filter);
    }

    private static void addToFilter(CppTokenId[] cppTokenIdArray, Filter<CppTokenId> filter) {
        for (CppTokenId cppTokenId : cppTokenIdArray) {
            assert (cppTokenId.fixedText() != null) : "id " + (Object)((Object)cppTokenId) + " must have fixed text";
            filter.addMatch(cppTokenId.fixedText(), cppTokenId);
        }
    }

    private static void addToFilter(FortranTokenId[] fortranTokenIdArray, Filter<FortranTokenId> filter) {
        for (FortranTokenId fortranTokenId : fortranTokenIdArray) {
            assert (fortranTokenId.fixedText() != null) : "id " + (Object)((Object)fortranTokenId) + " must have fixed text";
            filter.addMatch(fortranTokenId.fixedText(), fortranTokenId);
        }
    }
}

