/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.ServerType;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.jaxws._RetoucheUtil;
import org.netbeans.modules.maven.jaxws.actions.AddOperationAction;
import org.netbeans.modules.maven.jaxws.actions.WSEditAttributesAction;
import org.netbeans.modules.maven.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.maven.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesCookieImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsNode
extends AbstractNode
implements ConfigureHandlerCookie {
    JaxWsService service;
    FileObject srcRoot;
    private FileObject implBeanClass;
    InstanceContent content;
    Project project;
    private static final String WAITING_BADGE = "org/netbeans/modules/maven/jaxws/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/maven/jaxws/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/maven/jaxws/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsNode(JaxWsService jaxWsService, FileObject fileObject, FileObject fileObject2) {
        this(jaxWsService, fileObject, fileObject2, new InstanceContent());
    }

    private JaxWsNode(JaxWsService jaxWsService, FileObject fileObject, FileObject fileObject2, InstanceContent instanceContent) {
        super((Children)new JaxWsChildren(jaxWsService, fileObject, fileObject2), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.service = jaxWsService;
        this.srcRoot = fileObject;
        this.content = instanceContent;
        this.implBeanClass = fileObject2;
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        String string = jaxWsService.getServiceName();
        this.setName(string);
        instanceContent.add((Object)this);
        instanceContent.add((Object)jaxWsService);
        instanceContent.add((Object)fileObject2);
        OpenCookie openCookie = new OpenCookie(){

            public void open() {
                OpenCookie openCookie = JaxWsNode.this.getOpenCookie();
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        };
        instanceContent.add((Object)openCookie);
        this.setServiceUrl();
        instanceContent.add((Object)new EditWSAttributesCookieImpl((Node)this));
        this.attachFileChangeListener();
    }

    private boolean isWebProject() {
        J2eeModule.Type type;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.WAR.equals(type = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public String getDisplayName() {
        return this.service.getServiceName();
    }

    public String getShortDescription() {
        return this.getWsdlURL();
    }

    public Image getIcon(int n) {
        return this.getServiceImage();
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private DataObject getDataObject() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return null;
    }

    private OpenCookie getOpenCookie() {
        OpenCookie openCookie = null;
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return openCookie;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
        ArrayList<CallableSystemAction> arrayList = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(AddOperationAction.class), null, (CallableSystemAction)SystemAction.get(WsTesterPageAction.class), (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(arrayList, "WebServices/Services/Actions");
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    private String getWebServiceURL() {
        String string;
        Object object;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String string2 = j2eeModuleProvider.getServerInstanceID();
        if (string2 == null || "DEV-NULL".equals(string2)) {
            Logger.getLogger(JaxWsNode.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string2);
        String string3 = "8080";
        String string4 = "localhost";
        try {
            object = serverInstance.getDescriptor();
            if (object != null) {
                int n = object.getHttpPort();
                string3 = n == 0 ? "8080" : String.valueOf(n);
                string = object.getHostname();
                if (string != null) {
                    string4 = string;
                }
            } else {
                InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
                if (instanceProperties == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
                    return "";
                }
                string3 = this.getPortNumber(instanceProperties);
                string4 = this.getHostName(instanceProperties);
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Removed ServerInstance", instanceRemovedException);
        }
        object = null;
        J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
        string = null;
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        try {
            string = this.getServiceUri(type);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (J2eeModule.Type.WAR.equals(type)) {
            NbMavenProject nbMavenProject;
            J2eeModuleProvider.ConfigSupport configSupport = j2eeModuleProvider.getConfigSupport();
            try {
                object = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (object != null && ((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            if ((object == null || ((String)object).length() == 0) && ServerType.GLASSFISH == wSStackUtils.getServerType() && (nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                MavenProject mavenProject = nbMavenProject.getMavenProject();
                String string5 = mavenProject.getGroupId();
                String string6 = mavenProject.getArtifactId();
                String string7 = mavenProject.getPackaging();
                String string8 = mavenProject.getVersion();
                if (string5 != null && string6 != null && string7 != null && string8 != null) {
                    object = string5 + "_" + string6 + "_" + string7 + "_" + string8;
                }
            }
        }
        return "http://" + string4 + ":" + string3 + "/" + (object != null && !((String)object).equals("") ? (String)object + "/" : "") + string;
    }

    private String findUrlPattern(WebApp webApp, String string) {
        for (Servlet servlet : webApp.getServlet()) {
            String string2;
            if (!string.equals(servlet.getServletClass()) || (string2 = servlet.getServletName()) == null) continue;
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                if (!string2.equals(servletMapping.getServletName())) continue;
                String string3 = servletMapping.getUrlPattern();
                return string3.startsWith("/") ? string3.substring(1) : string3;
            }
        }
        return null;
    }

    private String getServiceUri(final J2eeModule.Type type) throws UnsupportedEncodingException {
        Object object;
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = this.getImplBeanJavaSource();
        if (javaSource != null) {
            object = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    boolean bl;
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
                    if (typeElement != null && typeElement2 != null && !(bl = JaxWsNode.this.resolveServiceUrl(type, compilationController, typeElement, typeElement2, stringArray, stringArray2))) {
                        TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.xml.ws.WebServiceProvider");
                        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : list) {
                            if (!compilationController.getTypes().isSameType(typeElement3.asType(), annotationMirror.getAnnotationType())) continue;
                            blArray[0] = true;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)object, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        object = this.service.getImplementationClass();
        String string = this.getNameFromPackageName((String)object);
        if (stringArray[0] == null) {
            stringArray[0] = URLEncoder.encode(string + "Service", "UTF-8");
        }
        if (J2eeModule.Type.WAR.equals(type)) {
            return stringArray[0];
        }
        if (J2eeModule.Type.EJB.equals(type)) {
            if (stringArray2[0] == null) {
                stringArray2[0] = blArray[0] ? object : string;
                stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
            }
            return stringArray[0] + "/" + stringArray2[0];
        }
        return stringArray[0];
    }

    private boolean resolveServiceUrl(J2eeModule.Type type, CompilationController compilationController, TypeElement typeElement, TypeElement typeElement2, String[] stringArray, String[] stringArray2) throws IOException {
        boolean bl = false;
        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : list) {
            if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
            bl = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                    stringArray[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray[0] != null) {
                        stringArray[0] = URLEncoder.encode(stringArray[0], "UTF-8");
                    }
                } else if (entry.getKey().getSimpleName().contentEquals("name")) {
                    stringArray2[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray2[0] != null) {
                        stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
                    }
                }
                if (stringArray[0] == null || stringArray2[0] == null) continue;
                break block0;
            }
        }
        return bl;
    }

    private String getNameFromPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public String getWsdlURL() {
        String string = this.getWebServiceURL();
        return string.length() == 0 ? "" : string + "?wsdl";
    }

    public String getTesterPageURL() {
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        if (ServerType.GLASSFISH == wSStackUtils.getServerType() || ServerType.GLASSFISH_V3 == wSStackUtils.getServerType()) {
            return this.getWebServiceURL() + "?Tester";
        }
        return this.getWebServiceURL();
    }

    public void destroy() throws IOException {
        if (this.service.getLocalWsdl() != null) {
            final String string = this.service.getId();
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    MavenModelUtils.removeWsimportExecution(pOMModel, string);
                }
            };
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            try {
                this.removeStaleFile(string);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", iOException);
            }
            FileObject fileObject2 = this.getLocalWsdl();
            JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
            if (fileObject2 != null && jAXWSLightSupport != null) {
                boolean bl = false;
                List list = jAXWSLightSupport.getServices();
                for (JaxWsService jaxWsService : list) {
                    if (string == null || string.equals(jaxWsService.getId()) || !this.service.getLocalWsdl().equals(jaxWsService.getLocalWsdl())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    fileObject2.delete();
                }
            }
        }
        WSUtils.removeImplClass(this.project, this.service.getImplementationClass());
    }

    private FileObject getImplBean() {
        String string = this.service.getImplementationClass();
        if (string != null) {
            return this.srcRoot.getFileObject(string.replace('.', '/') + ".java");
        }
        return null;
    }

    private FileObject getLocalWsdl() {
        String string;
        FileObject fileObject;
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
        if (jAXWSLightSupport != null && (fileObject = jAXWSLightSupport.getWsdlFolder(false)) != null && (string = this.service.getLocalWsdl()) != null) {
            return fileObject.getFileObject(string);
        }
        return null;
    }

    private JavaSource getImplBeanJavaSource() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    private String getPortNumber(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("httpportnumber");
        if (string == null || string.equals("")) {
            return "8080";
        }
        return string;
    }

    private String getHostName(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("url");
        String string2 = "localhost";
        if (string != null && string.indexOf("::") > 0) {
            int n = string.indexOf("::");
            int n2 = string.lastIndexOf(":");
            if (n2 > n + 2) {
                string2 = string.substring(n + 2, n2);
            }
        }
        return string2;
    }

    void setServiceUrl() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                JaxWsNode.this.setValue("wsdl-url", JaxWsNode.this.getWsdlURL());
            }
        });
    }

    protected void fireShortDescriptionChange() {
        this.setShortDescription(this.getWsdlURL());
    }

    private void attachFileChangeListener() {
        this.implBeanClass.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(final FileEvent fileEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = JaxWsNode.this.service.getServiceName();
                        final String[] stringArray = new String[1];
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileEvent.getFile());
                        if (javaSource != null) {
                            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                                public void run(CompilationController compilationController) throws IOException {
                                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                                    if (typeElement != null) {
                                        stringArray[0] = JaxWsNode.this.getServiceName(compilationController, typeElement);
                                    }
                                }

                                public void cancel() {
                                }
                            };
                            try {
                                javaSource.runUserActionTask((Task)cancellableTask, true);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                            if (stringArray[0] == null) {
                                stringArray[0] = fileEvent.getFile().getName() + "Service";
                            }
                            if (!stringArray[0].equals(string)) {
                                FileObject fileObject = JaxWsNode.this.getImplBean();
                                if (JaxWsNode.this.getImplBean() != null) {
                                    JaxWsNode.this.service.setServiceName(stringArray[0]);
                                    JaxWsNode.this.fireDisplayNameChange(string, stringArray[0]);
                                    JaxWsNode.this.fireNameChange(string, stringArray[0]);
                                    JaxWsNode.this.fireShortDescriptionChange();
                                    if (!WSUtils.isJsr109Supported(JaxWsNode.this.project)) {
                                        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)fileObject);
                                        FileObject fileObject2 = jAXWSLightSupport.getDeploymentDescriptorFolder();
                                        if (fileObject2 != null) {
                                            try {
                                                WSUtils.replaceSunJaxWsEntries(fileObject2, string, stringArray[0]);
                                            }
                                            catch (IOException iOException) {
                                                Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify endpoint in sun-jaxws.xml file", iOException);
                                            }
                                        }
                                        try {
                                            WSUtils.replaceServiceEntriesFromDD(JaxWsNode.this.project, string, stringArray[0]);
                                        }
                                        catch (IOException iOException) {
                                            Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify web.xml file", iOException);
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private String getServiceName(CompilationController compilationController, TypeElement typeElement) {
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
        if (typeElement2 != null) {
            List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("serviceName")) continue;
                    return (String)map.get(entry.getKey()).getValue();
                }
            }
        }
        return null;
    }

    public void configureHandler() {
        File file;
        Object object;
        FileObject fileObject;
        boolean[] blArray;
        HandlerChains handlerChains;
        FileObject fileObject2;
        ArrayList<String> arrayList;
        FileObject fileObject3;
        block10: {
            fileObject3 = this.getImplBean();
            arrayList = new ArrayList<String>();
            fileObject2 = null;
            handlerChains = null;
            Object[] objectArray = new String[1];
            blArray = new boolean[]{true};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject3);
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>((String[])objectArray){
                final /* synthetic */ String[] val$handlerFileName;
                {
                    this.val$handlerFileName = stringArray;
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    AnnotationMirror annotationMirror = _RetoucheUtil.getAnnotation(compilationController, typeElement, "javax.jws.HandlerChain");
                    if (annotationMirror != null) {
                        blArray[0] = false;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (ExecutableElement executableElement : map.keySet()) {
                            if (!executableElement.getSimpleName().contentEquals("file")) continue;
                            this.val$handlerFileName[0] = (String)map.get(executableElement).getValue();
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!blArray[0] && objectArray[0] != null) {
                try {
                    fileObject = fileObject3.getParent();
                    object = FileUtil.toFile((FileObject)fileObject);
                    file = new File((File)object, objectArray[0]);
                    if (file.exists()) {
                        file = file.getCanonicalFile();
                        fileObject2 = FileUtil.toFileObject((File)file);
                    }
                    if (fileObject2 != null) {
                        try {
                            handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(fileObject2);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                            return;
                        }
                        HandlerChain[] handlerChainArray = handlerChains.getHandlerChains();
                        HandlerChain handlerChain = handlerChainArray[0];
                        Handler[] handlerArray = handlerChain.getHandlers();
                        for (int i = 0; i < handlerArray.length; ++i) {
                            arrayList.add(handlerArray[i].getHandlerClass());
                        }
                        break block10;
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object[])objectArray), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        fileObject = new MessageHandlerPanel(this.project, arrayList, true, this.service.getServiceName());
        object = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        file = new DialogDescriptor((Object)fileObject, (String)object);
        file.setButtonListener(new HandlerButtonListener((MessageHandlerPanel)fileObject, handlerChains, fileObject2, fileObject3, this.service, blArray[0]));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
    }

    private void removeStaleFile(String string) throws IOException {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("target/jaxws/stale/" + string + ".stale");
        if (fileObject != null) {
            fileObject.delete();
        }
    }
}

