/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsChildren
extends Children.Keys<Object> {
    private Image cachedIcon;
    private static final String OPERATION_ICON = "org/netbeans/modules/websvc/core/webservices/ui/resources/wsoperation.png";
    private FileObject implClass;
    private JaxWsService service;
    private FileObject srcRoot;
    private FileChangeListener fcl;

    public JaxWsChildren(JaxWsService jaxWsService, FileObject fileObject, FileObject fileObject2) {
        this.service = jaxWsService;
        this.srcRoot = fileObject;
        this.implClass = fileObject2;
    }

    private List<ExecutableElement> getPublicMethods(CompilationController compilationController, TypeElement typeElement) throws IOException {
        List<? extends Element> list = typeElement.getEnclosedElements();
        List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElement : list2) {
            Set<Modifier> set = executableElement.getModifiers();
            if (!set.contains((Object)Modifier.PUBLIC)) continue;
            arrayList.add(executableElement);
        }
        return arrayList;
    }

    protected void addNotify() {
        assert (this.implClass != null);
        if (this.fcl == null) {
            this.fcl = new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    JaxWsChildren.this.updateKeys();
                    ((JaxWsNode)JaxWsChildren.this.getNode()).fireShortDescriptionChange();
                    ((JaxWsNode)JaxWsChildren.this.getNode()).setServiceUrl();
                }
            };
            this.implClass.addFileChangeListener(this.fcl);
        }
        this.updateKeys();
    }

    protected void removeNotify() {
        if (this.fcl != null) {
            this.implClass.removeFileChangeListener(this.fcl);
            this.fcl = null;
        }
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaSource javaSource;
                final List[] listArray = new List[1];
                if (JaxWsChildren.this.implClass != null && (javaSource = JavaSource.forFileObject((FileObject)JaxWsChildren.this.implClass)) != null) {
                    CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                        public void run(CompilationController compilationController) throws IOException {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                            if (typeElement != null) {
                                List list = JaxWsChildren.this.getPublicMethods(compilationController, typeElement);
                                ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                                TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                                if (typeElement2 != null) {
                                    List<? extends VariableElement> list2;
                                    Object object;
                                    Object object2;
                                    boolean bl = false;
                                    for (ExecutableElement executableElement : list) {
                                        object2 = executableElement.getAnnotationMirrors();
                                        boolean bl2 = false;
                                        object = object2.iterator();
                                        while (object.hasNext()) {
                                            list2 = object.next();
                                            if (!compilationController.getTypes().isSameType(typeElement2.asType(), list2.getAnnotationType())) continue;
                                            bl2 = true;
                                            break;
                                        }
                                        if (bl2) {
                                            if (!bl) {
                                                bl = true;
                                                if (arrayList.size() > 0) {
                                                    arrayList.clear();
                                                }
                                            }
                                            arrayList.add(executableElement);
                                            continue;
                                        }
                                        if (bl) continue;
                                        arrayList.add(executableElement);
                                    }
                                    for (ExecutableElement executableElement : arrayList) {
                                        Object object3;
                                        object2 = new WebOperationInfo();
                                        List<? extends AnnotationMirror> list3 = executableElement.getAnnotationMirrors();
                                        object = list3.iterator();
                                        while (object.hasNext()) {
                                            list2 = object.next();
                                            if (!compilationController.getTypes().isSameType(typeElement2.asType(), list2.getAnnotationType())) continue;
                                            object3 = list2.getElementValues();
                                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : object3.entrySet()) {
                                                if (!entry.getKey().getSimpleName().contentEquals("operationName")) continue;
                                                ((WebOperationInfo)object2).setOperationName((String)((AnnotationValue)object3.get(entry.getKey())).getValue());
                                            }
                                        }
                                        if (((WebOperationInfo)object2).getOperationName() == null) {
                                            ((WebOperationInfo)object2).setOperationName(executableElement.getSimpleName().toString());
                                        }
                                        if ((object = executableElement.getReturnType()).getKind() == TypeKind.DECLARED) {
                                            list2 = (TypeElement)((DeclaredType)object).asElement();
                                            ((WebOperationInfo)object2).setReturnType(list2.getQualifiedName().toString());
                                        } else {
                                            ((WebOperationInfo)object2).setReturnType(object.toString());
                                        }
                                        list2 = executableElement.getParameters();
                                        object3 = new ArrayList();
                                        for (VariableElement variableElement : list2) {
                                            TypeMirror typeMirror = variableElement.asType();
                                            if (typeMirror.getKind() == TypeKind.DECLARED) {
                                                TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
                                                object3.add(typeElement3.getQualifiedName().toString());
                                                continue;
                                            }
                                            object3.add(((Object)typeMirror).toString());
                                        }
                                        ((WebOperationInfo)object2).setParamTypes((List<String>)object3);
                                        arrayList2.add(object2);
                                    }
                                }
                                listArray[0] = arrayList2;
                            }
                        }

                        public void cancel() {
                        }
                    };
                    try {
                        javaSource.runUserActionTask((Task)cancellableTask, true);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                if (listArray[0] == null) {
                    listArray[0] = Collections.emptyList();
                }
                JaxWsChildren.this.setKeys(listArray[0]);
            }
        });
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof WebOperationInfo) {
            final WebOperationInfo webOperationInfo = (WebOperationInfo)object;
            AbstractNode abstractNode = new AbstractNode(Children.LEAF){

                public Image getIcon(int n) {
                    if (JaxWsChildren.this.cachedIcon == null) {
                        JaxWsChildren.this.cachedIcon = ImageUtilities.loadImage((String)JaxWsChildren.OPERATION_ICON);
                    }
                    return JaxWsChildren.this.cachedIcon;
                }

                public Action[] getActions(boolean bl) {
                    return new Action[]{SystemAction.get(PropertiesAction.class)};
                }

                public Action getPreferredAction() {
                    return SystemAction.get(PropertiesAction.class);
                }

                public String getDisplayName() {
                    return webOperationInfo.getOperationName() + ": " + JaxWsChildren.this.getClassName(webOperationInfo.getReturnType());
                }
            };
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : webOperationInfo.getParamTypes()) {
                stringBuffer.append(stringBuffer.length() == 0 ? string : ", " + string);
            }
            abstractNode.setShortDescription(NbBundle.getMessage(JaxWsChildren.class, (String)"TXT_operationDesc", (Object)webOperationInfo.getReturnType(), (Object)webOperationInfo.getOperationName(), (Object)stringBuffer.toString()));
            return new Node[]{abstractNode};
        }
        return new Node[0];
    }

    private String getClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebOperationInfo {
        private String operationName;
        private List<String> paramTypes;
        private String returnType;

        private WebOperationInfo() {
        }

        String getOperationName() {
            return this.operationName;
        }

        void setOperationName(String string) {
            this.operationName = string;
        }

        List<String> getParamTypes() {
            return this.paramTypes;
        }

        void setParamTypes(List<String> list) {
            this.paramTypes = list;
        }

        String getReturnType() {
            return this.returnType;
        }

        void setReturnType(String string) {
            this.returnType = string;
        }
    }
}

