/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenJaxWsSupportProvider
implements JAXWSLightSupportProvider,
PropertyChangeListener {
    private static final RequestProcessor MAVEN_WS_RP = new RequestProcessor("MavenJaxWsSupportProvider.WS_REQUEST_PROCESSOR");
    private RequestProcessor.Task pomChangesTask = MAVEN_WS_RP.create(new Runnable(){

        public void run() {
            MavenJaxWsSupportProvider.this.reactOnPomChanges();
        }
    });
    private JAXWSLightSupport jaxWsSupport;
    private PropertyChangeListener pcl;
    private NbMavenProject mp;
    private Project prj;
    private MetadataModel<WebservicesMetadata> wsModel;

    MavenJaxWsSupportProvider(Project project, final JAXWSLightSupport jAXWSLightSupport) {
        this.prj = project;
        this.jaxWsSupport = jAXWSLightSupport;
        MAVEN_WS_RP.post(new Runnable(){

            public void run() {
                MavenJaxWsSupportProvider.this.registerPCL();
                MavenJaxWsSupportProvider.this.wsModel = jAXWSLightSupport.getWebservicesMetadataModel();
                if (MavenJaxWsSupportProvider.this.wsModel != null) {
                    MavenJaxWsSupportProvider.this.registerAnnotationListener((MetadataModel<WebservicesMetadata>)MavenJaxWsSupportProvider.this.wsModel);
                }
            }
        });
    }

    public JAXWSLightSupport findJAXWSSupport() {
        return this.jaxWsSupport;
    }

    void registerPCL() {
        this.unregisterPCL();
        this.mp = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        this.mp.addPropertyChangeListener((PropertyChangeListener)this);
    }

    void registerAnnotationListener(final MetadataModel<WebservicesMetadata> metadataModel) {
        try {
            metadataModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                public Void run(WebservicesMetadata webservicesMetadata) {
                    Webservices webservices = webservicesMetadata.getRoot();
                    if (MavenJaxWsSupportProvider.this.pcl != null) {
                        webservices.removePropertyChangeListener(MavenJaxWsSupportProvider.this.pcl);
                    }
                    MavenJaxWsSupportProvider.this.pcl = new WebservicesChangeListener(MavenJaxWsSupportProvider.this.jaxWsSupport, (MetadataModel<WebservicesMetadata>)metadataModel);
                    webservices.addPropertyChangeListener(MavenJaxWsSupportProvider.this.pcl);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void unregisterPCL() {
        if (this.mp != null) {
            this.mp.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void unregisterAnnotationListener() {
        if (this.pcl != null && this.wsModel != null) {
            try {
                this.wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                    public Void run(WebservicesMetadata webservicesMetadata) {
                        Webservices webservices = webservicesMetadata.getRoot();
                        webservices.removePropertyChangeListener(MavenJaxWsSupportProvider.this.pcl);
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
            this.pomChangesTask.schedule(1000);
        }
    }

    private void reactOnPomChanges() {
        WSUtils.updateClients(this.prj, this.jaxWsSupport);
        List list = this.jaxWsSupport.getServices();
        if (list.size() > 0) {
            MavenModelUtils.reactOnServerChanges(this.prj);
            if (WSUtils.isWeb(this.prj)) {
                for (JaxWsService jaxWsService : list) {
                    if (!jaxWsService.isServiceProvider()) continue;
                    WSUtils.checkNonJSR109Entries(this.prj);
                    break;
                }
            }
        }
    }

    static /* synthetic */ RequestProcessor access$500() {
        return MAVEN_WS_RP;
    }

    private class ServiceInfo {
        private String serviceName;
        private String portName;
        private String implClass;
        private String wsdlLocation;

        public ServiceInfo(String string, String string2, String string3, String string4) {
            this.serviceName = string;
            this.portName = string2;
            this.implClass = string3;
            this.wsdlLocation = string4;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public void setImplClass(String string) {
            this.implClass = string;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String string) {
            this.portName = string;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public String getWsdlLocation() {
            return this.wsdlLocation;
        }

        public void setWsdlLocation(String string) {
            this.wsdlLocation = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebservicesChangeListener
    implements PropertyChangeListener {
        private JAXWSLightSupport jaxWsSupport;
        private MetadataModel<WebservicesMetadata> wsModel;
        private RequestProcessor.Task updateJaxWsTask = MavenJaxWsSupportProvider.access$500().create(new Runnable(){

            public void run() {
                WebservicesChangeListener.this.updateJaxWs();
            }
        });

        WebservicesChangeListener(JAXWSLightSupport jAXWSLightSupport, MetadataModel<WebservicesMetadata> metadataModel) {
            this.jaxWsSupport = jAXWSLightSupport;
            this.wsModel = metadataModel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateJaxWsTask.schedule(1000);
        }

        private synchronized void updateJaxWs() {
            try {
                Object object;
                Object object22;
                Map map = (Map)this.wsModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Map<String, ServiceInfo>>(){

                    public Map<String, ServiceInfo> run(WebservicesMetadata webservicesMetadata) {
                        HashMap<String, ServiceInfo> hashMap = new HashMap<String, ServiceInfo>();
                        Webservices webservices = webservicesMetadata.getRoot();
                        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
                            PortComponent[] portComponentArray;
                            for (PortComponent portComponent : portComponentArray = webserviceDescription.getPortComponent()) {
                                String string = portComponent.getDisplayName();
                                if (!WSUtils.isInSourceGroup(MavenJaxWsSupportProvider.this.prj, string)) continue;
                                QName qName = portComponent.getWsdlPort();
                                hashMap.put(string, new ServiceInfo(webserviceDescription.getWebserviceDescriptionName(), qName == null ? null : qName.getLocalPart(), string, webserviceDescription.getWsdlFile()));
                            }
                        }
                        return hashMap;
                    }
                });
                List list = this.jaxWsSupport.getServices();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (Object object22 : list) {
                    if (!object22.isServiceProvider()) continue;
                    hashMap.put(object22.getImplementationClass(), object22);
                }
                HashSet hashSet = new HashSet();
                object22 = hashMap.keySet();
                Set set = map.keySet();
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (!set.contains(object)) continue;
                    hashSet.add(object);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    hashMap.remove(object);
                    map.remove(object);
                }
                boolean bl = false;
                for (String string : hashMap.keySet()) {
                    this.jaxWsSupport.removeService((JaxWsService)hashMap.get(string));
                }
                for (String string : map.keySet()) {
                    ServiceInfo serviceInfo = (ServiceInfo)map.get(string);
                    String string2 = serviceInfo.getWsdlLocation();
                    JaxWsService jaxWsService = new JaxWsService(serviceInfo.getServiceName(), string);
                    if (string2 != null && string2.length() > 0) {
                        jaxWsService.setWsdlLocation(string2);
                        if (string2.startsWith("WEB-INF/wsdl/")) {
                            jaxWsService.setLocalWsdl(string2.substring(13));
                        } else if (string2.startsWith("META-INF/wsdl/")) {
                            jaxWsService.setLocalWsdl(string2.substring(14));
                        } else {
                            jaxWsService.setLocalWsdl(string2);
                        }
                        FileObject fileObject = WSUtils.getLocalWsdl(this.jaxWsSupport, jaxWsService.getLocalWsdl());
                        if (fileObject != null) {
                            jaxWsService.setId(WSUtils.getUniqueId(fileObject.getName(), list));
                        }
                        jaxWsService.setWsdlUrl(WSUtils.getOriginalWsdlUrl(MavenJaxWsSupportProvider.this.prj, jaxWsService.getId(), true));
                    }
                    jaxWsService.setPortName(serviceInfo.getPortName());
                    this.jaxWsSupport.addService(jaxWsService);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

