/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerUtilities {
    public static final int ACTION_TIMEOUT = 15000;
    public static final TimeUnit ACTION_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    public static final String GFV3_VERSION_MATCHER = "(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GFV3_JAR_MATCHER = "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String PROP_FIRST_RUN = "first_run";
    private GlassfishInstanceProvider gip;

    private ServerUtilities(GlassfishInstanceProvider glassfishInstanceProvider) {
        assert (null != glassfishInstanceProvider);
        this.gip = glassfishInstanceProvider;
    }

    public static ServerUtilities getPreludeUtilities() {
        GlassfishInstanceProvider glassfishInstanceProvider = GlassfishInstanceProvider.getPrelude();
        return null == glassfishInstanceProvider ? null : new ServerUtilities(glassfishInstanceProvider);
    }

    public static ServerUtilities getEe6Utilities() {
        GlassfishInstanceProvider glassfishInstanceProvider = GlassfishInstanceProvider.getEe6();
        return null == glassfishInstanceProvider ? null : new ServerUtilities(glassfishInstanceProvider);
    }

    public ServerInstance getServerInstance(String string) {
        ServerInstance serverInstance = this.gip.getInstance(string);
        return serverInstance;
    }

    public boolean isRegisteredUri(String string) {
        return this.gip.getInstance(string) != null || GlassfishInstanceProvider.activeRegistrationSet.contains(string);
    }

    public Lookup getLookupFor(ServerInstance serverInstance) {
        return this.gip.getLookupFor(serverInstance);
    }

    public <T> T getInstanceByCapability(String string, Class<T> clazz) {
        return this.gip.getInstanceByCapability(string, clazz);
    }

    public <T> List<T> getInstancesByCapability(Class<T> clazz) {
        return this.gip.getInstancesByCapability(clazz);
    }

    public WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return new ServerWizardIterator(this.gip);
    }

    public ServerInstanceProvider getServerProvider() {
        return this.gip;
    }

    public static File getJarName(String string, String string2) {
        File[] fileArray;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray);
        }
        if ((fileArray = file.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static File getWsJarName(String string, String string2) {
        File[] fileArray;
        File[] fileArray2;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray2 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray2);
        }
        if ((fileArray2 = file.listFiles(new VersionFilter(string2))) != null && fileArray2.length > 0) {
            return fileArray2[0];
        }
        File file2 = new File(file, "endorsed");
        if (file2 != null && file2.isDirectory() && (fileArray = file2.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    public static final String quote(String string) {
        return string.indexOf(32) == -1 ? string : "\"" + string + "\"";
    }

    public static boolean isTP2(String string) {
        return ServerUtilities.getJarName(string, GFV3_JAR_MATCHER).getName().indexOf("-tp-2-") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> filterByManifest(List<String> list, FileObject fileObject, int n, boolean bl) {
        if (null != fileObject) {
            int n2 = fileObject.getPath().length();
            if (n == 1) {
                n2 = fileObject.getParent().getPath().length();
            }
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder()) {
                    if (n >= 1) continue;
                    ServerUtilities.filterByManifest(list, fileObject2, n + 1, bl);
                    continue;
                }
                if (!fileObject2.getNameExt().endsWith(".jar")) continue;
                JarFile jarFile = null;
                try {
                    String string;
                    Attributes attributes;
                    jarFile = new JarFile(FileUtil.toFile((FileObject)fileObject2), false);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (string = attributes.getValue("Bundle-SymbolicName")) == null || !string.contains("javax")) continue;
                    String string2 = fileObject2.getPath().substring(n2);
                    if (bl) {
                        string2 = string2.replace("\\", "\\\\");
                    }
                    list.add(string2);
                }
                catch (IOException iOException) {
                    Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, fileObject2.getPath(), iOException);
                }
                finally {
                    if (null != jarFile) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, fileObject2.getPath(), iOException);
                        }
                        jarFile = null;
                    }
                }
            }
        } else {
            Logger.getLogger(ServerUtilities.class.getName()).log(Level.FINER, "Null FileObject passed in as the parent parameter. Returning the original list");
        }
        return list;
    }

    public String[] getAssociatedJavaDoc() {
        return this.gip.getAssociatedJavaDoc();
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String string) {
            this.pattern = Pattern.compile(string);
        }

        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

