/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.common.JvmConfigReader;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.ProcessCreationException;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTask
extends BasicTask<GlassfishModule.OperationState> {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    private final CommonServerSupport support;
    private List<Recognizer> recognizers;
    private FileObject jdkHome = null;
    private List<String> jvmArgs = null;

    public StartTask(CommonServerSupport commonServerSupport, List<Recognizer> list, OperationStateListener ... operationStateListenerArray) {
        this(commonServerSupport, list, (FileObject)null, (String[])null, operationStateListenerArray);
    }

    public StartTask(final CommonServerSupport commonServerSupport, List<Recognizer> list, FileObject fileObject, String[] stringArray, OperationStateListener ... operationStateListenerArray) {
        super(commonServerSupport.getInstanceProperties(), operationStateListenerArray);
        ArrayList<OperationStateListener> arrayList = new ArrayList<OperationStateListener>();
        arrayList.addAll(Arrays.asList(operationStateListenerArray));
        arrayList.add(new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (GlassfishModule.OperationState.COMPLETED.equals((Object)operationState)) {
                    RequestProcessor.getDefault().post((Runnable)new EnableComet(commonServerSupport));
                }
            }
        });
        this.stateListener = arrayList.toArray(new OperationStateListener[arrayList.size()]);
        this.support = commonServerSupport;
        this.recognizers = list;
        this.jdkHome = fileObject;
        this.jvmArgs = stringArray != null ? Arrays.asList(StartTask.removeEscapes(stringArray)) : null;
    }

    private static String[] removeEscapes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("\\\"", "");
        }
        return stringArray;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Process process;
        Object object;
        Logger.getLogger("glassfish").log(Level.FINEST, "StartTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long l = System.currentTimeMillis();
        int n = 0;
        String string = (String)this.ip.get("host");
        if (string == null || string.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            n = Integer.valueOf((String)this.ip.get("adminPort"));
            if (n < 0 || n > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
            this.jdkHome = this.getJavaPlatformRoot(this.support);
            object = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != object && "true".equals(this.ip.get("derbyStartOn"))) {
                object.start();
            }
            if (CommonServerSupport.isRunning(string, n)) {
                GlassfishModule.OperationState operationState = GlassfishModule.OperationState.COMPLETED;
                if ("profileMode".equals(this.ip.get("jvmMode"))) {
                    operationState = GlassfishModule.OperationState.FAILED;
                }
                return this.fireOperationStateChanged(operationState, "MSG_START_SERVER_OCCUPIED_PORT", this.instanceName);
            }
            process = this.createProcess();
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.INFO, (String)this.ip.get("httpportnumber"), numberFormatException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, iOException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", iOException.getLocalizedMessage());
        }
        catch (ProcessCreationException processCreationException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, processCreationException);
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_PASS_THROUGH", processCreationException.getLocalizedMessage());
        }
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_START_SERVER_IN_PROGRESS", this.instanceName);
        object = LogViewMgr.getInstance((String)this.ip.get("url"));
        ((LogViewMgr)object).readInputStreams(this.recognizers, process.getInputStream(), process.getErrorStream());
        while (System.currentTimeMillis() - l < 120000L) {
            boolean bl = CommonServerSupport.isRunning(string, n);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bl) {
                Logger.getLogger("glassfish").log(Level.FINE, "Server HTTP is live.");
                GlassfishModule.OperationState operationState = GlassfishModule.OperationState.COMPLETED;
                String string2 = "MSG_SERVER_STARTED";
                if (!this.support.isReady(true, 30, TimeUnit.SECONDS)) {
                    operationState = GlassfishModule.OperationState.FAILED;
                    string2 = "MSG_START_SERVER_FAILED";
                    ((LogViewMgr)object).stopReaders();
                }
                return this.fireOperationStateChanged(operationState, string2, this.instanceName);
            }
            if (null == this.jvmArgs) continue;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    while (!CommonServerSupport.isRunning(StartTask.this.support.getHostName(), StartTask.this.support.getAdminPortNumber())) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StartTask.this.support.refresh();
                        }
                    });
                }
            });
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
        }
        Logger.getLogger("glassfish").log(Level.INFO, "V3 Failed to start, killing process: " + process + " after " + (System.currentTimeMillis() - l));
        process.destroy();
        ((LogViewMgr)object).stopReaders();
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED2", this.instanceName);
    }

    private String[] createEnvironment() {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getJdkHome();
        if (string != null) {
            object3 = "JAVA_HOME=" + string;
            arrayList.add((String)object3);
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to set JAVA_HOME for GlassFish V3 enviroment.");
        }
        object3 = Locale.getDefault();
        if (((Locale)object3).equals(new Locale("tr", "TR"))) {
            arrayList.add("LANG=en_US");
            arrayList.add("LC_ALL=en_US");
            object2 = NbBundle.getMessage(StartTask.class, (String)"MSG_LocaleSwitched");
            object = new NotifyDescriptor.Message(object2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)object);
        }
        this.appendSystemEnvVar(arrayList, "GEM_HOME");
        this.appendSystemEnvVar(arrayList, "GEM_PATH");
        object2 = Logger.getLogger("glassfish");
        if (((Logger)object2).isLoggable(Level.FINE)) {
            object = "V3 Environment: ";
            for (String string2 : arrayList) {
                object = (String)object + string2;
                object = (String)object + " ";
            }
            ((Logger)object2).log(Level.FINE, (String)object);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void appendSystemEnvVar(List<String> list, String string) {
        String string2 = (String)this.ip.get(string);
        if (string2 != null && string2.length() > 0) {
            list.add(string + "=" + string2);
        }
    }

    private FileObject getJavaPlatformRoot(CommonServerSupport commonServerSupport) throws IOException {
        FileObject fileObject;
        String string = commonServerSupport.getInstanceProperties().get("java.platform");
        if (null == string || string.trim().length() < 1) {
            File file = new File(this.getJdkHome());
            fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file));
        } else {
            File file = new File(string);
            if (file.exists()) {
                File file2 = file.getParentFile().getParentFile();
                fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file2));
            } else {
                throw new FileNotFoundException(NbBundle.getMessage(StartTask.class, (String)"MSG_INVALID_JAVA", (Object)this.instanceName, (Object)string));
            }
        }
        return fileObject;
    }

    private String getJdkHome() {
        String string;
        if (null != this.jdkHome) {
            string = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath();
        } else {
            string = System.getProperty("java.home");
            if (string.endsWith(File.separatorChar + "jre")) {
                string = string.substring(0, string.length() - 4);
            }
        }
        return string;
    }

    private NbProcessDescriptor createProcessDescriptor() throws ProcessCreationException {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2;
        ArrayList<String> arrayList;
        File file;
        String string = FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath() + File.separatorChar + "bin" + File.separatorChar + "java";
        if (Utilities.isWindows()) {
            string = string + ".exe";
        }
        if (!(file = new File(string)).exists()) {
            throw new ProcessCreationException(null, "MSG_INVALID_JAVA", this.instanceName, string);
        }
        if (this.support.getInstanceProvider().requiresJdk6OrHigher() && !Util.appearsToBeJdk6OrBetter(file)) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_JDK_ERROR", this.instanceName);
        }
        String string2 = (String)this.ip.get("homefolder");
        File file2 = ServerUtilities.getJarName(string2, "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (file2 == null) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_FNF", new String[0]);
        }
        File file3 = this.getDomainFolder();
        if (!this.readJvmArgs(file3, arrayList = new ArrayList<String>(10), hashMap2 = new HashMap<String, String>(), hashMap = new HashMap<String, String>())) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_DOMAIN_FNF", new String[0]);
        }
        if (null != this.jvmArgs) {
            arrayList.addAll(this.jvmArgs);
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        String string3 = this.computeClassPath(hashMap, file3, file2);
        if (string3 != null) {
            stringBuilder.append("-cp ");
            stringBuilder.append(string3);
        }
        this.appendSystemVars(hashMap2, stringBuilder);
        this.appendJavaOpts(arrayList, stringBuilder);
        if (string3 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(MAIN_CLASS);
        } else {
            stringBuilder.append(" -jar ");
            stringBuilder.append(Util.quote(file2.getAbsolutePath()));
        }
        stringBuilder.append(" --domain " + this.getDomainName());
        stringBuilder.append(" --domaindir " + Util.quote(file3.getAbsolutePath()));
        String string4 = stringBuilder.toString();
        Logger.getLogger("glassfish").log(Level.FINE, "V3 JVM Command: " + string + " " + string4);
        return new NbProcessDescriptor(string, string4);
    }

    private String computeClassPath(Map<String, String> map, File file, File file2) {
        String string = null;
        List<File> list = Util.classPathToFileList(map.get("classpath-prefix"), file);
        List<File> list2 = Util.classPathToFileList(map.get("classpath-suffix"), file);
        boolean bl = "false".equals(map.get("env-classpath-ignored"));
        List<File> list3 = Util.classPathToFileList(bl ? System.getenv("CLASSPATH") : null, file);
        List<File> list4 = Util.classPathToFileList(map.get("system-classpath"), file);
        if (list.size() > 0 || list2.size() > 0 || list3.size() > 0 || list4.size() > 0) {
            List<File> list5 = Util.classPathToFileList(file2.getAbsolutePath(), null);
            if (list5.size() > 0) {
                ArrayList<File> arrayList = new ArrayList<File>(32);
                arrayList.addAll(list);
                arrayList.addAll(list5);
                arrayList.addAll(list4);
                arrayList.addAll(list3);
                arrayList.addAll(list2);
                StringBuilder stringBuilder = new StringBuilder(1024);
                Iterator iterator = arrayList.iterator();
                stringBuilder.append(Util.quote(((File)iterator.next()).getPath()));
                while (iterator.hasNext()) {
                    stringBuilder.append(File.pathSeparatorChar);
                    stringBuilder.append(Util.quote(((File)iterator.next()).getPath()));
                }
                string = stringBuilder.toString();
            } else {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to read main classpath from glassfish main jar when building launch classpath.");
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder appendJavaOpts(List<String> list, StringBuilder stringBuilder) throws ProcessCreationException {
        block14: {
            String string = "";
            try {
                for (String string2 : list) {
                    stringBuilder.append(' ');
                    stringBuilder.append(string2);
                }
                if (!"debugMode".equals(this.ip.get("jvmMode"))) break block14;
                string = (String)this.ip.get("debugPort");
                Object object = "dt_socket";
                if ("true".equals(this.ip.get("use.shared.mem"))) {
                    object = "dt_shmem";
                } else {
                    int n = 0;
                    if (null != string && string.trim().length() > 0 && ((n = Integer.parseInt(string)) < 0 || n > 65535)) {
                        throw new NumberFormatException();
                    }
                }
                if (null == string || "".equals(string)) {
                    if ("true".equals(this.ip.get("use.shared.mem"))) {
                        string = Integer.toString(Math.abs(((String)this.ip.get("homefolder") + (String)this.ip.get("domainsfolder") + (String)this.ip.get("domainname")).hashCode() + 1));
                    } else {
                        int n = 9009;
                        ServerSocket serverSocket = null;
                        try {
                            serverSocket = new ServerSocket(0);
                            n = serverSocket.getLocalPort();
                            string = Integer.toString(n);
                        }
                        finally {
                            if (null != serverSocket) {
                                serverSocket.close();
                            }
                        }
                    }
                }
                this.support.setEnvironmentProperty("debugPort", string, true);
                stringBuilder.append(" -Xdebug -Xrunjdwp:transport=");
                stringBuilder.append((String)object);
                stringBuilder.append(",address=");
                stringBuilder.append(string);
                stringBuilder.append(",server=y,suspend=n");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProcessCreationException(numberFormatException, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, string);
            }
            catch (IOException iOException) {
                throw new ProcessCreationException(iOException, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, string);
            }
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVars(Map<String, String> map, StringBuilder stringBuilder) {
        this.appendSystemVar(stringBuilder, "jruby.home", (String)this.ip.get("jruby.home"));
        this.appendSystemVar(stringBuilder, "v3.grizzly.cometSupport", (String)this.ip.get("v3.grizzly.cometSupport"));
        if ("true".equals(this.ip.get("useIDEProxyOn"))) {
            String[] stringArray = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
            boolean bl = Utilities.isWindows();
            for (String string : stringArray) {
                String string2 = System.getProperty(string);
                if (string2 == null || string2.trim().length() <= 0) continue;
                if (bl && "http.nonProxyHosts".equals(string)) {
                    string2 = "\"" + string2 + "\"";
                }
                map.put(string, string2);
            }
        }
        map.remove("jruby.home");
        map.remove("v3.grizzly.cometSupport");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.appendSystemVar(stringBuilder, entry.getKey(), entry.getValue());
        }
        return stringBuilder;
    }

    private StringBuilder appendSystemVar(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" -D");
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(Util.quote(string2));
        }
        return stringBuilder;
    }

    private Process createProcess() throws ProcessCreationException {
        Process process = null;
        NbProcessDescriptor nbProcessDescriptor = this.createProcessDescriptor();
        if (nbProcessDescriptor != null) {
            try {
                process = nbProcessDescriptor.exec(null, this.createEnvironment(), true, this.getDomainFolder());
            }
            catch (IOException iOException) {
                throw new ProcessCreationException(iOException, "MSG_START_SERVER_FAILED_PD", this.instanceName);
            }
        }
        return process;
    }

    private File getDomainFolder() {
        return new File((String)this.ip.get("domainsfolder") + File.separatorChar + this.getDomainName());
    }

    private final String getDomainName() {
        return (String)this.ip.get("domainname");
    }

    private boolean readJvmArgs(File file, List<String> list, Map<String, String> map, Map<String, String> map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.sun.aas.installRoot", Utils.escapePath((String)this.ip.get("homefolder")));
        hashMap.put("com.sun.aas.instanceRoot", Utils.escapePath(file.getAbsolutePath()));
        hashMap.put("com.sun.aas.javaRoot", Utils.escapePath(this.jdkHome.getPath()));
        hashMap.put("com.sun.aas.derbyRoot", this.getJavaDBLocation());
        File file2 = new File(file, "config/domain.xml");
        if (file2.exists()) {
            JvmConfigReader jvmConfigReader = new JvmConfigReader(list, map, hashMap, map2);
            ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
            arrayList.add(new TreeParser.Path("/domain/servers/server", jvmConfigReader.getServerFinder()));
            arrayList.add(new TreeParser.Path("/domain/configs/config", jvmConfigReader.getConfigFinder()));
            arrayList.add(new TreeParser.Path("/domain/configs/config/java-config", jvmConfigReader));
            File file3 = new File((String)this.ip.get("homefolder"));
            File file4 = new File(file3, "lib/monitor/btrace-agent.jar");
            if (file4.exists()) {
                arrayList.add(new TreeParser.Path("/domain/configs/config/monitoring-service", jvmConfigReader.getMonitoringFinder(file4)));
            }
            try {
                TreeParser.readXml(file2, arrayList);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
            }
        }
        return false;
    }

    private String getJavaDBLocation() {
        String string = (String)this.ip.get("installfolder") + File.separatorChar + "javadb";
        string = new File(string).exists() ? Utils.escapePath(string) : Utils.escapePath(this.jdkHome.getPath() + File.separatorChar + "javadb");
        return string;
    }
}

