/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.glassfish.spi.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmConfigReader
extends TreeParser.NodeReader {
    private static final String SERVER_NAME = "server";
    private final Map<String, String> argMap;
    private final Map<String, String> varMap;
    private final Map<String, String> propMap;
    private final List<String> optList;
    private String serverConfigName;
    private boolean readJvmConfig = false;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public JvmConfigReader(List<String> list, Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        this.optList = list;
        this.argMap = map;
        this.varMap = map2;
        this.propMap = map3;
    }

    public TreeParser.NodeReader getServerFinder() {
        return new TreeParser.NodeReader(){

            public void readAttributes(String string, Attributes attributes) throws SAXException {
                if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && JvmConfigReader.SERVER_NAME.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: Server profile defined by " + JvmConfigReader.this.serverConfigName);
                }
            }
        };
    }

    public TreeParser.NodeReader getConfigFinder() {
        return new TreeParser.NodeReader(){

            public void readAttributes(String string, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.readJvmConfig = true;
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: Reading JVM options from server profile " + JvmConfigReader.this.serverConfigName);
                }
            }

            public void endNode(String string) throws SAXException {
                JvmConfigReader.this.readJvmConfig = false;
            }
        };
    }

    @Override
    public void readAttributes(String string, Attributes attributes) throws SAXException {
        if (this.readJvmConfig) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string2 = attributes.getLocalName(i);
                String string3 = attributes.getValue(i);
                if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0) continue;
                this.propMap.put(string2, string3);
            }
        }
    }

    @Override
    public void readCData(String string, char[] cArray, int n, int n2) throws SAXException {
        if (this.readJvmConfig) {
            String string2 = new String(cArray, n, n2);
            if (string2.startsWith("-D")) {
                int n3 = string2.indexOf(61);
                if (n3 != -1) {
                    String string3 = string2.substring(2, n3);
                    String string4 = this.doSub(string2.substring(n3 + 1));
                    if (string3.length() > 0) {
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: argument name = " + string3 + ", value = " + string4);
                        this.argMap.put(string3, string4);
                    }
                }
            } else if (string2.startsWith("-X")) {
                int n4 = (string2 = this.doSub(string2)).indexOf(61);
                if (n4 != -1) {
                    String string5 = string2.substring(0, n4);
                    String string6 = string2.substring(n4 + 1);
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string5 + " = " + string6);
                    this.optList.add(string5 + '=' + Util.quote(string6));
                } else {
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string2);
                    this.optList.add(string2);
                }
            } else if (string2.startsWith("-")) {
                Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + string2);
                this.optList.add(string2);
            }
        }
    }

    private String doSub(String string) {
        try {
            Matcher matcher = this.pattern.matcher(string);
            boolean bl = matcher.find();
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                do {
                    String string2;
                    String string3;
                    if ((string3 = this.varMap.get(string2 = matcher.group(1))) == null) {
                        string3 = System.getProperty(string2);
                        string3 = string3 != null ? Utils.escapePath(string3) : "\\$\\{" + string2 + "\\}";
                    }
                    matcher.appendReplacement(stringBuffer, string3);
                } while (bl = matcher.find());
                matcher.appendTail(stringBuffer);
                string = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
        }
        return string;
    }

    public TreeParser.NodeReader getMonitoringFinder(final File file) {
        return new TreeParser.NodeReader(){

            public void readAttributes(String string, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.readJvmConfig && !"false".equals(attributes.getValue("monitoring-enabled"))) {
                    JvmConfigReader.this.optList.add("-javaagent:" + Util.quote(file.getAbsolutePath()) + "=unsafe=true,noServer=true");
                }
            }
        };
    }
}

