/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JTable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.operators.JTableOperator;

public class PopupSwitcherOperator
extends JTableOperator {
    public PopupSwitcherOperator() {
        this(PopupSwitcherOperator.waitPopupSwitcher());
    }

    public PopupSwitcherOperator(JTable jTable) {
        super(jTable);
    }

    public void selectItem(String string) {
        Point point = this.findCell(string, 0);
        if (point.equals(new Point(-1, -1))) {
            throw new JemmyException("Cannot select item \"" + string + "\".");
        }
        this.selectCell(point.y, point.x);
    }

    public void selectItem(int n) {
        int n2 = this.getRowCount();
        if (n2 == 0) {
            throw new JemmyException("Cannot select item with index \"" + n + "\", table is empty.");
        }
        int n3 = 0;
        if (n > n2) {
            n3 = n / n2;
            n %= n2;
        }
        this.selectCell(n, n3);
    }

    public void selectItem(int n, int n2) {
        this.selectCell(n, n2);
    }

    public static JTable waitPopupSwitcher() {
        Window window = null;
        try {
            window = new WindowWaiter().waitWindow((ComponentChooser)new PopupChooser(ComponentSearcher.getTrueChooser((String)"Any Popup window")));
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting for popup window interrupted.");
        }
        return JTableOperator.waitJTable((Container)window, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"Any JTable"));
    }

    private static class PopupChooser
    implements ComponentChooser {
        private ComponentChooser subChooser;

        public PopupChooser(ComponentChooser componentChooser) {
            this.subChooser = componentChooser;
        }

        public boolean checkComponent(Component component) {
            Class<?> clazz = component.getClass();
            do {
                if (!clazz.getName().startsWith("javax.swing.Popup")) continue;
                return this.subChooser.checkComponent(component);
            } while ((clazz = clazz.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subChooser.getDescription();
        }
    }
}

