/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.util.FileUtils;
import org.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String dir;
    private String cipher;
    private byte[] decrypt;
    private byte[] encrypt;

    private void showUsage() {
        this.out.println("Allows changing the database file encryption password or algorithm.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -cipher <type>    AES or XTEA\n" + " [-dir <dir>]      The database directory (default: .)\n" + " [-db <database>]  The database name (default: all databases)\n" + " [-decrypt <pwd>]  The decryption password (default: the database is not yet encrypted)\n" + " [-encrypt <pwd>]  The encryption password (default: the database should not be encrypted)\n" + " [-quiet]          Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new ChangeFileEncryption().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        String string3 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dir")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-cipher")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-db")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-decrypt")) {
                cArray = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-encrypt")) {
                cArray2 = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string4);
            this.showUsage();
            return;
        }
        if (cArray2 == null && cArray == null || string2 == null) {
            this.showUsage();
            return;
        }
        this.process(string, string3, string2, cArray, cArray2, bl);
    }

    private static byte[] getFileEncryptionKey(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        SHA256 sHA256 = new SHA256();
        return sHA256.getKeyPasswordHash("file", cArray);
    }

    public static void execute(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        new ChangeFileEncryption().process(string, string2, string3, cArray, cArray2, bl);
    }

    private void process(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        String string4;
        int n;
        ChangeFileEncryption changeFileEncryption = new ChangeFileEncryption();
        if (cArray2 != null) {
            for (int i = 0; i < cArray2.length; ++i) {
                if (cArray2[i] != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
        }
        changeFileEncryption.out = this.out;
        changeFileEncryption.dir = string;
        changeFileEncryption.cipher = string3;
        changeFileEncryption.decrypt = ChangeFileEncryption.getFileEncryptionKey(cArray);
        changeFileEncryption.encrypt = ChangeFileEncryption.getFileEncryptionKey(cArray2);
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, false);
        if (arrayList.size() == 0 && !bl) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string4 = (String)arrayList.get(n);
            String string5 = string + "/temp.db";
            FileUtils.delete(string5);
            FileUtils.rename(string4, string5);
            FileUtils.rename(string5, string4);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string4 = (String)arrayList.get(n);
            changeFileEncryption.process(string4);
        }
    }

    private void process(String string) throws SQLException {
        boolean bl = Database.isTextStorage(string, false);
        byte[] byArray = Database.getMagic(bl);
        FileStore fileStore = this.decrypt == null ? FileStore.open(null, string, "r", byArray) : FileStore.open(null, string, "r", byArray, this.cipher, this.decrypt);
        fileStore.init();
        this.copy(string, bl, fileStore, this.encrypt);
    }

    private void copy(String string, boolean bl, FileStore fileStore, byte[] byArray) throws SQLException {
        long l;
        String string2 = this.dir + "/temp.db";
        FileUtils.delete(string2);
        byte[] byArray2 = Database.getMagic(bl);
        FileStore fileStore2 = byArray == null ? FileStore.open(null, string2, "rw", byArray2) : FileStore.open(null, string2, "rw", byArray2, this.cipher, byArray);
        fileStore2.init();
        byte[] byArray3 = new byte[4096];
        long l2 = l = fileStore.length() - 48L;
        fileStore.seek(48L);
        fileStore2.seek(48L);
        long l3 = System.currentTimeMillis();
        while (l > 0L) {
            if (System.currentTimeMillis() - l3 > 1000L) {
                this.out.println(string + ": " + (100L - 100L * l / l2) + "%");
                l3 = System.currentTimeMillis();
            }
            int n = (int)Math.min((long)byArray3.length, l);
            fileStore.readFully(byArray3, 0, n);
            fileStore2.write(byArray3, 0, n);
            l -= (long)n;
        }
        try {
            fileStore.close();
            fileStore2.close();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
        FileUtils.delete(string);
        FileUtils.rename(string2, string);
    }
}

