/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.awt.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel<G extends JComponent, L extends JComponent>
extends JLayeredPane {
    private static final Color BORDER_COLOR = DLightUIPrefs.getColor((String)"indicator.border.color");
    private static final int PADDING = DLightUIPrefs.getInt((String)"indicator.padding");
    private final G graph;
    private final L legend;
    private final JComponent hAxis;
    private final JComponent vAxis;
    private final JButton button;
    private List<Action> actions;
    private final JComponent graphPanel;
    private JComponent overlay;

    public GraphPanel(String string, G g, L l, JComponent jComponent, JComponent jComponent2, JButton jButton) {
        this.graph = g;
        this.legend = l;
        this.hAxis = jComponent;
        this.vAxis = jComponent2;
        this.button = jButton;
        this.graphPanel = GraphPanel.createGraphPanel(string, g, l, jComponent, jComponent2, jButton);
        this.graphPanel.addMouseListener(new PopupMenuListener());
        this.setOpaque(true);
        this.setMinimumSize(this.graphPanel.getMinimumSize());
        this.setPreferredSize(this.graphPanel.getPreferredSize());
        this.add((Component)this.graphPanel, (Object)0);
    }

    public void setPopupActions(List<Action> list) {
        this.actions = list;
    }

    @Override
    public void setToolTipText(String string) {
        this.graphPanel.setToolTipText(string);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.graphPanel.getToolTipText();
    }

    private static JPanel createGraphPanel(String string, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JButton jButton) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(DLightUIPrefs.getFont((String)"indicator.title.font"));
        jLabel.setForeground(DLightUIPrefs.getColor((String)"indicator.title.font.color"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.add((Component)jLabel, "Center");
        if (jButton != null) {
            jPanel2.add((Component)jButton, "East");
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(PADDING, PADDING, 0, PADDING);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (jComponent4 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(PADDING / 2, PADDING, jComponent3 == null ? PADDING : 0, 0);
            jPanel.add((Component)jComponent4, gridBagConstraints);
        }
        jComponent.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(PADDING / 2, jComponent4 == null ? PADDING : 0, jComponent3 == null ? PADDING : 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        jComponent2.setBackground(Color.WHITE);
        jComponent2.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(PADDING / 2, -1, jComponent3 == null ? PADDING : 0, PADDING);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        if (jComponent3 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = jComponent4 == null ? 0 : 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, jComponent4 == null ? PADDING : 0, PADDING, 0);
            jPanel.add((Component)jComponent3, gridBagConstraints);
        }
        return jPanel;
    }

    private JPopupMenu createPopupMenu() {
        if (this.actions == null || this.actions.isEmpty()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Action action : this.actions) {
            JMenuItem jMenuItem = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)action, (boolean)true);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    protected final G getGraph() {
        return this.graph;
    }

    protected final L getLegend() {
        return this.legend;
    }

    protected final JComponent getHorizontalAxis() {
        return this.hAxis;
    }

    protected final JComponent getVerticalAxis() {
        return this.vAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        this.graphPanel.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        GraphPanel graphPanel = this;
        synchronized (graphPanel) {
            if (this.overlay != null) {
                this.graphPanel.validate();
                Rectangle rectangle = ((Component)this.graph).getBounds();
                this.overlay.setBounds(insets.left + rectangle.x + PADDING / 2, insets.top + rectangle.y + PADDING / 2, rectangle.width - PADDING, rectangle.height - PADDING);
            }
        }
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        ((JComponent)this.graph).setEnabled(bl);
        ((JComponent)this.legend).setEnabled(bl);
        if (this.vAxis != null) {
            this.vAxis.setEnabled(bl);
        }
        if (this.hAxis != null) {
            this.hAxis.setEnabled(bl);
        }
        if (this.button != null) {
            this.button.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public final synchronized void setOverlay(JComponent jComponent) {
        if (this.overlay == jComponent) {
            return;
        }
        if (this.overlay != null) {
            this.remove(this.overlay);
        }
        if (jComponent != null) {
            this.add((Component)jComponent, (Object)1);
        }
        this.overlay = jComponent;
        this.revalidate();
        this.repaint();
    }

    private class PopupMenuListener
    extends MouseAdapter
    implements MouseListener {
        PopupMenuListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = GraphPanel.this.createPopupMenu()) != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

