/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CyclicArray<T> {
    private T[] data;
    private int last;
    private int size;

    public CyclicArray() {
        this(10);
    }

    public CyclicArray(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid initial capacity " + n);
        }
        this.data = new Object[n];
        this.last = -1;
        this.size = 0;
    }

    public boolean add(T t) {
        if (this.last < this.data.length - 1) {
            this.data[++this.last] = t;
            if (this.size < this.data.length) {
                ++this.size;
                return false;
            }
        } else {
            this.last = 0;
            this.data[0] = t;
        }
        return true;
    }

    public T get(int n) {
        return this.data[this.trandformIndex(n)];
    }

    public void set(int n, T t) {
        this.data[this.trandformIndex((int)n)] = t;
    }

    private final int trandformIndex(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("Invalid index " + n + "; size: " + this.size);
        }
        if (this.size < this.data.length) {
            return n;
        }
        int n2 = this.last + 1;
        if (n2 + n < this.data.length) {
            return n2 + n;
        }
        return n2 + n - this.data.length;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public void setCapacity(int n) {
        Object[] objectArray = new Object[n];
        int n2 = n < this.size ? this.size - n : 0;
        int n3 = 0;
        while (n2 < this.size()) {
            objectArray[n3++] = this.get(n2++);
        }
        this.data = objectArray;
        int n4 = this.last = this.size < this.data.length ? this.size - 1 : this.data.length - 1;
        if (this.size > this.data.length) {
            this.size = this.data.length;
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.data.length) {
            this.setCapacity(n);
        }
    }

    public static final <T> boolean areEqual(CyclicArray<T> cyclicArray, CyclicArray<T> cyclicArray2) {
        if (cyclicArray == null) {
            return cyclicArray2 == null;
        }
        if (cyclicArray2 == null) {
            return false;
        }
        if (cyclicArray.size() != cyclicArray2.size()) {
            return false;
        }
        for (int i = 0; i < cyclicArray.size(); ++i) {
            T t = cyclicArray.get(i);
            T t2 = cyclicArray2.get(i);
            if (t == null) {
                if (t2 == null) continue;
                return false;
            }
            if (t2 == null) {
                return false;
            }
            if (t.equals(t2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("CyclicArray capacity=%d size=%d last=%d data=[", this.data.length, this.size, this.last));
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.toString(this.data[i]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.toString(Array.get(object, i)));
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return object.toString();
    }
}

