/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.game.editor.tiledlayer.AnimatedTileListCellRenderer;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditorComponent;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileTransferable;

public class AnimatedTileList
extends JList {
    public static final boolean DEBUG = false;
    private TiledLayerEditorComponent editorComponent;
    private ImageResource imageResource;
    private AnimatedTileListDataModel model;

    public AnimatedTileList(TiledLayerEditorComponent tiledLayerEditorComponent) {
        this.editorComponent = tiledLayerEditorComponent;
        this.imageResource = this.editorComponent.getTiledLayer().getImageResource();
        this.model = new AnimatedTileListDataModel();
        this.init();
        this.imageResource.addImageResourceListener(this.model);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setCellRenderer(new AnimatedTileListCellRenderer());
        this.setMinimumSize(new Dimension(this.editorComponent.getTiledLayer().getTileWidth(), 20));
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AnimatedTileList.this.updatePaintTile();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AnimatedTileList.this.updatePaintTile();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AnimatedTileList.this.handlePopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AnimatedTileList.this.handlePopup(mouseEvent);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                AnimatedTile animatedTile;
                if (mouseEvent.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && (animatedTile = (AnimatedTile)AnimatedTileList.this.getSelectedValue()) != null) {
                    animatedTile.getImageResource().getGameDesign().getMainView().requestEditing(animatedTile);
                }
            }
        });
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, new DGL());
    }

    private void handlePopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n = this.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        this.setSelectedIndex(n);
        AnimatedTile animatedTile = (AnimatedTile)this.getModel().getElementAt(n);
        List<Action> list = animatedTile.getActions();
        for (Action action : list) {
            jPopupMenu.add(action);
        }
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private void updatePaintTile() {
        Tile tile = (Tile)this.getSelectedValue();
        if (tile == null) {
            return;
        }
        tile.getImageResource().getGameDesign().getMainView().requestPreview(tile);
        this.editorComponent.setPaintTileIndex(tile.getIndex());
    }

    private void init() {
        List<AnimatedTile> list = this.imageResource.getAnimatedTiles(this.editorComponent.getTiledLayer().getTileWidth(), this.editorComponent.getTiledLayer().getTileHeight());
        for (AnimatedTile animatedTile : list) {
            animatedTile.addSequenceContainerListener(this.model);
            this.model.addElement(animatedTile);
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private class AnimatedTileListDataModel
    extends DefaultListModel
    implements ImageResourceListener,
    SequenceContainerListener,
    PropertyChangeListener {
        private AnimatedTileListDataModel() {
        }

        public void addElement(Object object) {
            AnimatedTile animatedTile = (AnimatedTile)object;
            super.addElement(animatedTile);
            animatedTile.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = this.indexOf(propertyChangeEvent.getSource());
            if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
                this.fireContentsChanged(this, n, n);
            }
        }

        public void animatedTileAdded(ImageResource imageResource, AnimatedTile animatedTile) {
            if (animatedTile.getWidth() == AnimatedTileList.this.editorComponent.getTiledLayer().getTileWidth() && animatedTile.getHeight() == AnimatedTileList.this.editorComponent.getTiledLayer().getTileHeight()) {
                this.addElement(animatedTile);
                animatedTile.addSequenceContainerListener(this);
            }
        }

        public void animatedTileRemoved(ImageResource imageResource, AnimatedTile animatedTile) {
            animatedTile.removeSequenceContainerListener(this);
            this.removeElement(animatedTile);
        }

        public void sequenceAdded(ImageResource imageResource, Sequence sequence) {
        }

        public void sequenceRemoved(ImageResource imageResource, Sequence sequence) {
        }

        public void sequenceAdded(SequenceContainer sequenceContainer, Sequence sequence, int n) {
            int n2 = this.indexOf(sequenceContainer);
            this.fireContentsChanged(this, n2, n2);
        }

        public void sequenceRemoved(SequenceContainer sequenceContainer, Sequence sequence, int n) {
            int n2 = this.indexOf(sequenceContainer);
            this.fireContentsChanged(this, n2, n2);
        }

        public void sequenceMoved(SequenceContainer sequenceContainer, Sequence sequence, int n, int n2) {
            int n3 = this.indexOf(sequenceContainer);
            this.fireContentsChanged(this, n3, n3);
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = AnimatedTileList.this.locationToIndex(point);
            if (n == -1) {
                return;
            }
            Tile tile = (Tile)AnimatedTileList.this.getModel().getElementAt(n);
            TileTransferable tileTransferable = new TileTransferable();
            tileTransferable.getTiles().add(tile);
            dragGestureEvent.startDrag(null, tileTransferable, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            super.dragDropEnd(dragSourceDropEvent);
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

