/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.DecimalAxisUtils;
import org.netbeans.lib.profiler.charts.axis.LongMark;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalXYItemMarksComputer
extends XYItemMarksComputer {
    private double scale = -1.0;
    private long step = -1L;

    public DecimalXYItemMarksComputer(XYItem xYItem, XYItemPainter xYItemPainter, ChartContext chartContext, int n) {
        super(xYItem, xYItemPainter, chartContext, n);
    }

    @Override
    protected boolean refreshConfiguration() {
        double d = this.scale;
        this.scale = this.context.getViewWidth() == 0L ? -1.0 : this.painter.getItemValueScale(this.item, this.context);
        if (d != this.scale) {
            this.step = this.scale == -1.0 ? -1L : DecimalAxisUtils.getDecimalUnits(this.scale, this.getMinMarksDistance());
            d = this.scale;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int n, int n2) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long l = (long)this.painter.getItemValue(n, this.item, this.context) / this.step * this.step;
        long l2 = (long)this.painter.getItemValue(n2, this.item, this.context) / this.step * this.step;
        final long l3 = Math.abs(l2 - l) / this.step + 2L;
        final long[] lArray = new long[]{0L};
        return new AxisMarksComputer.AbstractIterator(){

            public boolean hasNext() {
                return lArray[0] < l3;
            }

            public AxisMark next() {
                long l2 = DecimalXYItemMarksComputer.this.reverse ? l - lArray[0] * DecimalXYItemMarksComputer.this.step : l + lArray[0] * DecimalXYItemMarksComputer.this.step;
                lArray[0] = lArray[0] + 1L;
                int n = Utils.checkedInt(DecimalXYItemMarksComputer.this.painter.getItemView(l2, DecimalXYItemMarksComputer.this.item, DecimalXYItemMarksComputer.this.context));
                return new LongMark(l2, n);
            }
        };
    }
}

