/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersListener;

public interface PaintersModel {
    public ItemPainter getPainter(ChartItem var1);

    public void addPaintersListener(PaintersListener var1);

    public void removePaintersListener(PaintersListener var1);

    public static class Default
    extends Abstract {
        private final Map<ChartItem, ItemPainter> painters = new HashMap<ChartItem, ItemPainter>();

        public Default() {
        }

        public Default(ChartItem[] chartItemArray, ItemPainter[] itemPainterArray) {
            this();
            if (chartItemArray == null) {
                throw new IllegalArgumentException("Items cannot be null");
            }
            if (itemPainterArray == null) {
                throw new IllegalArgumentException("Painters cannot be null");
            }
            if (chartItemArray.length != itemPainterArray.length) {
                throw new IllegalArgumentException("Items don't match painters");
            }
            this.addPainters(chartItemArray, itemPainterArray);
        }

        public void addPainters(ChartItem[] chartItemArray, ItemPainter[] itemPainterArray) {
            for (int i = 0; i < chartItemArray.length; ++i) {
                this.painters.put(chartItemArray[i], itemPainterArray[i]);
            }
        }

        public void removePainters(ChartItem[] chartItemArray) {
            for (int i = 0; i < chartItemArray.length; ++i) {
                this.painters.remove(chartItemArray[i]);
            }
        }

        public ItemPainter getPainter(ChartItem chartItem) {
            return this.painters.get(chartItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Abstract
    implements PaintersModel {
        private List<PaintersListener> listeners;

        @Override
        public void addPaintersListener(PaintersListener paintersListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<PaintersListener>();
            }
            if (!this.listeners.contains(paintersListener)) {
                this.listeners.add(paintersListener);
            }
        }

        @Override
        public void removePaintersListener(PaintersListener paintersListener) {
            if (this.listeners != null) {
                this.listeners.remove(paintersListener);
            }
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }

        protected void firePaintersChanged() {
            if (this.listeners != null) {
                for (PaintersListener paintersListener : this.listeners) {
                    paintersListener.paintersChanged();
                }
            }
        }

        protected void firePaintersChanged(List<ItemPainter> list) {
            if (this.listeners != null) {
                for (PaintersListener paintersListener : this.listeners) {
                    paintersListener.paintersChanged(list);
                }
            }
        }
    }
}

