/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDEditorOpened;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public class FoDFileSystem
extends MultiFileSystem
implements Runnable,
ChangeListener,
LookupListener {
    private static FoDFileSystem INSTANCE;
    private static final LayerCacheManager manager;
    static final Logger LOG;
    private static RequestProcessor RP;
    private RequestProcessor.Task refresh = RP.create((Runnable)this, true);
    private Lookup.Result<ProjectFactory> factories;
    private Lookup.Result<?> ants;
    private boolean forcedRefresh;

    public FoDFileSystem() {
        assert (INSTANCE == null);
        INSTANCE = this;
        this.setPropagateMasks(true);
        FeatureManager.getInstance().addChangeListener(this);
        try {
            FileSystem fileSystem = manager.loadCache();
            if (fileSystem != null) {
                LOG.fine("Using cached layer");
                this.setDelegates(new FileSystem[]{fileSystem});
                return;
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Cannot read cache", iOException);
        }
        this.refresh();
    }

    public static synchronized FoDFileSystem getInstance() {
        if (INSTANCE == null) {
            while (INSTANCE == null) {
                INSTANCE = (FoDFileSystem)Lookup.getDefault().lookup(FoDFileSystem.class);
            }
        }
        return INSTANCE;
    }

    public void refresh() {
        this.refresh.schedule(0);
        this.refresh.waitFinished();
    }

    public void refreshForce() {
        this.forcedRefresh = true;
        this.refresh.schedule(0);
        this.refresh.waitFinished();
    }

    public void waitFinished() {
        this.refresh.waitFinished();
    }

    public void run() {
        boolean bl = true;
        LOG.fine("collecting layers");
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(0, FoDFileSystem.class.getResource("common.xml"));
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent()) continue;
            LOG.finest("adding feature " + featureInfo.clusterName);
            if (featureInfo.getLayerURL() != null) {
                arrayList.add(featureInfo.getLayerURL());
            }
            if (!featureInfo.isEnabled()) continue;
            bl = false;
        }
        if (bl && this.noAdditionalProjects() && !FoDEditorOpened.anEditorIsOpened) {
            LOG.fine("adding default layer");
            arrayList.add(0, FoDFileSystem.class.getResource("default.xml"));
        }
        if (this.forcedRefresh) {
            this.forcedRefresh = false;
            LOG.log(Level.INFO, "Forced refresh. Setting delegates to empty");
            this.setDelegates(new FileSystem[0]);
            LOG.log(Level.INFO, "New delegates count: {0}", arrayList.size());
            LOG.log(Level.INFO, "{0}", arrayList);
        }
        LOG.log(Level.FINE, "delegating to {0} layers", arrayList.size());
        LOG.log(Level.FINEST, "{0}", arrayList);
        try {
            FileSystem fileSystem = this.getDelegates().length == 0 ? manager.createEmptyFileSystem() : this.getDelegates()[0];
            fileSystem = manager.store(fileSystem, arrayList);
            this.setDelegates(new FileSystem[]{fileSystem});
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Cannot save cache", iOException);
        }
        LOG.fine("done");
        FeatureManager.dumpModules();
    }

    public FeatureInfo whichProvides(FileObject fileObject) {
        String string = fileObject.getPath();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            FileSystem fileSystem = featureInfo.getXMLFileSystem();
            if (fileSystem.findResource(string) == null) continue;
            return featureInfo;
        }
        return null;
    }

    public URL getDelegateFileSystem(FileObject fileObject) {
        String string = fileObject.getPath();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            FileSystem fileSystem = featureInfo.getXMLFileSystem();
            if (fileSystem.findResource(string) == null) continue;
            return featureInfo.getLayerURL();
        }
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh.schedule(500);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refresh.schedule(0);
    }

    private boolean noAdditionalProjects() {
        if (this.factories == null) {
            this.factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
            this.factories.addLookupListener((LookupListener)this);
            this.ants = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            this.ants.addLookupListener((LookupListener)this);
        }
        for (ProjectFactory projectFactory : this.factories.allInstances()) {
            if (projectFactory.getClass().getName().contains("AntBasedProjectFactorySingleton") || projectFactory.getClass().getName().startsWith("org.netbeans.modules.ide.ergonomics")) continue;
            return false;
        }
        return this.ants.allItems().isEmpty();
    }

    static {
        manager = LayerCacheManager.create((String)"all-ergonomics.dat");
        LOG = Logger.getLogger(FoDFileSystem.class.getPackage().getName());
        RP = new RequestProcessor("Ergonomics");
    }
}

