/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.utils;

import java.util.NoSuchElementException;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class FieldTokenizer {
    private String[] retval = new String[2];
    private MyStringTokenizer tok;
    private int anon_count;

    public FieldTokenizer(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.tok = new MyStringTokenizer(string);
        this.anon_count = 0;
        this.retval[0] = null;
    }

    private void findNextField() {
        while (this.tok.hasMoreTokens()) {
            String string = this.tok.nextToken().trim();
            if (string.endsWith(")") || string.endsWith(") const")) continue;
            this.parseNextField(string);
            return;
        }
        if (this.anon_count > 0) {
            this.retval[0] = Integer.toString(this.anon_count);
            this.retval[1] = "<anon-count>";
            this.anon_count = 0;
        } else {
            this.retval[0] = null;
        }
    }

    private void parseNextField(String string) {
        boolean bl = true;
        string = string.replace("\\n", "").trim();
        while (bl) {
            bl = false;
            if (string.startsWith("static ")) {
                string = string.substring(7).trim();
                bl = true;
                continue;
            }
            if (string.startsWith("public: ")) {
                string = string.substring(8).trim();
                bl = true;
                continue;
            }
            if (string.startsWith("private: ")) {
                string = string.substring(9).trim();
                bl = true;
                continue;
            }
            if (string.startsWith("protected: ")) {
                string = string.substring(11).trim();
                bl = true;
                continue;
            }
            if (string.startsWith("virtual ")) {
                string = string.substring(8).trim();
                bl = true;
                continue;
            }
            if (string.startsWith("const ")) {
                string = string.substring(6).trim();
                bl = true;
                continue;
            }
            if (string.endsWith(" const")) {
                string = string.substring(0, string.length() - 6).trim();
                bl = true;
                continue;
            }
            if (!string.startsWith("\\n ")) continue;
            string = string.substring(2).trim();
            bl = true;
        }
        if (string.endsWith("}")) {
            this.retval[0] = string;
            this.retval[1] = "<anonymous" + ++this.anon_count + ">";
        } else {
            int n = string.lastIndexOf(32);
            if (n != -1) {
                int n2 = string.indexOf(42, n);
                if (n2 != -1) {
                    while (string.charAt(n2 + 1) == '*') {
                        ++n2;
                    }
                    this.retval[0] = string.substring(0, n2 + 1).trim();
                    this.retval[1] = string.substring(n2 + 1).trim();
                } else {
                    this.retval[0] = string.substring(0, n).trim();
                    this.retval[1] = string.substring(n).trim();
                }
            } else {
                this.retval[0] = "int";
                this.retval[1] = string;
            }
        }
    }

    public boolean hasMoreFields() {
        this.findNextField();
        return this.retval[0] != null || this.anon_count != 0;
    }

    public String[] nextField() {
        if (this.retval[0] == null) {
            throw new NoSuchElementException();
        }
        return this.retval;
    }

    private static final class MyStringTokenizer {
        private String info;
        private int start;
        private int end;

        public MyStringTokenizer(String string) {
            this.info = string;
            this.start = 0;
        }

        public boolean hasMoreTokens() {
            return this.start < this.info.length();
        }

        public String nextToken() {
            String string;
            if (this.start >= this.info.length()) {
                throw new NoSuchElementException();
            }
            this.end = GdbUtils.findNextSemi(this.info, this.start);
            if (this.end == -1) {
                string = this.info.substring(this.start);
                this.start = this.info.length();
            } else {
                string = this.info.substring(this.start, this.end);
                this.start = this.end + 1;
            }
            return string;
        }
    }
}

