/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private GdbDebugger debugger;
    private final Set<ModelListener> listeners = new HashSet<ModelListener>();
    private Listener listener;

    public ThreadsTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.debugger.getThreadsList();
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Set<ModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Set<ModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(modelListener);
            if (this.listeners.isEmpty()) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] objectArray;
        ModelEvent.TreeChanged treeChanged = this.listeners;
        synchronized (treeChanged) {
            objectArray = this.listeners.toArray();
        }
        treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged((ModelEvent)treeChanged);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private final GdbDebugger debugger;
        private final WeakReference<ThreadsTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(ThreadsTreeModel threadsTreeModel, GdbDebugger gdbDebugger) {
            this.debugger = gdbDebugger;
            this.model = new WeakReference<ThreadsTreeModel>(threadsTreeModel);
            gdbDebugger.addPropertyChangeListener(this);
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel threadsTreeModel = (ThreadsTreeModel)this.model.get();
            if (threadsTreeModel == null) {
                this.destroy();
            }
            return threadsTreeModel;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("state") && this.debugger.isStopped() || string.equals("currentThread")) {
                Listener listener = this;
                synchronized (listener) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                ThreadsTreeModel threadsTreeModel;
                if (Listener.this.debugger.isStopped() && (threadsTreeModel = Listener.this.getModel()) != null) {
                    threadsTreeModel.fireTreeChanged();
                }
            }
        }
    }
}

