/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsNodeModel
implements NodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private final Collection<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public ThreadsNodeModel(ContextProvider contextProvider) {
        GdbDebugger gdbDebugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        new Listener(this, gdbDebugger);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Name");
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_ThreadIsRunning");
        }
        if (object instanceof String) {
            String string = object.toString();
            if (string.startsWith("* ")) {
                return this.bold(string.substring(2));
            }
            return string;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Desc");
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_ThreadIsRunning");
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            String string = object.toString();
            if (string.charAt(0) == '*') {
                return CURRENT_THREAD;
            }
            return RUNNING_THREAD;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(null);
        }
    }

    private String bold(String string) {
        return ThreadsNodeModel.toHTML(string, true, false, null);
    }

    public static String toHTML(String string, boolean bl, boolean bl2, Color color) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (bl) {
            stringBuilder.append("<b>");
        }
        if (bl2) {
            stringBuilder.append("<i>");
        }
        if (color != null) {
            stringBuilder.append("<font color=");
            stringBuilder.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
            stringBuilder.append(">");
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        stringBuilder.append(string);
        if (color != null) {
            stringBuilder.append("</font>");
        }
        if (bl2) {
            stringBuilder.append("</i>");
        }
        if (bl) {
            stringBuilder.append("</b>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static class Listener
    implements PropertyChangeListener {
        private final WeakReference<ThreadsNodeModel> ref;
        private final GdbDebugger debugger;

        private Listener(ThreadsNodeModel threadsNodeModel, GdbDebugger gdbDebugger) {
            this.ref = new WeakReference<ThreadsNodeModel>(threadsNodeModel);
            this.debugger = gdbDebugger;
            gdbDebugger.addPropertyChangeListener("currentCallStackFrame", this);
        }

        private ThreadsNodeModel getModel() {
            ThreadsNodeModel threadsNodeModel = (ThreadsNodeModel)this.ref.get();
            if (threadsNodeModel == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", this);
            }
            return threadsNodeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadsNodeModel threadsNodeModel = this.getModel();
            if (threadsNodeModel == null) {
                return;
            }
            threadsNodeModel.fireTreeChanged();
        }
    }
}

