/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSetUtils;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointEvent;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.utils.IOProxy;
import org.netbeans.modules.cnd.debugger.common.utils.PathUtils;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbEngineProvider;
import org.netbeans.modules.cnd.debugger.gdb.GdbErrorException;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.GdbVersionPeculiarity;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.netbeans.modules.cnd.debugger.gdb.TypeInfo;
import org.netbeans.modules.cnd.debugger.gdb.actions.GdbActionHandler;
import org.netbeans.modules.cnd.debugger.gdb.attach.AttachTarget;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbDebugger
implements PropertyChangeListener {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_KILLTERM = "killTerm";
    public static final String PROP_SHARED_LIB_LOADED = "sharedLibLoaded";
    public static final String PROP_VALUE_CHANGED = "valueChanged";
    public static final String PROP_LOCALS_REFRESH = "localsRefresh";
    public static final String DONE_PREFIX = "^done";
    public static final String RUNNING_PREFIX = "^running";
    public static final String CONNECTED_PREFIX = "^connected";
    private LastGoState lastGo;
    private String lastStop;
    private static final ProjectActionEvent.Type DEBUG_ATTACH = ProjectActionEvent.Type.CHECK_EXECUTABLE;
    public static final String ENGINE_ID = "netbeans-cnd-GdbSession/C";
    public static final String SESSION_ID = "netbeans-cnd-GdbSession";
    public static final String SESSION_PROVIDER_ID = "netbeans-cnd-GdbSessionProvider";
    public static final String DIS_UPDATE = "dis_update";
    private static final String MSG_BREAKPOINT_ERROR = "Cannot insert breakpoint";
    private GdbProxy gdb;
    private final ContextProvider lookupProvider;
    protected State state = State.NONE;
    private final PropertyChangeSupport pcs;
    private String runDirectory;
    private String baseDir;
    private final List<GdbCallStackFrame> callstack = Collections.synchronizedList(new ArrayList());
    private final GdbEngineProvider gdbEngineProvider;
    private GdbCallStackFrame currentCallStackFrame;
    public final Object LOCK = new Object();
    private long programPID = 0L;
    private double gdbVersion = 6.4;
    private boolean continueAfterFirstStop = true;
    private final List<GdbVariable> localVariables = new ArrayList<GdbVariable>();
    private final Map<Integer, BreakpointImpl<?>> pendingBreakpointMap = new HashMap();
    private final Map<Integer, BreakpointImpl<?>> breakpointList = Collections.synchronizedMap(new HashMap());
    private final List<String> temporaryBreakpoints = new ArrayList<String>();
    private final Set<Integer> runAfterTokens = Collections.synchronizedSet(new HashSet());
    private static final Map<String, TypeInfo> ticache = new HashMap<String, TypeInfo>();
    private static final Logger log = Logger.getLogger("gdb.logger");
    private static final Logger tlog = Logger.getLogger("gdb.testlogger");
    private int currentToken = 0;
    private String currentThreadID = "1";
    private static final String[] emptyThreadsList = new String[0];
    private String[] threadsList = emptyThreadsList;
    private Timer startupTimer = null;
    private boolean cygwin = false;
    private boolean mingw = false;
    private boolean cplusplus = false;
    private String firstBPfullname;
    private String firstBPfile;
    private String firstBPline;
    private InputOutput iotab;
    private boolean firstOutput = true;
    private boolean dlopenPending = false;
    private int shareToken;
    private final Disassembly disassembly;
    private CndBreakpoint currentBreakpoint = null;
    private ExecutionEnvironment execEnv;
    private int platform;
    private PathMap pathMap;
    private Map<String, ShareInfo> shareTab;
    private String sig = null;
    private IOProxy ioProxy = null;
    private GdbVersionPeculiarity versionPeculiarity = null;
    private boolean core = false;
    private boolean skipSignal = false;
    private final Object finishLock = new String("GDB debugger finish lock");
    private static final String CONSOLE_MSG_END = "\\n";
    private static final String KILL_PATH1 = "/usr/bin/kill";
    private static final String KILL_PATH2 = "/bin/kill";
    private LineBreakpoint rtcBreakpoint = null;
    private static final String VALUE_PREFIX = "value=";
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset", "UTF-8");

    public GdbDebugger(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.addPropertyChangeListener(this);
        GdbEngineProvider gdbEngineProvider = null;
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        for (DebuggerEngineProvider debuggerEngineProvider : list) {
            if (!(debuggerEngineProvider instanceof GdbEngineProvider)) continue;
            gdbEngineProvider = (GdbEngineProvider)debuggerEngineProvider;
        }
        if (gdbEngineProvider == null && !GdbDebugger.isUnitTest()) {
            throw new IllegalArgumentException("GdbEngineProvider must be used to start GdbDebugger!");
        }
        this.gdbEngineProvider = gdbEngineProvider;
        this.threadsViewInit();
        this.disassembly = new Disassembly(this);
        this.shareTab = null;
        this.execEnv = ExecutionEnvironmentFactory.getLocal();
    }

    public ContextProvider getLookup() {
        return this.lookupProvider;
    }

    public void startDebugger() {
        block55: {
            String string = null;
            GdbTimer.getTimer("Startup").start("Startup1");
            GdbTimer.getTimer("Stop").start("Stop1");
            this.setStarting();
            try {
                String string2;
                Object object2;
                String string3;
                ProjectActionEvent projectActionEvent = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
                this.execEnv = projectActionEvent.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv);
                this.iotab = (InputOutput)this.lookupProvider.lookupFirst(null, InputOutput.class);
                if (this.iotab != null) {
                    this.iotab.setErrSeparated(false);
                }
                this.runDirectory = this.pathMap.getRemotePath(projectActionEvent.getProfile().getRunDirectory().replace("\\", "/") + "/", true);
                this.baseDir = projectActionEvent.getConfiguration().getBaseDir().replace("\\", "/");
                GdbProfile gdbProfile = (GdbProfile)projectActionEvent.getConfiguration().getAuxObject("gdbdebugger");
                int n = this.execEnv.isLocal() ? projectActionEvent.getProfile().getConsoleType().getValue() : 2;
                this.platform = HostInfoProvider.getPlatform((ExecutionEnvironment)this.execEnv);
                if (this.platform != 3 && n != 2 && projectActionEvent.getType() != DEBUG_ATTACH) {
                    string = projectActionEvent.getProfile().getTerminalPath();
                }
                if (!Boolean.getBoolean("gdb.suppress.timeout")) {
                    this.startupTimer = new Timer("GDB Startup Timer Thread");
                    this.startupTimer.schedule(new TimerTask(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_StartupTimeout")));
                            GdbDebugger.this.finish(true);
                        }
                    }, 30000L);
                }
                if ((string3 = gdbProfile.getGdbPath(projectActionEvent.getConfiguration(), false)) == null) {
                    throw new GdbErrorException("Gdb command is empty, exiting");
                }
                if (string3.toLowerCase().contains("cygwin")) {
                    this.cygwin = true;
                } else if (string3.toLowerCase().contains("mingw")) {
                    this.mingw = true;
                }
                String string4 = this.getCompilerSetPath(projectActionEvent);
                String[] stringArray = new String[]{};
                if (this.platform == 3) {
                    stringArray = projectActionEvent.getProfile().getEnvironment().getenv();
                }
                this.gdb = new GdbProxy(this, string3, stringArray, this.runDirectory, string, string4);
                this.initGdbVersion();
                this.checkGdbVersion();
                this.gdb.environment_directory(this.runDirectory);
                this.gdb.gdb_show("language");
                this.gdb.gdb_set("print repeat", Integer.toString(CppSettings.getDefault().getArrayRepeatThreshold()));
                if (projectActionEvent.getType() == DEBUG_ATTACH) {
                    String string5 = null;
                    boolean bl = false;
                    String string6 = this.getFullPath(this.baseDir, projectActionEvent.getExecutable());
                    this.gdb.getLogger().logMessage("IDE: project executable: " + string6);
                    AttachTarget attachTarget = (AttachTarget)this.lookupProvider.lookupFirst(null, AttachTarget.class);
                    if (attachTarget == null) {
                        throw new IllegalStateException("No AttachTarget during attach");
                    }
                    if (attachTarget instanceof AttachTarget.PidAttach) {
                        this.programPID = ((AttachTarget.PidAttach)attachTarget).pid;
                    } else if (attachTarget instanceof AttachTarget.CoreAttach) {
                        this.core = true;
                        this.continueAfterFirstStop = false;
                    } else if (!(attachTarget instanceof AttachTarget.GdbServerAttach)) {
                        throw new IllegalStateException("Unknown attach target " + attachTarget);
                    }
                    if (projectActionEvent.getConfiguration().isDynamicLibraryConfiguration()) {
                        if (this.platform != 3) {
                            string5 = PathUtils.getExePath((long)this.programPID, (ExecutionEnvironment)this.execEnv);
                            this.gdb.file_exec_and_symbols(string5);
                        }
                        bl = true;
                    } else {
                        this.gdb.file_symbol_file(string6);
                    }
                    CommandBuffer commandBuffer = this.getAttachCommand(attachTarget);
                    String string7 = commandBuffer.getError();
                    if (string7 != null || commandBuffer.isTimedOut()) {
                        String string8 = string7 == null ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachTimeout") : (string7.toLowerCase().contains("no such process") || string7.toLowerCase().contains("couldn't open /proc file for process ") ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSuchProcess") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach"));
                        this.warn(true, string8);
                        return;
                    }
                    String string9 = commandBuffer.getResponse();
                    if (this.platform == 3 && string9.startsWith("Attaching to process")) {
                        try {
                            long l = this.programPID;
                            int n2 = string9.indexOf(CONSOLE_MSG_END);
                            this.programPID = Long.parseLong(string9.substring(21, n2).trim());
                            if (this.programPID != l) {
                                log.info("Pid changed from " + l + " to " + this.programPID);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        if (this.platform == 4 && string5 == null) {
                            string5 = this.getMacExePath();
                        }
                        if (string5 != null) {
                            this.gdb.file_symbol_file(string5);
                        }
                    }
                    if (!this.symbolsRead(string9, string6)) {
                        if (!this.core && this.validAttachViaSlashProc(this.programPID, string6)) {
                            if (this.isSolaris()) {
                                this.gdb.file_symbol_file(string6);
                            }
                        } else if (bl && this.platform == 4) {
                            String string10 = this.getMacDylibAddress(string6, this.gdb.info_share(true).getResponse());
                            if (string10 != null) {
                                this.gdb.addSymbolFile(string6, string10);
                            } else {
                                this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure"));
                            }
                        } else if (!this.symbolsReadFromInfoFiles(this.gdb.info_files().getResponse(), string6)) {
                            this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure"));
                        }
                    }
                    this.gdb.up_silently(1024);
                    this.setLoading();
                    break block55;
                }
                this.gdb.file_exec_and_symbols(this.pathMap.getRemotePath(projectActionEvent.getExecutable().replace("\\", "/"), true));
                MacroMap macroMap = MacroMap.forExecEnv((ExecutionEnvironment)this.execEnv);
                macroMap.putAll(projectActionEvent.getProfile().getEnvironment().getenvAsMap());
                if (n == 2) {
                    UnbufferSupport.initUnbuffer((ExecutionEnvironment)this.execEnv, (MacroMap)macroMap);
                    if (this.platform != 3 && !GdbDebugger.isUnitTest()) {
                        this.ioProxy = IOProxy.create((ExecutionEnvironment)this.execEnv, (InputOutput)this.iotab);
                    }
                }
                for (Object object2 : macroMap.entrySet()) {
                    this.gdb.gdb_set("environment", (String)object2.getKey() + '=' + (String)object2.getValue());
                }
                if (this.platform == 3 && n != 2) {
                    this.gdb.set_new_console();
                }
                if (projectActionEvent.getType() == ProjectActionEvent.Type.DEBUG_STEPINTO) {
                    this.continueAfterFirstStop = false;
                }
                this.gdb.break_insert_temporary("main");
                if (this.platform == 3) {
                    this.gdb.break_insert_temporary("WinMain");
                }
                Object object3 = "";
                if (this.ioProxy != null) {
                    String string11;
                    object2 = this.ioProxy.getInFilename();
                    string2 = this.ioProxy.getOutFilename();
                    if (this.platform == 3) {
                        object2 = this.win2UnixPath((String)object2);
                        string2 = this.win2UnixPath(string2);
                    }
                    object3 = this.platform == 4 ? " < " + (String)object2 + " > " + string2 + " 2> " + string2 : ((string11 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)this.execEnv).get("SHELL")) != null && string11.endsWith("csh") ? " < " + (String)object2 + " >& " + string2 : " < " + (String)object2 + " > " + string2 + " 2>&1");
                }
                if (((CommandBuffer)(object2 = this.gdb.exec_run(projectActionEvent.getProfile().getArgsFlat() + (String)object3))).isError()) {
                    throw new Exception(NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ApplicationFailed"));
                }
                if (this.platform == 3) {
                    int n3;
                    string2 = this.gdb.info_threads().getResponse();
                    int n4 = string2.indexOf("* 1 thread ");
                    if (n4 >= 0 && (n3 = string2.indexOf(46, n4)) > 0) {
                        try {
                            this.programPID = Long.valueOf(string2.substring(n4 + 11, n3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (this.platform != 4) {
                    this.gdb.info_proc();
                }
            }
            catch (Exception exception) {
                String string12;
                log.log(Level.INFO, "GdbDebugger.startDebugger: Exception during start: ", exception);
                if (this.startupTimer != null) {
                    this.startupTimer.cancel();
                }
                if ((string12 = exception.getLocalizedMessage()) == null || string12.length() == 0) {
                    string12 = exception.getMessage();
                }
                if (string12 == null || string12.length() == 0) {
                    string12 = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnSpecifiedStartError");
                }
                this.warn(true, string12);
            }
        }
    }

    private CommandBuffer getAttachCommand(AttachTarget attachTarget) {
        if (attachTarget instanceof AttachTarget.CoreAttach) {
            return this.gdb.core(((AttachTarget.CoreAttach)attachTarget).path);
        }
        if (attachTarget instanceof AttachTarget.PidAttach) {
            return this.gdb.attach(Long.toString(((AttachTarget.PidAttach)attachTarget).pid));
        }
        if (attachTarget instanceof AttachTarget.GdbServerAttach) {
            return this.gdb.attachRemote(((AttachTarget.GdbServerAttach)attachTarget).target);
        }
        throw new IllegalStateException("Unknown attach target " + attachTarget);
    }

    private void warn(final boolean bl, final String string) {
        log.warning(string);
        if (!GdbDebugger.isUnitTest()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
                    if (bl) {
                        GdbDebugger.this.finish(false);
                    }
                }
            });
        } else {
            tlog.warning(string);
        }
    }

    private final void initGdbVersion() throws GdbErrorException {
        CommandBuffer commandBuffer = this.gdb.gdb_version();
        if (commandBuffer.isOK()) {
            String string = commandBuffer.getResponse();
            if (this.startupTimer != null) {
                this.startupTimer.cancel();
                this.startupTimer = null;
            }
            this.gdbVersion = this.parseVersionString(string);
            this.versionPeculiarity = GdbVersionPeculiarity.create(this.gdbVersion, this.platform);
            if (string.contains("cygwin")) {
                this.cygwin = true;
            }
        } else {
            throw new GdbErrorException("gdb version check failed, exiting");
        }
    }

    private double parseVersionString(String string) {
        double d = 0.0;
        try {
            d = GdbUtils.parseVersionString(string);
        }
        catch (Exception exception) {
            log.warning("GdbDebugger: Failed to parse version string (" + string + ") [" + exception.getClass().getName() + "]");
            if (string.contains("6.5")) {
                d = 6.5;
            } else if (string.contains("6.6")) {
                d = 6.6;
            } else if (string.contains("6.7")) {
                d = 6.7;
            } else if (string.contains("6.8")) {
                d = 6.8;
            } else if (string.contains("7.0")) {
                d = 7.0;
            } else {
                log.warning("GdbDebugger: Failed to guess version string");
            }
            log.warning("GdbDebugger: guessed version: " + d);
        }
        return d;
    }

    private final void checkGdbVersion() {
        if (!this.versionPeculiarity.isSupported()) {
            this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnsupportedVersion", (Object)this.gdbVersion));
        }
    }

    public double getGdbVersion() {
        return this.gdbVersion;
    }

    public void testSuiteInit(GdbProxy gdbProxy) throws GdbErrorException {
        if (!GdbDebugger.isUnitTest()) {
            throw new IllegalStateException(NbBundle.getMessage(GdbDebugger.class, (String)"Cannot call testSuiteInit outside of a testsuite!"));
        }
        log.setLevel(Level.OFF);
        tlog.setLevel(Level.FINE);
        this.gdb = gdbProxy;
        this.initGdbVersion();
        this.execEnv = ExecutionEnvironmentFactory.getLocal();
        this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv);
    }

    public static boolean isUnitTest() {
        return System.getProperty("gdb.testsuite") != null;
    }

    public String win2UnixPath(String string) {
        if (this.isCygwin()) {
            return WindowsSupport.getInstance().convertToCygwinPath(string);
        }
        if (this.isMinGW()) {
            return WindowsSupport.getInstance().convertToMSysPath(string);
        }
        return string.replace('\\', '/');
    }

    public ExecutionEnvironment getHostExecutionEnvironment() {
        return this.execEnv;
    }

    public int getPlatform() {
        return this.platform;
    }

    public PathMap getPathMap() {
        return this.pathMap;
    }

    public static GdbDebugger getGdbDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (GdbDebugger)debuggerEngine.lookupFirst(null, GdbDebugger.class);
    }

    private String getCompilerSetPath(ProjectActionEvent projectActionEvent) {
        String string;
        CompilerSet2Configuration compilerSet2Configuration = projectActionEvent.getConfiguration().getCompilerSet();
        String string2 = compilerSet2Configuration.getOption();
        String string3 = compilerSet2Configuration.getCompilerSetManager().getCompilerSet(string2).getDirectory();
        if (compilerSet2Configuration.getCompilerSetManager().getCompilerSet(string2).getCompilerFlavor().isMinGWCompiler() && (string = CompilerSetUtils.getMSysBase()) != null && string.length() > 0) {
            string3 = string3 + File.pathSeparator + string + "/bin";
        }
        return string3;
    }

    public String getSignal() {
        return this.sig;
    }

    public GdbVersionPeculiarity getVersionPeculiarity() {
        return this.versionPeculiarity;
    }

    private String getFullPath(String string, String string2) {
        if (this.platform == 3 && Character.isLetter(string2.charAt(0)) && string2.charAt(1) == ':') {
            return string2;
        }
        if (string2.charAt(0) == '/') {
            return string2;
        }
        return string + '/' + string2;
    }

    public void showCurrentSource(boolean bl) {
        final GdbCallStackFrame gdbCallStackFrame = this.getCurrentCallStackFrame();
        if (gdbCallStackFrame == null) {
            return;
        }
        if (!bl) {
            bl = this.currentBreakpoint == null ? Disassembly.isInDisasm() : this.currentBreakpoint instanceof AddressBreakpoint;
        }
        final boolean bl2 = bl;
        if (!GdbDebugger.isUnitTest()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorContextBridge.showSource((CallStackFrame)gdbCallStackFrame, (boolean)bl2);
                }
            });
        }
    }

    public String[] getThreadsList() {
        if (this.state == State.STOPPED) {
            if (this.threadsList == emptyThreadsList) {
                while (this.gdb == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                String string = this.gdb.info_threads().getResponse();
                if (string.length() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string.startsWith("threadno")) {
                        for (String string2 : string.split("threadn")) {
                            Map<String, String> map = this.createMapFromString(string2);
                            if (map.isEmpty()) continue;
                            arrayList.add(map.get("o") + " " + map.get("target_tid"));
                        }
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String string3 : string.split("\\\\n")) {
                            char c;
                            if (string3.startsWith("    ")) {
                                stringBuilder.append(" " + string3.replace(CONSOLE_MSG_END, "").trim());
                                continue;
                            }
                            if (stringBuilder.length() > 0) {
                                arrayList.add(stringBuilder.toString());
                                stringBuilder.delete(0, stringBuilder.length());
                            }
                            if ((c = (string3 = string3.trim()).charAt(0)) != '*' && !Character.isDigit(c)) continue;
                            stringBuilder.append(string3);
                        }
                        if (stringBuilder.length() > 0) {
                            arrayList.add(stringBuilder.toString());
                        }
                    }
                    this.threadsList = arrayList.toArray(new String[arrayList.size()]);
                    return this.threadsList;
                }
            }
        } else {
            return new String[]{NbBundle.getMessage(GdbDebugger.class, (String)"CTL_NoThreadInfoWhileRunning")};
        }
        return this.threadsList;
    }

    private void resetThreadInfo() {
        this.threadsList = emptyThreadsList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(PROP_STATE)) {
            if (propertyChangeEvent.getNewValue() == State.LOADING) {
                this.shareToken = this.gdb.info_share(false).getID();
            } else if (propertyChangeEvent.getNewValue() == State.READY) {
                this.gdb.data_list_register_names("");
                if (this.platform == 3) {
                    this.gdb.break_insert("dlopen");
                } else {
                    this.setStopOnSolibEvents(true);
                }
                if (this.continueAfterFirstStop) {
                    this.continueAfterFirstStop = false;
                    this.setRunning();
                } else {
                    this.gdb.stack_list_frames();
                    this.setStopped();
                }
            } else if (propertyChangeEvent.getNewValue() == State.STOPPED) {
                this.updateLocalVariables(0);
                GdbContext.getInstance().gdbStep();
            } else if (propertyChangeEvent.getNewValue() == State.SILENT_STOP) {
                this.interrupt();
            } else if (propertyChangeEvent.getNewValue() == State.RUNNING && (propertyChangeEvent.getOldValue() == State.SILENT_STOP || propertyChangeEvent.getOldValue() == State.READY)) {
                this.gdb.exec_continue();
            } else if (propertyChangeEvent.getNewValue() == State.EXITED) {
                this.finish(false);
            }
        } else if (propertyChangeEvent.getPropertyName().equals(PROP_CURRENT_THREAD)) {
            this.updateCurrentCallStack();
            this.updateLocalVariables(0);
            GdbContext.getInstance().gdbStep();
        }
    }

    private boolean symbolsRead(String string, String string2) {
        for (String string3 : string.split("\\\\n")) {
            if (!(string3.contains("Reading symbols from ") || this.platform == 4 && string3.contains("Symbols from ") ? this.compareExePaths(string3 = string3.substring(21, string3.length() - 8), string2) : string3.contains("Loaded symbols for ") && this.comparePaths(string2, string3.substring(19)))) continue;
            return true;
        }
        return false;
    }

    public boolean comparePaths(String string, String string2) {
        if ((string = string.trim()).equals(string2 = string2.trim())) {
            return true;
        }
        if (this.platform == 3) {
            if ((string = string.toLowerCase()).equals(string2 = string2.toLowerCase())) {
                return true;
            }
            if (this.cygwin) {
                string = WindowsSupport.getInstance().convertToCygwinPath(string).toLowerCase();
                string2 = WindowsSupport.getInstance().convertToCygwinPath(string2).toLowerCase();
            } else if (this.mingw) {
                string = WindowsSupport.getInstance().convertToMSysPath(string).toLowerCase();
                string2 = WindowsSupport.getInstance().convertToMSysPath(string2).toLowerCase();
            }
            if (string.equals(string2)) {
                return true;
            }
        }
        return GdbUtils.compareUnixPaths(string, string2);
    }

    private boolean compareExePaths(String string, String string2) {
        if ((string = string.trim()).equals(string2 = string2.trim())) {
            return true;
        }
        if (this.platform == 3) {
            string = GdbUtils.removeExe(string);
            string2 = GdbUtils.removeExe(string2);
        } else if (this.platform == 4) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return this.comparePaths(string, string2);
    }

    private boolean symbolsReadFromInfoFiles(String string, String string2) {
        for (String string3 : string.split("\\\\n")) {
            if (!string3.contains("Symbols from ")) continue;
            return this.compareExePaths(string3.substring(15, string3.length() - 3), string2);
        }
        return false;
    }

    private boolean validAttachViaSlashProc(long l, String string) {
        String string2;
        if (this.platform != 3 && (string2 = PathUtils.getExePath((long)l, (ExecutionEnvironment)this.execEnv)) != null) {
            File file = new File(string);
            try {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)string) && this.comparePaths(string2, file.getAbsolutePath())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    private String getMacExePath() {
        String string = this.gdb.info_files().getResponse();
        for (String string2 : string.split("\\\\n")) {
            if (!string2.contains("Symbols from ")) continue;
            return string2.substring(15, string2.length() - 3);
        }
        return null;
    }

    private String getMacDylibAddress(String string, String string2) {
        String string3;
        int n = string2.startsWith("shlib-info=") ? 11 : 0;
        int n2 = string2.indexOf(",shlib-info=");
        while ((string3 = string2.substring(n, n2 > 0 ? n2 : string2.length())) != null) {
            if (string3.contains(string)) {
                return GdbDebugger.parseMacDylibAddress(string3, this.getCharSetEncoding());
            }
            n = n2 + 12;
            n2 = string2.indexOf(",shlib-info=", n);
        }
        return null;
    }

    private static String parseMacDylibAddress(String string, String string2) {
        Map<String, String> map;
        int n = GdbUtils.findMatchingCurly(string, 0);
        if (n != -1 && (map = GdbUtils.createMapFromString(string.substring(1, n), string2)).containsKey("loaded_addr")) {
            return map.get("loaded_addr");
        }
        return null;
    }

    public GdbProxy getGdbProxy() {
        return this.gdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean bl) {
        Object object = this.finishLock;
        synchronized (object) {
            if (GdbDebugger.isUnitTest()) {
                this.setExited();
            } else if (this.state != State.NONE && this.state != State.EXITED) {
                Object object2;
                if (bl) {
                    this.firePropertyChange(PROP_KILLTERM, true, false);
                }
                if (this.gdb != null) {
                    object2 = ((ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class)).getType();
                    if (this.state == State.RUNNING) {
                        this.gdb.exec_interrupt();
                        if (object2 != DEBUG_ATTACH) {
                            this.gdb.exec_abort();
                        }
                    }
                    if (object2 == DEBUG_ATTACH) {
                        this.gdb.target_detach();
                    }
                    this.gdb.gdb_exit();
                    this.gdb.getProxyEngine().finish();
                }
                this.stackUpdate(new ArrayList<String>());
                this.setExited();
                this.programPID = 0L;
                this.removeRTCBreakpoint();
                this.gdbEngineProvider.getDestructor().killEngine();
                object2 = (GdbActionHandler)((Object)this.lookupProvider.lookupFirst(null, GdbActionHandler.class));
                if (object2 != null) {
                    object2.executionFinished(0);
                }
                Disassembly.close();
                if (this.ioProxy != null) {
                    this.ioProxy.stop();
                }
                if (this.iotab != null) {
                    this.iotab.getOut().close();
                }
                GdbContext.getInstance().gdbExit();
                GdbTimer.getTimer("Step").reset();
            }
        }
    }

    private void finish_from_main() {
        this.gdb.break_insert_temporary("exit");
        this.gdb.exec_continue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalVariables(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            List<GdbVariable> list = this.localVariables;
            synchronized (list) {
                this.localVariables.clear();
            }
            this.gdb.stack_select_frame(n);
            this.gdb.stack_list_arguments(1);
            this.gdb.stack_list_locals("--all-values");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGdbVariable(String string, String string2) {
        List<GdbVariable> list = this.localVariables;
        synchronized (list) {
            for (GdbVariable gdbVariable : this.localVariables) {
                if (!string.equals(gdbVariable.getName())) continue;
                gdbVariable.setValue(string2);
            }
        }
    }

    public void fireLocalsRefresh(Object object) {
        this.firePropertyChange(PROP_LOCALS_REFRESH, 0, object);
    }

    private void updateCurrentCallStack() {
        this.gdb.stack_list_frames();
    }

    public void addRunAfterToken(int n) {
        this.runAfterTokens.add(n);
    }

    public void resultRecord(int n, String string) {
        Object object;
        this.currentToken = n + 1;
        if ((string.startsWith(DONE_PREFIX) || string.startsWith(RUNNING_PREFIX) || string.startsWith(CONNECTED_PREFIX)) && (object = this.gdb.getCommandBuffer(n)) != null) {
            if (string.length() > DONE_PREFIX.length()) {
                ((CommandBuffer)object).append(string.substring(DONE_PREFIX.length() + 1));
            }
            ((CommandBuffer)object).done();
        }
        if (string.startsWith(DONE_PREFIX)) {
            if (string.startsWith("^done,bkpt=")) {
                string = string.substring(12, string.length() - 1);
                object = this.createMapFromString(string);
                this.validateBreakpoint(n, (Map<String, String>)object);
            } else if (string.startsWith("^done,stack=")) {
                if (this.state == State.STOPPED) {
                    this.stackUpdate(this.createListFromString(string.substring(13, string.length() - 1)));
                }
            } else if (string.startsWith("^done,locals=")) {
                if (this.state == State.STOPPED) {
                    this.addLocalsToLocalVariables(string.substring(13));
                } else {
                    log.finest("GD.resultRecord: Skipping results from -stack-list-locals (not stopped)");
                }
            } else if (string.startsWith("^done,stack-args=")) {
                if (this.state == State.STOPPED) {
                    this.addArgsToLocalVariables(string.substring(17));
                } else {
                    log.finest("GD.resultRecord: Skipping results from -stack-list-arguments (not stopped)");
                }
            } else if (string.startsWith("^done,new-thread-id=")) {
                object = string.substring(21, string.indexOf(34, 22));
                if (!((String)object).equals(this.currentThreadID)) {
                    String string2 = this.currentThreadID;
                    this.currentThreadID = object;
                    log.finest("GD.resultRecord: Thread change, firing PROP_CURRENT_THREAD");
                    this.firePropertyChange(PROP_CURRENT_THREAD, string2, this.currentThreadID);
                }
            } else if (string.startsWith("^done,value=") && string.contains("auto; currently c")) {
                if (string.contains("auto; currently c++")) {
                    this.cplusplus = true;
                    DebuggerManager.getDebuggerManager().getCurrentSession().setCurrentLanguage("C++");
                }
            } else if (string.startsWith("^done,asm_insns=")) {
                this.disassembly.update(string);
            } else if (string.startsWith("^done,register-names=")) {
                this.disassembly.updateRegNames(string);
            } else if (string.startsWith("^done,register-values=")) {
                this.disassembly.updateRegValues(string);
            } else if (string.startsWith("^done,changed-registers=")) {
                this.disassembly.updateRegModified(string);
                GdbContext.getInstance().setProperty("Registers", this.disassembly.getRegisterValues());
            } else {
                object = this.gdb.getCommandBuffer(n);
                if (object != null) {
                    if (n == this.shareToken) {
                        this.shareTab = this.createShareTab(((CommandBuffer)object).getResponse());
                    }
                } else if (this.pendingBreakpointMap.containsKey(n)) {
                    this.breakpointValidation(n, null);
                }
            }
            if (this.runAfterTokens.remove(n) && this.runAfterTokens.isEmpty() && this.state == State.SILENT_STOP) {
                this.setRunning();
            }
        } else if (string.startsWith(RUNNING_PREFIX) && this.isStopped()) {
            this.setRunning();
        } else if (string.startsWith("^error,msg=")) {
            string = string.substring(11);
            object = this.gdb.getCommandBuffer(n);
            if (object != null) {
                ((CommandBuffer)object).error(string);
            } else if (string.equals("\"Can't attach to process.\"")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach")));
                this.killSession();
            } else if (string.startsWith("\"No symbol ") && string.endsWith(" in current context.\"")) {
                String string3 = string.substring(13, string.length() - 23);
                log.warning("Failed type lookup for " + string3);
            } else if (string.equals("\"\\\"finish\\\" not meaningful in the outermost frame.\"")) {
                this.finish_from_main();
            } else if (string.contains("(corrupt stack?)") && this.gdbVersion > 6.3) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CorruptedStack")));
                this.killSession();
            } else if (string.contains("error reading line numbers")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantReadLineNumbers")));
            } else if (string.contains("No symbol table is loaded")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSymbolTable")));
                this.killSession();
            } else if (string.contains("\"You can't do that without a process to debug.\"")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ApplicationCrashed")));
                this.killSession();
            } else if (!(string.contains("Cannot access memory at address") || string.contains("mi_cmd_break_insert: Garbage following <location>") || string.contains("Undefined mi command: ") && string.contains("(missing implementation"))) {
                if (string.contains(MSG_BREAKPOINT_ERROR)) {
                    String string4;
                    BreakpointImpl<?> breakpointImpl;
                    this.setStopped();
                    int n2 = string.indexOf(MSG_BREAKPOINT_ERROR) + MSG_BREAKPOINT_ERROR.length();
                    int n3 = string.indexOf(46, n2);
                    if (n3 != -1 && (breakpointImpl = this.findBreakpoint(string4 = string.substring(n2, n3).trim())) != null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidBreakpoint", breakpointImpl.getBreakpoint())));
                        breakpointImpl.getBreakpoint().disable();
                    }
                } else if (this.pendingBreakpointMap.containsKey(n)) {
                    BreakpointImpl<?> breakpointImpl = this.pendingBreakpointMap.remove(n);
                    if (breakpointImpl != null) {
                        breakpointImpl.addError(string);
                        breakpointImpl.completeValidation(null);
                    }
                    if (this.pendingBreakpointMap.isEmpty() && this.state == State.LOADING) {
                        this.setReady();
                    }
                } else if (this.state != State.NONE) {
                    log.warning("Unexpected gdb error: " + string);
                }
            }
        }
    }

    private void validateBreakpoint(int n, Map<String, String> map) {
        boolean bl = this.breakpointValidation(n, map);
        if (!bl && this.state == State.SILENT_STOP && this.pendingBreakpointMap.isEmpty()) {
            this.setRunning();
        }
    }

    public void fireDisUpdate(boolean bl) {
        this.firePropertyChange(DIS_UPDATE, bl, !bl);
    }

    public void execAsyncOutput(int n, String string) {
        if (string.startsWith("*stopped")) {
            Map<Object, Object> map = string.length() > 9 ? this.createMapFromString(string.substring(9)) : new HashMap();
            this.stopped(n, map);
        }
    }

    public void consoleStreamOutput(int n, String string) {
        String string2 = string.endsWith(CONSOLE_MSG_END) ? string.substring(0, string.length() - 2) : (string = string + CONSOLE_MSG_END);
        CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n);
        if (commandBuffer != null) {
            commandBuffer.append(string);
        } else if (string2.toLowerCase().contains("mingw")) {
            this.mingw = true;
        } else if (string2.startsWith("Breakpoint ") && string2.contains(" at 0x")) {
            int n2 = string2.indexOf(32, 12);
            String string3 = string2.substring(11, n2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("number", string3);
            this.validateBreakpoint(n, hashMap);
        } else if (string2.contains("(no debugging symbols found)") && this.state == State.STARTING && !this.isAttaching()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoDebuggingSymbolsFound")));
            this.finish(false);
        } else if (!(string2.startsWith("Copyright ") || string2.startsWith("GDB is free software,") || string2.startsWith("welcome to change it and") || string2.contains("show copying") || string2.startsWith("There is absolutely no warranty for GDB") || string2.startsWith("Source directories searched: ") || string2.contains("LC_SEGMENT.__TEXT_addr = ") || string2.startsWith("This GDB was configured as"))) {
            if (this.programPID == 0L && string2.startsWith("process ")) {
                int n3 = string2.indexOf(32, 8);
                String string4 = n3 > 0 ? string2.substring(8, n3) : string2.substring(8);
                try {
                    this.programPID = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    log.warning("Failed to get PID from \"info proc\"");
                }
            } else if (this.programPID == 0L) {
                int n4;
                if (string2.startsWith("* 1 thread ")) {
                    int n5 = string2.indexOf(46);
                    if (n5 > 0) {
                        try {
                            this.programPID = Long.valueOf(string2.substring(11, n5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (string2.startsWith("[Switching to process ") && (n4 = string2.indexOf(32, 22)) > 0) {
                    try {
                        this.programPID = Long.valueOf(string2.substring(22, n4));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (string2.startsWith("Stopped due to shared library event")) {
                this.dlopenPending = true;
            }
        }
    }

    public void logStreamOutput(String string) {
        if (string.startsWith("&\"No source file named ")) {
            this.breakpointValidation(this.currentToken, string.substring(2, string.length() - 3));
        } else if (string.startsWith("&\"Function ") && string.endsWith("not defined.\\n\"")) {
            this.breakpointValidation(this.currentToken, string.substring(2, string.length() - 3));
        } else if (!(string.startsWith("&\"info proc") || string.startsWith("&\"info threads") || string.startsWith("&\"directory ") || string.startsWith("&\"set new-console") || string.startsWith("&\"whatis ") || string.startsWith("&\"warning: Temporarily disabling breakpoints for unloaded shared library") || string.contains("/usr/lib/ld.so"))) {
            log.finest("GD.logStreamOutput: " + string);
        }
    }

    public void statusAsyncOutput(int n, String string) {
        log.finest("GD.statusAsyncOutput[" + n + "]: " + string);
    }

    public void notifyAsyncOutput(int n, String string) {
        log.finest("GD.notifyAsyncOutput[" + n + "]: " + string);
    }

    public void targetStreamOutput(String string) {
        log.finest("GD.targetStreamOutput: " + string);
    }

    public void output(String string) {
        if (this.iotab != null) {
            if (string.contains("PR_SYSEXIT")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ExitedFromSYSEXIT")));
                this.finish(true);
            }
            if (!(this.firstOutput && this.isSolaris() && string.startsWith("PR_"))) {
                this.firstOutput = false;
                this.iotab.getOut().println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArgsToLocalVariables(String string) {
        List<String> list = this.createListFromString(string);
        GdbCallStackFrame gdbCallStackFrame = this.getCurrentCallStackFrame();
        for (String string2 : list) {
            int n;
            Map<String, String> map = this.createMapFromString(string2);
            try {
                n = Integer.parseInt(map.get("level"));
            }
            catch (Exception exception) {
                log.log(Level.INFO, "Unable to parse level number for frame: " + string2, exception);
                continue;
            }
            String string3 = map.get("args");
            List<GdbVariable> list2 = GdbUtils.createLocalsList(string3);
            List<Object> list3 = this.callstack;
            synchronized (list3) {
                if (n < this.callstack.size()) {
                    this.callstack.get(n).setArguments(list2);
                } else {
                    log.info("GD.addArgsToLocalVariables: args for unknown level " + n);
                }
            }
            if (gdbCallStackFrame == null || n != gdbCallStackFrame.getFrameNumber() || list2.isEmpty()) continue;
            log.finest("GD.addArgsToLocalVariables: Starting to add Args to localVariables");
            list3 = this.localVariables;
            synchronized (list3) {
                this.localVariables.addAll(list2);
            }
            log.finest("GD.addArgsToLocalVariables: Added " + list2.size() + " args");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalsToLocalVariables(String string) {
        List<GdbVariable> list = GdbUtils.createLocalsList(string.substring(1, string.length() - 1));
        if (!list.isEmpty()) {
            log.finest("GD.addLocalsToLocalVariables: Starting to add locals to localVariables");
            List<GdbVariable> list2 = this.localVariables;
            synchronized (list2) {
                for (GdbVariable gdbVariable : list) {
                    if (this.localVariables.contains(gdbVariable)) continue;
                    this.localVariables.add(gdbVariable);
                }
            }
            log.finest("GD.addLocalsToLocalVariables: Added " + list.size() + " locals");
        }
    }

    public String updateVariable(String string, String string2) {
        return this.evaluate(string + '=' + string2);
    }

    public void variableChanged(Object object) {
        this.firePropertyChange(PROP_VALUE_CHANGED, null, object);
    }

    public void suspend() {
        this.setState(State.STOPPED);
    }

    public void interrupt() {
        this.gdb.exec_interrupt();
    }

    public void kill(Signal signal) {
        if (this.programPID > 0L) {
            this.kill(signal, this.programPID);
        }
    }

    public void kill(Signal signal, long l) {
        if (l > 0L) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.platform == 3) {
                File file = InstalledFileLocator.getDefault().locate("bin/GdbKillProc.exe", null, false);
                if (file.exists()) {
                    arrayList.add(file.getAbsolutePath());
                }
            } else {
                try {
                    if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)KILL_PATH1)) {
                        arrayList.add(KILL_PATH1);
                    } else if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)KILL_PATH2)) {
                        arrayList.add(KILL_PATH2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!arrayList.isEmpty()) {
                arrayList.add("-s");
                arrayList.add(signal.toString());
                arrayList.add(Long.toString(l));
                String[] stringArray = arrayList.subList(1, arrayList.size()).toArray(new String[arrayList.size() - 1]);
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
                nativeProcessBuilder.setExecutable((String)arrayList.get(0)).setArguments(stringArray);
                if (signal == Signal.INT) {
                    this.skipSignal = true;
                }
                try {
                    nativeProcessBuilder.call();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.gdb.getLogger().logMessage("External Command: " + arrayList.toString());
            }
        }
    }

    public void resume() {
        this.setState(State.RUNNING);
        this.gdb.exec_continue();
    }

    public void stepInto() {
        GdbTimer.getTimer("Step").start("Step1", 10);
        this.setState(State.RUNNING);
        this.gdb.exec_step();
    }

    public void stepOver() {
        this.setState(State.RUNNING);
        this.gdb.exec_next();
    }

    public void stepI() {
        this.setState(State.RUNNING);
        this.gdb.exec_step_instruction();
    }

    public void stepOverInstr() {
        this.setState(State.RUNNING);
        this.gdb.exec_next_instruction();
    }

    public void stepOut() {
        if (!this.callstack.isEmpty() || this.callstack.get(1).isValid()) {
            this.setState(State.RUNNING);
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public void runToCursor() {
        String string = EditorContextBridge.getContext().getCurrentURL();
        if (string.length() == 0) {
            return;
        }
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        if (n < 0) {
            return;
        }
        this.removeRTCBreakpoint();
        this.rtcBreakpoint = LineBreakpoint.create((String)string, (int)n);
        this.rtcBreakpoint.setTemporary();
        this.rtcBreakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.rtcBreakpoint);
        this.resume();
    }

    private void removeRTCBreakpoint() {
        if (this.rtcBreakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.rtcBreakpoint);
            this.rtcBreakpoint = null;
        }
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (state == this.state) {
            return;
        }
        State state2 = this.state;
        this.state = state;
        this.firePropertyChange(PROP_STATE, (Object)state2, (Object)state);
    }

    private void setStarting() {
        this.setState(State.STARTING);
    }

    private void setLoading() {
        this.setState(State.LOADING);
    }

    public void setReady() {
        this.setState(State.READY);
    }

    public void setRunning() {
        this.setState(State.RUNNING);
    }

    private void setStopped() {
        this.setState(State.STOPPED);
    }

    public void setSilentStop() {
        this.setState(State.SILENT_STOP);
    }

    private void setExited() {
        this.setState(State.EXITED);
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    private static void fireBreakpointEvent(CndBreakpoint cndBreakpoint, CndBreakpointEvent cndBreakpointEvent) {
        cndBreakpoint.fireCndBreakpointChange(cndBreakpointEvent);
    }

    private void stopped(int n, Map<String, String> map) {
        String string = map.get("reason");
        if ("exited-signalled".equals(string)) {
            String string2 = map.get("signal-name");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ExitedFromSignal", (Object)string2)));
            this.finish(false);
            return;
        }
        if (this.state == State.STARTING) {
            String string3 = map.get("frame");
            if (string3 != null) {
                map = this.createMapFromString(string3);
                this.updateLastStop(map);
            }
            this.setLoading();
            return;
        }
        if (this.state != State.RUNNING) {
            if (GdbDebugger.isUnitTest()) {
                if (this.state == State.NONE && string == null) {
                    this.state = State.STOPPED;
                    this.tlog("GdbDebugger.stopped: Initial stop (main). Setting state to STOPPED");
                } else {
                    this.tlog("GdbDebugger.stopped: Stopped with state " + (Object)((Object)this.state) + " and reason " + string);
                }
            } else if (!"signal-received".equals(string)) {
                log.warning("GdbDebugger.stopped: Ignoring stop while in state " + (Object)((Object)this.state));
            }
            return;
        }
        log.finest("GD.stopped[" + GdbUtils.threadId() + "]: Reason is " + string);
        this.tlog("GD.stopped: Reason is " + string);
        this.resetThreadInfo();
        if (string != null) {
            this.setCurrentCallStackFrameNoFire(null);
            if (string.equals("exited-normally")) {
                this.finish(false);
            } else if (string.equals("breakpoint-hit")) {
                String string4;
                BreakpointImpl<?> breakpointImpl;
                String string5 = map.get("thread-id");
                this.lastStop = null;
                if (string5 != null && !string5.equals(this.currentThreadID)) {
                    this.currentThreadID = string5;
                }
                if ((breakpointImpl = this.findBreakpoint(map.get("bkptno"))) == null) {
                    String string6;
                    int n2 = this.temporaryBreakpoints.indexOf(map.get("bkptno"));
                    if (n2 >= 0) {
                        this.temporaryBreakpoints.remove(n2);
                        if (this.platform == 4) {
                            this.updateCurrentCallStack();
                            this.setStopped();
                        }
                    } else {
                        log.warning("GD.stopped: Stopped at unknown breakpoint");
                        this.gdb.exec_continue();
                    }
                    if ((string6 = map.get("frame")) != null && string6.contains("func=\"dlopen\"")) {
                        this.dlopenPending = true;
                        LastGoState lastGoState = this.lastGo;
                        this.gdb.exec_finish();
                        this.setLastGo(lastGoState);
                        return;
                    }
                } else {
                    Object obj = breakpointImpl.getBreakpoint();
                    if (obj.getSuspend() == 0 && this.lastGo == LastGoState.CONTINUE) {
                        GdbDebugger.fireBreakpointEvent(obj, new CndBreakpointEvent(obj, (Object)this, 0));
                        this.gdb.exec_continue();
                    } else {
                        this.updateCurrentCallStack();
                        GdbDebugger.fireBreakpointEvent(obj, new CndBreakpointEvent(obj, (Object)this, 0));
                        this.setStopped();
                    }
                }
                if (this.dlopenPending) {
                    this.dlopenPending = false;
                    this.checkSharedLibs();
                }
                if ((string4 = map.get("frame")) != null) {
                    map = this.createMapFromString(string4);
                    this.updateLastStop(map);
                }
                GdbTimer.getTimer("Startup").stop("Startup1");
                GdbTimer.getTimer("Startup").report("Startup1");
                GdbTimer.getTimer("Startup").free();
                GdbTimer.getTimer("Stop").mark("Stop1");
            } else if (string.equals("end-stepping-range")) {
                this.lastStop = null;
                this.updateCurrentCallStack();
                this.setStopped();
                String string7 = map.get("frame");
                if (string7 != null) {
                    map = this.createMapFromString(string7);
                    this.updateLastStop(map);
                }
                if (GdbTimer.getTimer("Step").getSkipCount() == 0) {
                    GdbTimer.getTimer("Step").stop("Step1");
                    GdbTimer.getTimer("Step").report("Step1");
                }
            } else if (string.equals("shlib-event")) {
                this.checkSharedLibs();
            } else if (string.equals("signal-received")) {
                this.signalReceived(map);
            } else if (string.equals("function-finished") && this.dlopenPending) {
                this.dlopenPending = false;
                this.checkSharedLibs();
            } else if (!string.startsWith("exited")) {
                this.gdb.stack_list_frames();
                this.setStopped();
            } else {
                this.setStopped();
                this.finish(false);
            }
        } else if (this.dlopenPending) {
            this.dlopenPending = false;
            this.checkSharedLibs();
        } else {
            this.gdb.stack_list_frames();
            this.setStopped();
        }
    }

    private void updateLastStop(Map<String, String> map) {
        String string = map.get("fullname");
        String string2 = map.get("line");
        if (string != null && string2 != null) {
            this.lastStop = string + ":" + string2;
        }
    }

    private void signalReceived(Map<String, String> map) {
        String string = map.get("signal-name");
        if (this.skipSignal) {
            if ("SIGCONT".equals(string)) {
                this.skipSignal = false;
                this.resume();
                return;
            }
            if ("SIGINT".equals(string)) {
                this.gdb.stack_list_frames();
                this.setStopped();
                return;
            }
            if ("SIGTRAP".equals(string) && this.platform == 3) {
                this.skipSignal = false;
                this.gdb.stack_list_frames();
                this.setStopped();
                return;
            }
        }
        this.skipSignal = false;
        if (this.state == State.RUNNING) {
            String string2 = map.get("thread-id");
            if (string2 != null && !string2.equals(this.currentThreadID)) {
                this.currentThreadID = string2;
            }
            this.sig = string;
            String string3 = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_DISCARD_STOP");
            String string4 = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_DISCARD_CONTINUE");
            String string5 = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_PASS_CONTINUE");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_SignalReceived", (Object)map.get("signal-name"), (Object)map.get("signal-meaning")), NbBundle.getMessage(GdbDebugger.class, (String)"LBL_SignalReceived"), -1, 1, (Object[])new String[]{string3, string4, string5}, (Object)string3);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (object == string3) {
                this.gdb.handle(string, GdbProxy.HandleAction.nopass);
                this.gdb.stack_list_frames();
                this.setStopped();
            } else if (object == string4) {
                this.gdb.handle(string, GdbProxy.HandleAction.nopass);
                this.gdb.exec_continue();
            } else if (object == string5) {
                this.gdb.handle(string, GdbProxy.HandleAction.pass);
                this.gdb.exec_continue();
            }
        }
    }

    private Map<String, ShareInfo> createShareTab(String string) {
        HashMap<String, ShareInfo> hashMap = new HashMap<String, ShareInfo>();
        if (this.platform == 4) {
            String string2;
            String string3;
            Map<String, String> map;
            int n;
            int n2 = 0;
            while ((n = string.indexOf("shlib-info=", n2 + 1)) > 0) {
                map = this.createMapFromString(string.substring(n2 + 12, n - 2));
                string3 = map.get("path");
                string2 = map.get("dyld-addr");
                if (string3 != null && string2 != null) {
                    hashMap.put(string3, new ShareInfo(string3, string2));
                }
                n2 = n;
            }
            map = this.createMapFromString(string.substring(n2 + 12, string.length() - 1));
            string3 = map.get("path");
            string2 = map.get("dyld-addr");
            if (string3 != null && string2 != null) {
                hashMap.put(string3, new ShareInfo(string3, string2));
            }
        } else {
            for (String string4 : string.split("\\\\n")) {
                if (string4.length() <= 0 || string4.charAt(0) != '0') continue;
                String[] stringArray = string4.split("\\s+", 4);
                hashMap.put(stringArray[3], new ShareInfo(stringArray[3], stringArray[0]));
            }
        }
        return hashMap;
    }

    private void checkSharedLibs() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string = GdbDebugger.this.gdb.info_share(true).getResponse();
                Map map = GdbDebugger.this.createShareTab(string);
                if (map.size() > GdbDebugger.this.shareTab.size()) {
                    log.fine("GD.checkSharedLibs: Added a shared library");
                    ShareInfo shareInfo = GdbDebugger.this.getNewShareInfo(map);
                    if (shareInfo.isMatchingProject()) {
                        GdbDebugger.this.gdb.environment_directory(shareInfo.getSourceDirectories());
                    }
                    GdbDebugger.this.firePropertyChange(GdbDebugger.PROP_SHARED_LIB_LOADED, null, shareInfo.getPath());
                } else {
                    log.fine("GD.checkSharedLibs: Closed a shared library");
                }
                GdbDebugger.this.shareTab = map;
                if (GdbDebugger.this.lastGo == LastGoState.CONTINUE) {
                    GdbDebugger.this.gdb.exec_continue();
                } else {
                    GdbDebugger.this.stepOutOfDlopen();
                }
            }
        });
    }

    private ShareInfo getNewShareInfo(Map<String, ShareInfo> map) {
        for (Map.Entry<String, ShareInfo> entry : map.entrySet()) {
            if (this.shareTab.containsKey(entry.getKey())) continue;
            return entry.getValue();
        }
        assert (false) : "No new shared library found";
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stepOutOfDlopen() {
        State state = this.state;
        this.setSilentStop();
        String string = this.gdb.stack_list_framesEx().getResponse();
        string = string.substring(7, string.length() - 1);
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        for (String string2 : this.createListFromString(string)) {
            Map<String, String> map = this.createMapFromString(string2);
            String string3 = map.get("func");
            if (string3 != null && string3.equals("dlopen") && !bl2) {
                if (this.platform != 4) {
                    this.gdb.stack_select_frame(n);
                    this.setStopOnSolibEvents(false);
                    this.gdb.exec_finish();
                    this.setStopOnSolibEvents(true);
                    this.gdb.exec_next();
                    this.state = state;
                    return;
                }
                bl2 = true;
            } else {
                String string4 = map.get("fullname");
                if (string4 != null) {
                    String string5;
                    File file = new File(this.getOSPath(string4));
                    boolean bl3 = bl = file != null && file.exists();
                    if (bl && bl2 && (string5 = map.get("line")) != null) {
                        int n2 = Integer.parseInt(string5) + 1;
                        this.gdb.break_insert_temporary(string4 + ":" + n2);
                        this.gdb.exec_continue();
                        return;
                    }
                } else {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl) {
            this.gdb.exec_next();
        } else if (this.lastStop != null) {
            int n3 = this.lastStop.lastIndexOf(58);
            int n4 = Integer.parseInt(this.lastStop.substring(n3 + 1)) + 1;
            this.gdb.break_insert_temporary(this.lastStop.substring(0, n3 + 1) + n4);
            this.gdb.exec_continue();
        }
        this.state = state;
    }

    private void setStopOnSolibEvents(boolean bl) {
        if (this.gdbVersion < 6.8) {
            this.gdb.gdb_set("stop-on-solib-event", bl ? "1" : "0");
        }
    }

    public String getOSPath(String string) {
        if (string == null) {
            return null;
        }
        if (this.platform == 3) {
            if (this.isCygwin()) {
                return WindowsSupport.getInstance().convertFromCygwinPath(string);
            }
            if (this.isMinGW()) {
                return WindowsSupport.getInstance().convertFromMSysPath(string);
            }
        }
        return string;
    }

    private void threadsViewInit() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");
        properties.getProperties("ThreadState").setBoolean("visible", false);
        properties.getProperties("ThreadSuspended").setBoolean("visible", false);
    }

    public void addPendingBreakpoint(int n, BreakpointImpl breakpointImpl) {
        this.pendingBreakpointMap.put(n, breakpointImpl);
    }

    private boolean breakpointValidation(int n, Object object) {
        BreakpointImpl<?> breakpointImpl = this.pendingBreakpointMap.get(n);
        if (breakpointImpl != null) {
            if (object instanceof String) {
                breakpointImpl.addError((String)object);
            } else if (object instanceof Map || object == null) {
                this.pendingBreakpointMap.remove(n);
                Map map = (Map)object;
                breakpointImpl.completeValidation(map);
                if (map != null && breakpointImpl.getBreakpoint().getValidity() == Breakpoint.VALIDITY.VALID && breakpointImpl.getBreakpoint().isEnabled()) {
                    String string = (String)map.get("fullname");
                    String string2 = (String)map.get("file");
                    String string3 = (String)map.get("line");
                    if (this.firstBPfullname != null && this.firstBPfullname.equals(string) && this.firstBPline != null && this.firstBPline.equals(string3)) {
                        this.continueAfterFirstStop = false;
                    } else if (this.platform == 4 && this.firstBPfile != null && this.firstBPfile.equals(string2) && this.firstBPline != null && this.firstBPline.equals(string3)) {
                        this.continueAfterFirstStop = false;
                    }
                }
            }
            if (this.pendingBreakpointMap.isEmpty() && this.state == State.LOADING) {
                this.setReady();
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            String string = (String)map.get("number");
            String string4 = (String)map.get("fullname");
            String string5 = (String)map.get("file");
            String string6 = (String)map.get("line");
            String string7 = (String)map.get("func");
            if (string != null && (string.equals("1") || string.equals("2") && string7 != null && string7.equals("WinMain") && this.platform == 3)) {
                this.firstBPfullname = string4;
                this.firstBPfile = string5;
                this.firstBPline = string6;
            }
            this.temporaryBreakpoints.add(string);
        }
        return false;
    }

    public static void debugCore(String string, ProjectInformation projectInformation) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.CoreAttach(string), projectInformation, ExecutionEnvironmentFactory.getLocal());
    }

    public static void attachGdbServer(String string, ProjectInformation projectInformation) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.GdbServerAttach(string), projectInformation, ExecutionEnvironmentFactory.getLocal());
    }

    public static void attach(Long l, ProjectInformation projectInformation, ExecutionEnvironment executionEnvironment) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.PidAttach(l), projectInformation, executionEnvironment);
    }

    private static void attach2Target(AttachTarget attachTarget, ProjectInformation projectInformation, ExecutionEnvironment executionEnvironment) throws DebuggerStartException {
        Project project = projectInformation.getProject();
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            makeConfiguration = (MakeConfiguration)makeConfiguration.cloneConf();
            makeConfiguration.setDevelopmentHost(new DevelopmentHostConfiguration(executionEnvironment));
            String string = GdbDebugger.getBuildResult(projectInformation, makeConfiguration);
            if (attachTarget.checkExecutable() && !GdbDebugger.isExecutableOrSharedLibrary(makeConfiguration, string)) {
                string = null;
            }
            if (string != null) {
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, ProjectActionEvent.Type.CHECK_EXECUTABLE, projectInformation.getDisplayName(), string, makeConfiguration, null, false);
                DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)SESSION_PROVIDER_ID, (Object[])new Object[]{projectActionEvent, attachTarget}));
                if (debuggerEngineArray == null) {
                    throw new DebuggerStartException(new InternalError());
                }
            } else {
                String string2 = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
                String string3 = string2.length() > 0 ? (GdbDebugger.isAbsolute(makeConfiguration, string2) ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidBuildResult", (Object)string2) : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_RelativePathInBuildResult")) : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoBuildResult");
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3));
            }
        }
    }

    private static String getBuildResult(ProjectInformation projectInformation, MakeConfiguration makeConfiguration) {
        String string = makeConfiguration.getAbsoluteOutputValue().replace("\\", "/");
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        PathMap pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
        string = pathMap.getRemotePath(string, true);
        if (string.length() == 0) {
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(projectInformation.getProject(), ProjectActionEvent.Type.CHECK_EXECUTABLE, projectInformation.getDisplayName(), string, makeConfiguration, null, false);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
            string = makeConfiguration.getAbsoluteOutputValue().replace("\\", "/");
        }
        return string;
    }

    private static boolean isAbsolute(MakeConfiguration makeConfiguration, String string) {
        if (GdbDebugger.getDevelopmentHostPlatform(makeConfiguration) == 3) {
            return string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == '/';
        }
        return string.length() > 0 && string.charAt(0) == '/';
    }

    private static int getDevelopmentHostPlatform(MakeConfiguration makeConfiguration) {
        return HostInfoProvider.getPlatform((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment());
    }

    private static boolean isExecutableOrSharedLibrary(MakeConfiguration makeConfiguration, String string) {
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        if (makeConfiguration.isApplicationConfiguration() || makeConfiguration.isDynamicLibraryConfiguration()) {
            return true;
        }
        if (makeConfiguration.isMakefileConfiguration()) {
            if (GdbDebugger.getDevelopmentHostPlatform(makeConfiguration) == 3) {
                if (string.endsWith(".dll")) {
                    return false;
                }
                if (!string.endsWith(".exe")) {
                    string = string + ".exe";
                }
            }
            try {
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)string)) {
                    return false;
                }
                if (executionEnvironment.isLocal()) {
                    File file = new File(string);
                    assert (file.exists());
                    String string2 = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file)));
                    if (string2 != null && string2.startsWith("application/x-exe")) {
                        return true;
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stackUpdate(List<String> list) {
        List<GdbCallStackFrame> list2 = this.callstack;
        synchronized (list2) {
            for (Object object : this.callstack) {
                object.destroy();
            }
            this.callstack.clear();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                object = list.get(i);
                Map<String, String> map = this.createMapFromString((String)object);
                String string = map.get("func");
                String string2 = map.get("file");
                String string3 = map.get("fullname");
                String string4 = map.get("line");
                String string5 = map.get("addr");
                String string6 = map.get("from");
                if (string3 == null && string2 != null) {
                    if (string2.charAt(0) == '/') {
                        string3 = string2;
                        log.finest("GD.stackUpdate: Setting fullname from file");
                    } else {
                        string3 = this.runDirectory + string2;
                        log.finest("GD.stackUpdate: Setting fullname from runDirectory + file");
                    }
                }
                this.callstack.add(i, new GdbCallStackFrame(this, string, string2, string3, string4, string5, i, string6));
            }
        }
        if (!list.isEmpty()) {
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, 0, 1);
        }
    }

    public void setCurrentThread(String string) {
        int n;
        if (string.length() > 0 && Character.isDigit(string.charAt(0)) && (n = string.indexOf(32)) > 0) {
            this.resetThreadInfo();
            this.gdb.thread_select(string.substring(0, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GdbVariable> getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        List<GdbVariable> list = this.localVariables;
        synchronized (list) {
            return new ArrayList<GdbVariable>(this.localVariables);
        }
    }

    public String evaluate(String string) {
        int n;
        boolean bl;
        if (this.gdb == null) {
            return null;
        }
        if (!this.isStopped()) {
            return null;
        }
        boolean bl2 = bl = string.indexOf(40) != -1;
        if (bl) {
            this.suspendBreakpointsAndSignals();
        }
        CommandBuffer commandBuffer = this.gdb.data_evaluate_expressionEx('\"' + string + '\"');
        if (bl) {
            this.restoreBreakpointsAndSignals();
        }
        if (commandBuffer.isError()) {
            String string2 = commandBuffer.getError();
            if (string2.startsWith("\"The program being debugged was signaled while in a function called from GDB")) {
                string2 = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_WatchedFunctionAborted");
            }
            return string2;
        }
        String string3 = commandBuffer.getResponse();
        if (string3.startsWith(VALUE_PREFIX)) {
            string3 = string3.substring(VALUE_PREFIX.length() + 1, string3.length() - 1);
        } else {
            log.severe("GDBDebugger.evaluate: unexpected response " + string3 + " for expression " + string);
        }
        if (string3.startsWith("@0x") && (string3 = (commandBuffer = this.gdb.print(string)).getResponse()).length() > 0 && string3.charAt(0) == '$' && (n = string3.indexOf(61)) != -1 && n + 2 < string3.length()) {
            string3 = string3.substring(n + 2, string3.length()).replace(CONSOLE_MSG_END, "").trim();
        }
        if (this.getPlatform() == 4) {
            string3 = GdbUtils.mackHack(string3);
        }
        return string3.length() > 0 ? string3 : null;
    }

    public Map<String, TypeInfo> getTypeInfoCache() {
        return ticache;
    }

    public String requestValue(String string) {
        try {
            return this.requestValueEx(string);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String requestValueEx(String string) throws GdbErrorException {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED) {
            CommandBuffer commandBuffer = this.gdb.data_evaluate_expressionEx(string);
            String string2 = commandBuffer.getResponse();
            if (string2.length() == 0 || !commandBuffer.isOK()) {
                if (commandBuffer.isError()) {
                    log.fine("GD.requestValue Error[" + commandBuffer + "]");
                    throw new GdbErrorException('>' + commandBuffer.getError() + '<');
                }
                log.fine("GD.requestValue Failure[" + commandBuffer + "]");
                return "";
            }
            return string2.substring(7, string2.length() - 1);
        }
        return null;
    }

    public String requestWhatis(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && string != null && string.length() > 0) {
            CommandBuffer commandBuffer = this.gdb.whatis(string);
            String string2 = commandBuffer.getResponse();
            if (string2.length() == 0 || !commandBuffer.isOK()) {
                if (commandBuffer.isError()) {
                    log.fine("GD.requestWhatis Error[" + commandBuffer + "]");
                    return "";
                }
                log.fine("GD.requestWhatis Failure[" + commandBuffer + "]");
                return "";
            }
            return string2.substring(7, string2.length() - 2);
        }
        return null;
    }

    public String requestBaseClassType(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && string != null && string.length() > 0) {
            CommandBuffer commandBuffer = this.gdb.symbol_type("class " + string);
            String string2 = commandBuffer.getResponse();
            if (string2.length() == 0 || !commandBuffer.isOK()) {
                if (commandBuffer.isError()) {
                    log.fine("GD.requestSymbolType Error[" + commandBuffer + "]");
                    return "";
                }
                log.fine("GD.requestSymbolType Failure[" + commandBuffer + "]. Returning original type");
                return string;
            }
            log.fine("GD.requestSymbolType[" + commandBuffer + "]: " + string + " --> [" + string2 + "]");
            return string2.substring(7, string2.length() - 2);
        }
        return null;
    }

    public String requestSymbolTypeFromName(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && string != null && string.length() > 0) {
            CommandBuffer commandBuffer = this.gdb.symbol_type(string);
            String string2 = commandBuffer.getResponse();
            if (string2.length() == 0 || !commandBuffer.isOK()) {
                if (commandBuffer.isError()) {
                    log.fine("GD.requestSymbolTypeFromName Error[" + commandBuffer + "]");
                    return "";
                }
                log.fine("GD.requestSymbolTypeFromName Failure[" + commandBuffer + "]. Returning original type");
                return "";
            }
            log.fine("GD.requestSymbolTypeFromName[" + commandBuffer + "]: " + string + " --> [" + string2 + "]");
            return string2.substring(7, string2.length() - 2);
        }
        return null;
    }

    private void suspendBreakpointsAndSignals() {
        this.gdb.break_disableCMD(new Integer[0]).send();
        this.gdb.set_unwindonsignal("on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreBreakpointsAndSignals() {
        this.gdb.set_unwindonsignal("off");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Map<Integer, BreakpointImpl<?>> map = this.breakpointList;
        synchronized (map) {
            for (Map.Entry<Integer, BreakpointImpl<?>> entry : this.breakpointList.entrySet()) {
                if (!entry.getValue().getBreakpoint().isEnabled()) continue;
                arrayList.add(entry.getKey());
            }
        }
        this.gdb.break_enableCMD(arrayList.toArray(new Integer[arrayList.size()])).send();
    }

    public List<GdbCallStackFrame> getCallStack() {
        return this.callstack;
    }

    public int getStackDepth() {
        return this.callstack.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GdbCallStackFrame getCurrentCallStackFrame() {
        List<GdbCallStackFrame> list = this.callstack;
        synchronized (list) {
            if (this.currentCallStackFrame != null) {
                return this.currentCallStackFrame;
            }
            if (!this.callstack.isEmpty()) {
                return this.callstack.get(0);
            }
            return null;
        }
    }

    public void setCurrentCallStackFrame(GdbCallStackFrame gdbCallStackFrame) {
        if (gdbCallStackFrame.isValid()) {
            GdbCallStackFrame gdbCallStackFrame2 = this.setCurrentCallStackFrameNoFire(gdbCallStackFrame);
            this.updateLocalVariables(gdbCallStackFrame.getFrameNumber());
            if (gdbCallStackFrame2 == gdbCallStackFrame) {
                return;
            }
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, (Object)gdbCallStackFrame2, (Object)gdbCallStackFrame);
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GdbCallStackFrame setCurrentCallStackFrameNoFire(GdbCallStackFrame gdbCallStackFrame) {
        GdbCallStackFrame gdbCallStackFrame2;
        List<GdbCallStackFrame> list = this.callstack;
        synchronized (list) {
            gdbCallStackFrame2 = this.getCurrentCallStackFrame();
            if (gdbCallStackFrame == gdbCallStackFrame2) {
                return gdbCallStackFrame;
            }
            this.currentCallStackFrame = gdbCallStackFrame;
        }
        return gdbCallStackFrame2;
    }

    public void popTopmostCall() {
        if (!this.callstack.isEmpty() && this.callstack.get(1).isValid()) {
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public Map<Integer, BreakpointImpl<?>> getBreakpointList() {
        return this.breakpointList;
    }

    public static BreakpointImpl<?> getBreakpointImpl(Breakpoint breakpoint) {
        GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
        if (gdbDebugger != null) {
            for (BreakpointImpl<?> breakpointImpl : gdbDebugger.breakpointList.values()) {
                if (breakpointImpl.getBreakpoint() != breakpoint) continue;
                return breakpointImpl;
            }
        }
        return null;
    }

    private BreakpointImpl<?> findBreakpoint(String string) {
        try {
            return this.breakpointList.get(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getBestPath(String string) {
        if ((string = this.pathMap.getRemotePath(string, true)).startsWith(this.baseDir + '/')) {
            return string.substring(this.baseDir.length() + 1);
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public boolean isCygwin() {
        return this.cygwin;
    }

    private boolean isMinGW() {
        return this.mingw;
    }

    private boolean isSolaris() {
        return this.platform == 1 || this.platform == 0;
    }

    public boolean isCplusPlus() {
        return this.cplusplus;
    }

    public Disassembly getDisassembly() {
        return this.disassembly;
    }

    public void setCurrentBreakpoint(CndBreakpoint cndBreakpoint) {
        this.currentBreakpoint = cndBreakpoint;
    }

    public void setLastGo(LastGoState lastGoState) {
        this.lastGo = lastGoState;
    }

    private boolean isAttaching() {
        ProjectActionEvent projectActionEvent = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
        return projectActionEvent.getType() == DEBUG_ATTACH;
    }

    private void killSession() {
        ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
    }

    private void tlog(String string) {
        if (GdbDebugger.isUnitTest() && tlog.isLoggable(Level.WARNING)) {
            System.out.println("    " + string);
        }
    }

    public String getCharSetEncoding() {
        String string = this.execEnv.isRemote() ? remoteCharSet : System.getProperty("sun.jnu.encoding");
        return string;
    }

    public Map<String, String> createMapFromString(String string) {
        return GdbUtils.createMapFromString(string, this.getCharSetEncoding());
    }

    public List<String> createListFromString(String string) {
        return GdbUtils.createListFromString(string, this.getCharSetEncoding());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShareInfo {
        private final String path;
        private final String addr;
        private List<String> sourceDirs;
        private Project project;

        public ShareInfo(String string, String string2) {
            this.path = string;
            this.addr = string2;
            this.sourceDirs = null;
            this.project = null;
        }

        public String getPath() {
            return this.path;
        }

        public String getAddress() {
            return this.addr;
        }

        public List<String> getSourceDirectories() {
            if (this.sourceDirs == null) {
                NativeProject nativeProject;
                this.sourceDirs = new ArrayList<String>();
                if (this.project != null && (nativeProject = (NativeProject)this.project.getLookup().lookup(NativeProject.class)) != null) {
                    this.sourceDirs.add(nativeProject.getProjectRoot());
                    for (String string : nativeProject.getSourceRoots()) {
                        this.sourceDirs.add(string);
                    }
                }
            }
            return this.sourceDirs;
        }

        public boolean isMatchingProject() {
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                MakeConfiguration makeConfiguration;
                ProjectConfiguration projectConfiguration;
                ProjectConfigurationProvider projectConfigurationProvider = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
                if (projectConfigurationProvider == null || !((projectConfiguration = projectConfigurationProvider.getActiveConfiguration()) instanceof MakeConfiguration) || !(makeConfiguration = (MakeConfiguration)projectConfiguration).isDynamicLibraryConfiguration()) continue;
                String string = FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
                String string2 = string + "/" + makeConfiguration.getOutputValue();
                if (!(string2 = makeConfiguration.expandMacros(string2)).equals(this.path)) continue;
                this.project = project;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LastGoState {
        CONTINUE,
        FINISH,
        STEP,
        NEXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NONE,
        STARTING,
        LOADING,
        READY,
        RUNNING,
        STOPPED,
        SILENT_STOP,
        EXITED;

    }
}

