/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ParamEditor
extends JPanel {
    private static final Dimension valueSize = new Dimension(400, 150);
    private Dialog dialog = null;
    private Dialog d2 = null;
    private DialogDescriptor editDialog = null;
    private String errorMessage = null;
    private boolean dialogOK = false;
    private String name = "";
    private String value = "";
    private Editable editable;
    private Condition condition;
    private String title = "";
    private boolean repainting = false;

    public ParamEditor(String string, String string2, Editable editable, Condition condition, String string3) {
        this.name = string;
        this.value = string2;
        this.editable = editable;
        this.condition = condition;
        this.title = string3;
        this.initialize();
    }

    public boolean getDialogOK() {
        return this.dialogOK;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void initialize() {
        JComponent jComponent;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 15, 4, 15);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(4, 15, 4, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 7;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(4, 0, 4, 15);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.gridheight = 3;
        gridBagConstraints4.gridwidth = 8;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 15, 4, 15);
        JLabel jLabel = new JLabel();
        jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_NameA11yDesc"));
        if (this.name == null || this.name.length() == 0) {
            this.getAccessibleContext().setAccessibleDescription(this.title);
        } else {
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_ParamEditorA11yDesc", (Object)this.title, (Object)this.name));
        }
        String string = NbBundle.getMessage((Class)ParamEditor.class, (String)"MON_Param_Name");
        if (this.editable == Editable.BOTH) {
            jComponent = new JTextField(25);
            jComponent.addFocusListener(new FocusListener((JTextField)jComponent){
                private final /* synthetic */ JTextField val$nameText;
                {
                    this.val$nameText = jTextField;
                }

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    ParamEditor.this.name = this.val$nameText.getText();
                }
            });
            jLabel.setLabelFor(jComponent);
            ((JTextField)jComponent).getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_NameTextFieldA11yName"));
            jComponent.setToolTipText(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_NameTextFieldA11yDesc"));
            ((JTextComponent)jComponent).setText(this.name);
            jComponent.setBackground(Color.white);
            ((JTextComponent)jComponent).setEditable(this.editable == Editable.BOTH);
            this.add((Component)jLabel, gridBagConstraints2);
            this.add((Component)jComponent, gridBagConstraints3);
        } else {
            this.add((Component)jLabel, gridBagConstraints);
            string = string.concat(this.name);
        }
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        jComponent = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jComponent, (String)NbBundle.getMessage((Class)ParamEditor.class, (String)"MON_Param_Value"));
        ((JLabel)jComponent).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_ValueA11yDesc"));
        ++gridBagConstraints2.gridy;
        this.add((Component)jComponent, gridBagConstraints);
        final JTextArea jTextArea = new JTextArea();
        jTextArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ParamEditor.this.value = jTextArea.getText();
            }
        });
        ((JLabel)jComponent).setLabelFor(jTextArea);
        jTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_ValueTextAreaA11yName"));
        jTextArea.setToolTipText(NbBundle.getMessage((Class)ParamEditor.class, (String)"ACS_MON_ValueTextAreaA11yDesc"));
        if (this.editable == Editable.NEITHER) {
            jTextArea.setEditable(false);
            jTextArea.setBackground(this.getBackground());
            jTextArea.setForeground(Color.BLACK);
            jTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        jTextArea.setText(this.value);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(valueSize);
        this.add((Component)jScrollPane, gridBagConstraints4);
        this.repaint();
    }

    public void showDialog() {
        if (this.editable == Editable.NEITHER) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)this, this.title, -1, -1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
        } else {
            this.editDialog = new DialogDescriptor((Object)this, this.title, true, 2, DialogDescriptor.CANCEL_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParamEditor.this.evaluateInput();
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
            this.dialog.setVisible(true);
            this.repaint();
        }
    }

    public void evaluateInput() {
        if (this.editDialog.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
            this.dialog.dispose();
            this.dialogOK = false;
            return;
        }
        if (this.editable == Editable.NEITHER) {
            this.dialog.dispose();
            this.dialogOK = false;
            return;
        }
        this.errorMessage = null;
        if (this.name.equals("")) {
            this.errorMessage = NbBundle.getMessage((Class)ParamEditor.class, (String)"MSG_no_name");
        } else if (this.condition == Condition.COOKIE && this.name.equalsIgnoreCase("jsessionid")) {
            this.errorMessage = NbBundle.getMessage((Class)ParamEditor.class, (String)"MSG_no_jsession");
        } else if (this.condition == Condition.VALUE && this.value.equals("")) {
            this.errorMessage = NbBundle.getMessage((Class)ParamEditor.class, (String)"MSG_no_value");
        } else if (this.condition == Condition.HEADER && this.name.equalsIgnoreCase("cookie") && (this.value.indexOf("jsessionid") > -1 || this.value.indexOf("JSESSIONID") > -1)) {
            this.errorMessage = NbBundle.getMessage((Class)ParamEditor.class, (String)"MSG_no_jsession");
        }
        if (this.errorMessage == null) {
            this.dialog.dispose();
            this.dialogOK = true;
        } else {
            this.editDialog.setValue(NotifyDescriptor.CLOSED_OPTION);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.errorMessage, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public void repaint() {
        super.repaint();
        if (this.dialog != null && !this.repainting) {
            this.repainting = true;
            this.dialog.repaint();
            this.repainting = false;
        }
    }

    static class Condition {
        private String condition;
        public static final Condition NONE = new Condition("none");
        public static final Condition VALUE = new Condition("value");
        public static final Condition COOKIE = new Condition("cookie");
        public static final Condition HEADER = new Condition("header");

        private Condition(String string) {
            this.condition = string;
        }

        public String toString() {
            return this.condition;
        }
    }

    static class Editable {
        private String editable;
        public static final Editable BOTH = new Editable("both");
        public static final Editable VALUE = new Editable("value");
        public static final Editable NEITHER = new Editable("neither");

        private Editable(String string) {
            this.editable = string;
        }

        public String toString() {
            return this.editable;
        }
    }
}

